/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeAggregatesInAppropriateSubQueries;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class DistributeRunningMovingAnalyticAggregatesToSubquery
extends RQPTransformation {
    private static final String PROP_BOOLEAN_IS_DISTRIBUTED = "isDistributed";

    public DistributeRunningMovingAnalyticAggregatesToSubquery() {
        this.mName = "DistributeRunningMovingAnalyticAggregatesToSubquery";
        this.mPassNumbers = new int[]{56};
        this.mTypes = new int[]{201035, 201033};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(PROP_BOOLEAN_IS_DISTRIBUTED, true);
        RQPQuery parentRQPQuery = RQPNode.getRQPQuery(node).getParentRQPQuery();
        RQPQuery queryToDistributeTo = this.runningMovingAnalyticOverSummaryQuery(node) ? parentRQPQuery.getOrCreateAnalyticSubquery(environment) : parentRQPQuery.getDefaultTabularQuery();
        DistributeAggregatesInAppropriateSubQueries.addAggregateToSubqueryAndCreateReferenceToIt(node, queryToDistributeTo, (V5AggregateFunction)node, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        if (node.getPropertyValue(PROP_BOOLEAN_IS_DISTRIBUTED) != null) {
            this.traceNodeCondition(false, "Running/moving/analytic function is already distributed..", xqeTrace);
            return false;
        }
        if (!ExpressionAnalyzer.hasAggregateAncestor((V5AggregateFunction)node)) {
            this.traceNodeCondition(false, "Transformation only applied if running/moving/analytic in a nested scope.", xqeTrace);
            return false;
        }
        if (this.runningMovingAnalyticOverDetails(node.getChild(0))) {
            if (node.getAncestorOfType(801025) != null) {
                return false;
            }
            this.traceNodeCondition(true, "Running/moving/analytic function will be distributed to tabular query.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "Running/moving/analytic operand is a summarized value.", xqeTrace);
        return false;
    }

    private boolean runningMovingAnalyticOverDetails(IXQEQueryNode expr) {
        if (expr == null) {
            return true;
        }
        if (ExpressionAnalyzer.exprOrRefExprHasAnalyticOrRunningMovingFunctions(expr)) {
            return true;
        }
        return !ExpressionAnalyzer.exprOrRefExprHasAggregate(expr);
    }

    private boolean runningMovingAnalyticOverSummaryQuery(IXQEQueryNode expr) {
        IXQEQueryNode[] dataItemRefs = expr.getDescendantsOfType(801009, false);
        for (int i = 0; i < dataItemRefs.length; ++i) {
            RQPDataItemRef dataItemRef = (RQPDataItemRef)dataItemRefs[i];
            RQPQuery referencedQuery = dataItemRef.getQuery();
            if (referencedQuery.getType() != 801024) continue;
            return true;
        }
        return false;
    }
}

