/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.decomposition.DecomposeQRD;

public class GenerateQRDForDynamicSQSQuery
extends Transformation {
    public GenerateQRDForDynamicSQSQuery() {
        this.mName = "GenerateQRDForDynamicSQSQuery";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QueryResultDefinition qrd = DecomposeQRD.generateQRDForSubQuery((V5Query)node, environment);
        if (qrd != null) {
            qrd.setPropertyValue("name", ((V5Query)node).getV5QueryName() + "_qrd");
            node.addChild(qrd);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        V5Query query = (V5Query)node;
        if (query.getPropertyValue("stitchQuery") != null) {
            this.traceNodeCondition(true, "This query is a stitch of dynamic SQS queries.", xqeTrace);
            return true;
        }
        if (query.getPropertyValue("queryForNonDSQSItems") != null) {
            this.traceNodeCondition(true, "This query is created to plan non-DSQS item in mixed report.", xqeTrace);
            return true;
        }
        if (query.getDynamicSQS() == null) {
            this.traceNodeCondition(false, "This query is not a dynamic summary query subject.", xqeTrace);
            return false;
        }
        if (query.getFirstChildByType(101055) != null) {
            this.traceNodeCondition(true, "This query has already QRD.", xqeTrace);
            return false;
        }
        return true;
    }
}

