/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS.CreateV5QueryForDynamicSQS;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class RemoveRedundantProjectionsInDynamicSQS
extends Transformation {
    public RemoveRedundantProjectionsInDynamicSQS() {
        this.mName = "RemoveRedundantProjectionsInDynamicSQS";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<V5DataItem> gpItems = this.getSQSGroupingItems((V5Query)node);
        ArrayList<V5DataItem> duplicateCols = new ArrayList<V5DataItem>();
        ArrayList<V5DataItem> staticGpColumns = new ArrayList<V5DataItem>();
        for (V5DataItem di : gpItems) {
            if (di.getPropertyValue("potentialDuplicateColumn") != null) {
                duplicateCols.add(di);
                continue;
            }
            staticGpColumns.add(di);
        }
        for (V5DataItem dynDi : duplicateCols) {
            V5DataItem duplicateDi = null;
            for (V5DataItem staticDi : staticGpColumns) {
                if (!dynDi.getExpression(true).isSameExpression(staticDi.getExpression(true), false)) continue;
                duplicateDi = staticDi;
                break;
            }
            if (duplicateDi == null) continue;
            this.removeDuplicateColumns(staticGpColumns, duplicateDi, (V5Query)node);
        }
        node.removeProperty("potentialDuplicateColumn");
    }

    private void removeDuplicateColumns(List<V5DataItem> staticGpColumns, V5DataItem duplicateStaticColumn, V5Query dynamicSQSQuery) {
        String duplicateColumnName = duplicateStaticColumn.getNameProperty();
        V5Selection selection = dynamicSQSQuery.getV5Selection();
        selection.detachChild(duplicateStaticColumn);
        staticGpColumns.remove(duplicateStaticColumn);
        IQuerySubject currentSQS = dynamicSQSQuery.getDynamicSQS();
        List<V5Query> queries = this.getDynamicSQSQueriesReferenceMe(currentSQS, dynamicSQSQuery);
        block0: for (V5Query query : queries) {
            List<V5DataItem> gpItems = this.getStaticGroupingItems(query.getV5Selection());
            for (V5DataItem di : gpItems) {
                if (!di.getNameProperty().equals(duplicateColumnName)) continue;
                this.removeDuplicateColumns(gpItems, di, query);
                continue block0;
            }
        }
    }

    private List<V5Query> getDynamicSQSQueriesReferenceMe(IQuerySubject me, V5Query myQuery) {
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(myQuery);
        ArrayList<V5Query> queries = new ArrayList<V5Query>();
        for (IXQEQueryNode child : querySet.getChildren()) {
            V5Query query;
            TreeSet<IQuerySubject> referencedSQS;
            if (child.getType() != 101006 || (referencedSQS = (query = (V5Query)child).getReferencedDynamicSQS()) == null || !referencedSQS.contains(me) || query.getDynamicSQS() == null) continue;
            queries.add(query);
        }
        return queries;
    }

    private List<V5DataItem> getStaticGroupingItems(V5Selection selection) {
        IXQEQueryNode[] dataItems = selection.getChildren();
        ArrayList<V5DataItem> gpItems = new ArrayList<V5DataItem>();
        for (IXQEQueryNode di : dataItems) {
            if (!CreateV5QueryForDynamicSQS.isStaticGroupingColumn((V5DataItem)di)) continue;
            gpItems.add((V5DataItem)di);
        }
        return gpItems;
    }

    private List<V5DataItem> getSQSGroupingItems(V5Query query) {
        IXQEQueryNode[] dataItems = query.getV5Selection().getChildren();
        ArrayList<V5DataItem> gpItems = new ArrayList<V5DataItem>();
        for (IXQEQueryNode di : dataItems) {
            if (!"none".equals(((V5DataItem)di).getAggregateProperty())) continue;
            gpItems.add((V5DataItem)di);
        }
        return gpItems;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (node.getPropertyValue("potentialDuplicateColumn") == null) {
            this.traceNodeCondition(false, "This query does not have duplicate grouping columns.", xqeTrace);
            return false;
        }
        return true;
    }
}

