/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPJoinInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.unwinding.UnwindV5BoundModelId;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class UnwindDynamicSQS
extends Transformation {
    public static final String PROP_BOOLEAN_UNWOUND_SQS = "unwindForDynamicSQS";

    public UnwindDynamicSQS() {
        this.mName = "DetectDynamicSQS";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{101006};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query copiedQuery = (V5Query)environment.getNodeFactory().deepCopyNode(node);
        RQPJoinInfo joinInfo = (RQPJoinInfo)copiedQuery.getFirstChildByType(801046);
        if (joinInfo != null && !joinInfo.hasRepositoryInfo()) {
            joinInfo.createRepositoryInfo(environment.getMetadataConnection(), copiedQuery.getGovernors());
        }
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(node);
        querySet.addChild(copiedQuery);
        IXQEQueryNode[] boundIds = copiedQuery.getDescendantsOfType(201116, false);
        UnwindV5BoundModelId t = new UnwindV5BoundModelId(new int[]{1});
        for (IXQEQueryNode id : boundIds) {
            t.apply(id, environment);
        }
        if (copiedQuery.getReferencedDynamicSQS() != null) {
            copiedQuery.setPropertyValue("unwound", Boolean.TRUE);
            this.reBindReferences(querySet, (V5Query)node, copiedQuery);
            querySet.addQueryInQueryMap(((V5Query)node).getV5QueryName(), copiedQuery);
            node.detach();
            node.removeFromIndex();
        } else {
            querySet.detachChild(copiedQuery);
            copiedQuery.detach();
            copiedQuery.removeFromIndex();
            node.setPropertyValue(PROP_BOOLEAN_UNWOUND_SQS, Boolean.TRUE);
        }
    }

    protected void reBindReferences(V5QuerySet querySet, V5Query originalQuery, V5Query newQuery) {
        IXQEQueryNode[] queries;
        V5Selection originalSelection = originalQuery.getV5Selection();
        V5Selection newSelection = newQuery.getV5Selection();
        int[] types = new int[]{201060, 201097};
        for (IXQEQueryNode query : queries = querySet.getDescendantsOfType(101006, false)) {
            IXQEQueryNode[] refs;
            if (query == newQuery) continue;
            for (IXQEQueryNode ref : refs = query.getDescendantsOfTypes(types, false)) {
                String itemName;
                V5DataItem item = null;
                if (ref.getType() == 201060) {
                    V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)ref;
                    if (dataItemRef.isQueryRefItem()) {
                        item = dataItemRef.getRefDataItem();
                    }
                } else {
                    item = ((V5BoundQueryItemReference)ref).getRefDataItem();
                }
                if (item == null || item != originalSelection.getDataItemByRefName(itemName = item.getNameProperty()) || newSelection.getDataItemByRefName(itemName) == null) continue;
                if (ref.getType() == 201060) {
                    ((V5BoundDataItemReference)ref).setRefDataItem(newSelection.getDataItemByRefName(itemName));
                    continue;
                }
                ((V5BoundQueryItemReference)ref).setRefDataItem(newSelection.getDataItemByRefName(itemName));
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (node.getPropertyValue(PROP_BOOLEAN_UNWOUND_SQS) != null) {
            this.traceNodeCondition(false, "This query is already unwound to detect dynamic summary query subject.", xqeTrace);
            return false;
        }
        if (node.getPropertyValue("stitchQuery") != null) {
            this.traceNodeCondition(false, "This query is a stitch of dynamic SQS.", xqeTrace);
            return false;
        }
        if (node.getPropertyValue("referencedDynamicSQS") != null) {
            this.traceNodeCondition(false, "This query is already marked as referencing dynamic summary query subject.", xqeTrace);
            return false;
        }
        if (node.getAncestorOfType(101072) != null) {
            this.traceNodeCondition(false, "This query is pre-plan query, don't need to detect SQS.", xqeTrace);
            return false;
        }
        if (Boolean.TRUE == node.getPropertyValue("unwound")) {
            this.traceNodeCondition(false, "This query is already unwound.", xqeTrace);
            return false;
        }
        V5Query v5Query = (V5Query)node;
        if (v5Query.isDMR() || !v5Query.isTabular()) {
            this.traceNodeCondition(false, "This query is not relational.", xqeTrace);
            return false;
        }
        return true;
    }
}

