/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSortItem;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5CaseExpression;
import com.cognos.xqe.ast.v5Exp.V5CaseWhenClause;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeAggregatesInAppropriateSubQueries;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ExpressionAnalyzer {
    public static final int FOR_REPORT_SCOPE = 0;
    public static final int CURRENT_LEVEL_SCOPE = 1;
    public static final int SPECIFIC_SCOPE = 2;
    public static final String ORDER_BY_LITERAL = "100";

    public static int getHighestAggregationScope(IXQEQueryNode node) {
        IXQEQueryNode[] aggregateNodes = ExpressionAnalyzer.getAggregateNodes(node);
        for (int i = 0; i < aggregateNodes.length; ++i) {
            if (!ExpressionAnalyzer.hasForReportScope(aggregateNodes[i])) continue;
            return 0;
        }
        if (!node.hasDescendantOfType(201037, false)) {
            return 1;
        }
        return 2;
    }

    public static IXQEQueryNode[] getAggregateNodes(IXQEQueryNode node, boolean unwindRQPDataItemRef) {
        if (unwindRQPDataItemRef && node.getType() == 801009) {
            RQPDataItemRef dataItemRef = (RQPDataItemRef)node;
            return ExpressionAnalyzer.getAggregateNodes(dataItemRef.getReferencedItem(), unwindRQPDataItemRef);
        }
        return ExpressionAnalyzer.getAggregateNodes(node);
    }

    public static IXQEQueryNode[] getAggregateNodes(IXQEQueryNode node) {
        int[] descendantTypes = new int[]{201031, 201033, 201035};
        List<IXQEQueryNode> listOfAggregateNodes = node.getDescendantsOfTypesOrdered(descendantTypes, true);
        IXQEQueryNode[] nodes = new IXQEQueryNode[listOfAggregateNodes.size()];
        return listOfAggregateNodes.toArray(nodes);
    }

    public static IXQEQueryNode[] getAnalyticOrRunningMovingFunctions(IXQEQueryNode node) {
        int[] descendantTypes = new int[]{201033, 201035};
        List<IXQEQueryNode> listOfAggregateNodes = node.getDescendantsOfTypesOrdered(descendantTypes, true);
        IXQEQueryNode[] nodes = new IXQEQueryNode[listOfAggregateNodes.size()];
        return listOfAggregateNodes.toArray(nodes);
    }

    public static IXQEQueryNode[] getAnalyticFunctions(IXQEQueryNode node) {
        return node.getDescendantsOfType(201033, true);
    }

    public static IXQEQueryNode[] getSummaryFunctions(IXQEQueryNode node) {
        return node.getDescendantsOfType(201031, true);
    }

    public static boolean hasForReportScope(IXQEQueryNode aggregateNode) {
        IXQEQueryNode forClause = aggregateNode.getFirstChildByType(201037);
        if (forClause != null && forClause.getNumberChildren() == 0) {
            return true;
        }
        return forClause == null && aggregateNode.getType() == 201033;
    }

    public static boolean isStandardOrAnalyticAggregateWithAutoForClause(IXQEQueryNode aggregateNode) {
        return (aggregateNode.getType() == 201031 || aggregateNode.getType() == 201033) && aggregateNode.getFirstChildByType(201037) == null;
    }

    public static boolean isStandardAggregateWithAutoForClause(IXQEQueryNode aggregateNode) {
        return aggregateNode.getType() == 201031 && aggregateNode.getFirstChildByType(201037) == null;
    }

    public static List<IXQEQueryNode> getOutermostAggregates(IXQEQueryNode node) {
        IXQEQueryNode[] aggregates = ExpressionAnalyzer.getAggregateNodes(node);
        ArrayList<IXQEQueryNode> outermostAggregates = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode aggregate : aggregates) {
            if (ExpressionAnalyzer.hasAggregateAncestor(aggregate)) continue;
            outermostAggregates.add(aggregate);
        }
        return outermostAggregates;
    }

    public static boolean isAnalyticOrRMFunctionWithExplicitForClause(IXQEQueryNode node) {
        return ExpressionAnalyzer.isAnalyticOrRunningMovingFunction(node) && node.getFirstChildByType(201037) != null;
    }

    public static boolean isAnalyticOrRunningMovingFunction(IXQEQueryNode node) {
        return node.getType() == 201033 || node.getType() == 201035;
    }

    public static boolean isAnalyticFunction(IXQEQueryNode node) {
        return node.getType() == 201033;
    }

    public static boolean isRunningMovingFunction(IXQEQueryNode node) {
        return node.getType() == 201035;
    }

    public static boolean isAggregateFunction(IXQEQueryNode node) {
        return ExpressionAnalyzer.isStandardAggregate(node) || ExpressionAnalyzer.isAnalyticFunction(node) || ExpressionAnalyzer.isRunningMovingFunction(node);
    }

    public static V5AggregateFunction getStdAggregateOperandOfAnalyticFunction(IXQEQueryNode expression) {
        if (expression.getNumberChildren() == 0) {
            return null;
        }
        IXQEQueryNode[] operandAggs = ExpressionAnalyzer.getAggregateNodes(expression.getChild(0));
        if (operandAggs.length == 0) {
            return null;
        }
        V5AggregateFunction op = ExpressionAnalyzer.getLowestScopeStdAggregateOperandOfAnalyticFunction(expression, operandAggs);
        while (op != null && ExpressionAnalyzer.isAnalyticOrRunningMovingFunction(op)) {
            op = ExpressionAnalyzer.getStdAggregateOperandOfAnalyticFunction(op);
        }
        if (op != null) {
            return op;
        }
        return (V5AggregateFunction)operandAggs[0];
    }

    public static boolean forClauseItemsAreSubsetOf(V5AggregateBreakClause forClauseItem1, V5AggregateBreakClause forClauseItem2) {
        if (forClauseItem1 == null || forClauseItem1.getNumberChildren() == 0) {
            return true;
        }
        if (forClauseItem2 == null || forClauseItem2.getNumberChildren() == 0) {
            return false;
        }
        boolean found = false;
        for (int j = 0; j < forClauseItem1.getNumberChildren(); ++j) {
            IXQEQueryNode forClauseItem1Child = forClauseItem1.getChild(j);
            found = false;
            for (int k = 0; k < forClauseItem2.getNumberChildren(); ++k) {
                IXQEQueryNode forClauseItem2Child = forClauseItem2.getChild(k);
                if (!forClauseItem1Child.isSameExpression(forClauseItem2Child, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static V5AggregateFunction getLowestScopeStdAggregateOperandOfAnalyticFunction(IXQEQueryNode expression, IXQEQueryNode[] operandAggs) {
        if (operandAggs.length == 1) {
            return (V5AggregateFunction)operandAggs[0];
        }
        V5SummaryFilter summaryFilter = (V5SummaryFilter)expression.getAncestorOfType(101011);
        List<IXQEQueryNode> stdAggOperands = ExpressionAnalyzer.getStdAggregateOperandsOfFunction(expression, operandAggs);
        if (stdAggOperands.size() == 1) {
            return (V5AggregateFunction)stdAggOperands.get(0);
        }
        V5AggregateFunction opWithLowerScope = null;
        RQPSummaryFilterList.AggregateScope lowestScope = null;
        RQPSummaryFilterList.AggregateScope previousScope = null;
        boolean operandsHaveDiffScopes = false;
        for (IXQEQueryNode stdAgg : stdAggOperands) {
            RQPSummaryFilterList.AggregateScope currentScope = null;
            V5AggregateFunction operand = (V5AggregateFunction)stdAgg;
            V5AggregateBreakClause forClause = operand.getForClause();
            if (forClause != null) {
                if (forClause.getNumberChildren() == 0) {
                    currentScope = RQPSummaryFilterList.AggregateScope.forReportScope;
                    if (lowestScope == null) {
                        lowestScope = currentScope;
                        opWithLowerScope = operand;
                    }
                } else {
                    currentScope = RQPSummaryFilterList.AggregateScope.explicitForClause;
                    if (lowestScope == null || lowestScope == RQPSummaryFilterList.AggregateScope.forReportScope) {
                        lowestScope = currentScope;
                        opWithLowerScope = operand;
                    }
                    if (previousScope != null && previousScope == RQPSummaryFilterList.AggregateScope.explicitForClause && !ExpressionAnalyzer.forClauseItemsAreSubsetOf(forClause, opWithLowerScope.getForClause())) {
                        lowestScope = currentScope;
                        opWithLowerScope = operand;
                    }
                }
            }
            if (currentScope == null && !RQPNode.getRQPQuery(expression).getRootRQPQuery().isAutoSummaryTRUE()) {
                if (summaryFilter != null) {
                    currentScope = DistributeAggregatesInAppropriateSubQueries.getSummaryFilterScopeForAutoFALSE(summaryFilter);
                    if (lowestScope == null || lowestScope == RQPSummaryFilterList.AggregateScope.forReportScope) {
                        lowestScope = currentScope;
                        opWithLowerScope = operand;
                    }
                } else {
                    currentScope = RQPSummaryFilterList.AggregateScope.forReportScope;
                    if (lowestScope == null) {
                        lowestScope = currentScope;
                        opWithLowerScope = operand;
                    }
                }
            }
            if (currentScope == null) {
                if (summaryFilter != null) {
                    if (summaryFilter.getPropertyValue("convertedFromDetail") == Boolean.TRUE) {
                        currentScope = RQPSummaryFilterList.AggregateScope.defaultSummaryScope;
                        if (lowestScope != currentScope) {
                            lowestScope = currentScope;
                            opWithLowerScope = operand;
                        }
                    } else {
                        currentScope = RQPSummaryFilterList.AggregateScope.forReportScope;
                        if (lowestScope == null) {
                            lowestScope = currentScope;
                            opWithLowerScope = operand;
                        }
                    }
                } else {
                    lowestScope = currentScope = RQPSummaryFilterList.AggregateScope.defaultSummaryScope;
                    opWithLowerScope = operand;
                }
            }
            if (previousScope != null && previousScope != currentScope) {
                operandsHaveDiffScopes = true;
            }
            previousScope = currentScope;
        }
        if (lowestScope == RQPSummaryFilterList.AggregateScope.defaultSummaryScope && operandsHaveDiffScopes) {
            expression.setPropertyValue("containsStdAggOperandsWithDiffScope", true);
        }
        return opWithLowerScope;
    }

    public static List<IXQEQueryNode> getStdAggregateOperandsOfFunction(IXQEQueryNode functionNode, IXQEQueryNode[] descendantAggs) {
        ArrayList<IXQEQueryNode> stdAggOperands = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode agg : descendantAggs) {
            if (agg.getType() != 201031) continue;
            boolean isOperand = true;
            for (IXQEQueryNode parent = agg.getParent(); parent != functionNode; parent = parent.getParent()) {
                if (parent.getType() != 201031) continue;
                isOperand = false;
                break;
            }
            if (!isOperand) continue;
            stdAggOperands.add(agg);
        }
        return stdAggOperands;
    }

    public static boolean isAnalyticFunctionWithExplicitForClause(IXQEQueryNode node) {
        return node.getType() == 201033 && node.getFirstChildByType(201037) != null;
    }

    public static boolean isRollupAggregateNode(IXQEQueryNode node) {
        if (!ExpressionAnalyzer.isAggregateFunction(node)) {
            return false;
        }
        return ((V5AggregateFunction)node).getRollupAggregateNode();
    }

    public static boolean isStandardAggregate(IXQEQueryNode node) {
        return node.getType() == 201031;
    }

    public static List<IXQEQueryNode> getRollupAggregates(IXQEQueryNode node) {
        IXQEQueryNode[] aggregates;
        ArrayList<IXQEQueryNode> rollupAggregates = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode aggregate : aggregates = ExpressionAnalyzer.getAggregateNodes(node)) {
            if (!((V5AggregateFunction)aggregate).getRollupAggregateNode()) continue;
            rollupAggregates.add(aggregate);
        }
        return rollupAggregates;
    }

    public static boolean exprOrRefExprHasAggregate(IXQEQueryNode expr) {
        if (expr.getType() == 801009) {
            return ExpressionAnalyzer.exprOrRefExprHasAggregate(((RQPDataItemRef)expr).getReferencedItem());
        }
        if (RQPUtilities.hasAggregateInExpression(expr)) {
            return true;
        }
        for (int i = 0; i < expr.getNumberChildren(); ++i) {
            if (!ExpressionAnalyzer.exprOrRefExprHasAggregate(expr.getChild(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean exprOrRefExprHasAnalyticOrRunningMovingFunctions(IXQEQueryNode expr) {
        if (expr.getType() == 801009) {
            return ExpressionAnalyzer.exprOrRefExprHasAnalyticOrRunningMovingFunctions(((RQPDataItemRef)expr).getReferencedItem());
        }
        if (ExpressionAnalyzer.getAnalyticOrRunningMovingFunctions(expr).length > 0) {
            return true;
        }
        for (int i = 0; i < expr.getNumberChildren(); ++i) {
            if (!ExpressionAnalyzer.exprOrRefExprHasAnalyticOrRunningMovingFunctions(expr.getChild(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean refQueryIsFactQuery(IXQEQueryNode expr) {
        if (expr.getType() == 801009) {
            RQPQuery refQuery = ((RQPDataItemRef)expr).getQuery();
            if (refQuery != null && refQuery.isFactQuery()) {
                return true;
            }
            RQPDataItem rqpDataItem = ((RQPDataItemRef)expr).getReferencedItem();
            if (refQuery == null && (refQuery = rqpDataItem.getParentRQPQuery()) != null && refQuery.isFactQuery()) {
                return true;
            }
            return ExpressionAnalyzer.refQueryIsFactQuery(rqpDataItem);
        }
        for (int i = 0; i < expr.getNumberChildren(); ++i) {
            if (!ExpressionAnalyzer.refQueryIsFactQuery(expr.getChild(i))) continue;
            return true;
        }
        return false;
    }

    public static void getRefItemsReferringFactQuery(IXQEQueryNode expr, Set<String> refQueries) {
        if (expr.getType() == 801009) {
            if (expr.getAncestorOfTypes(new int[]{201037, 201036}) != null) {
                return;
            }
            RQPQuery refQuery = ((RQPDataItemRef)expr).getQuery();
            if (refQuery.isFactQuery() || refQuery.getType() == 801044) {
                refQueries.add(refQuery.getName());
            }
            return;
        }
        for (int i = 0; i < expr.getNumberChildren(); ++i) {
            ExpressionAnalyzer.getRefItemsReferringFactQuery(expr.getChild(i), refQueries);
        }
    }

    public static boolean hasAggregateAncestor(IXQEQueryNode expr) {
        int[] aggrTypes = new int[]{201031, 201033, 201035};
        return expr.getAncestorOfTypes(aggrTypes) != null;
    }

    public static boolean hasAnalyticAggregateAncestor(V5AggregateFunction expr) {
        return expr.getAncestorOfType(201033) != null;
    }

    public static boolean containsNonSQL99Function(IXQEQueryNode expression) {
        if (ExpressionAnalyzer.isNonSQL99Function(expression)) {
            return true;
        }
        for (IXQEQueryNode child : expression.getChildren()) {
            if (!ExpressionAnalyzer.containsNonSQL99Function(child)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNonSQL99Function(IXQEQueryNode expression) {
        return expression.getType() == 201042 && ((V5GenericFunction)expression).getSubType() == 0;
    }

    public static void getAllReferencedModelID(IXQEQueryNode expr, List<IXQEQueryNode> outList) {
        IXQEQueryNode[] refs;
        List<IXQEQueryNode> boundIDs = expr.getDescendantsOfTypeOrdered(201116, true);
        for (IXQEQueryNode node : boundIDs) {
            if (node.getAncestorOfType(301041) != null) continue;
            boolean duplicate = false;
            for (IXQEQueryNode element : outList) {
                if (!element.isSameExpression(node, false)) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            outList.add(node);
        }
        for (IXQEQueryNode r : refs = expr.getDescendantsOfType(801009, true)) {
            RQPDataItemRef ref = (RQPDataItemRef)r;
            ExpressionAnalyzer.getAllReferencedModelID(ref.getReferencedItem(), outList);
        }
    }

    public static List<RQPDataItemRef> getAllReferences(IXQEQueryNode node) {
        IXQEQueryNode[] dataItemRefs = node.getDescendantsOfType(801009, true);
        ArrayList<RQPDataItemRef> itemRefs = new ArrayList<RQPDataItemRef>();
        for (IXQEQueryNode ref : dataItemRefs) {
            itemRefs.add((RQPDataItemRef)ref);
        }
        return itemRefs;
    }

    public static boolean isHigherScope(List<IXQEQueryNode> forClause, List<RQPDataItem> groupingItems) {
        return ExpressionAnalyzer.isHigherScope(forClause, groupingItems, false);
    }

    public static boolean isHigherScope(List<IXQEQueryNode> forClause, List<RQPDataItem> groupingItems, boolean useOriginalNames) {
        int sizeOfForClause = forClause.size();
        int sizeOfGroupingItems = groupingItems.size();
        if (sizeOfForClause == 0 && sizeOfGroupingItems > 0) {
            return true;
        }
        if (sizeOfForClause >= sizeOfGroupingItems) {
            return false;
        }
        for (IXQEQueryNode forClauseItem : forClause) {
            if (ExpressionAnalyzer.forClauseItemIsInGroupingItemList(forClauseItem, groupingItems, useOriginalNames)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean forClauseItemIsInGroupingItemList(IXQEQueryNode forClauseItem, List<RQPDataItem> groupingItems, boolean useOriginalNames) {
        RQPDataItem di;
        boolean found = false;
        if (useOriginalNames) {
            String forClauseItemOrigName = null;
            if (forClauseItem.getType() == 801009) {
                forClauseItemOrigName = ((RQPDataItemRef)forClauseItem).getNextReferencedItem().getOriginalName();
            } else if (forClauseItem.getType() == 201055) {
                forClauseItemOrigName = (String)forClauseItem.getPropertyValue("originalV5Name");
            } else if (forClauseItem.getType() == 801010) {
                forClauseItemOrigName = ((RQPDataItemSelfRef)forClauseItem).getRefProjection().getOriginalName();
            }
            if (forClauseItemOrigName == null) return ExpressionAnalyzer.forClauseItemIsInGroupingItemList(forClauseItem, groupingItems, false);
            Iterator<RQPDataItem> iterator = groupingItems.iterator();
            while (iterator.hasNext()) {
                RQPDataItem di2 = iterator.next();
                String groupingItemOrigName = di2.getOriginalName();
                if (!forClauseItemOrigName.equals(groupingItemOrigName)) continue;
                found = true;
            }
            return found;
        }
        Iterator<RQPDataItem> iterator = groupingItems.iterator();
        do {
            if (!iterator.hasNext()) return found;
        } while (!forClauseItem.isSameExpression((di = iterator.next()).getExpression(), false));
        return true;
    }

    public static IXQEQueryNode createRowNumberExpr(IXQENodeFactory nodeFactory, List<IXQEQueryNode> partitionByClause, List<IXQEQueryNode> sortItems) {
        SQLAggregate sqlAggregate = (SQLAggregate)nodeFactory.createNode(301034);
        sqlAggregate.setSubType(SQLAggregate.SubType.ROW_NUMBER);
        SQLWindow sqlWindow = (SQLWindow)nodeFactory.createNode(301041);
        sqlAggregate.addChild(sqlWindow);
        if (partitionByClause.size() > 0) {
            SQLPartition sqlPartition = (SQLPartition)nodeFactory.createNode(301042);
            sqlWindow.addChild(sqlPartition);
            for (IXQEQueryNode partitionByItem : partitionByClause) {
                sqlPartition.addChild(nodeFactory.deepCopyNode(partitionByItem));
            }
        }
        SQLSortKeyList sqlSortKeyList = (SQLSortKeyList)nodeFactory.createNode(301021);
        sqlWindow.addChild(sqlSortKeyList);
        if (sortItems.size() > 0) {
            for (IXQEQueryNode sortItem : sortItems) {
                IXQEQueryNode sortKey = null;
                if (sortItem.getType() == 801010) {
                    IXQEQueryNode sortExpr = ((RQPDataItemSelfRef)sortItem).getExpression();
                    if (sortExpr.getType() == 801009) {
                        RQPDataItem rqpDI = ((RQPDataItemRef)sortExpr).getReferencedItem();
                        sortKey = nodeFactory.deepCopyNode(rqpDI.getExpression());
                    } else {
                        sortKey = nodeFactory.deepCopyNode(sortExpr);
                    }
                }
                if (sortKey == null) {
                    sortKey = nodeFactory.deepCopyNode(sortItem);
                }
                SQLSortKey sqlSortKey = (SQLSortKey)nodeFactory.createNode(301020);
                sqlSortKeyList.addChild(sqlSortKey);
                if (null != sortItem.getParent() && 801019 == sortItem.getParent().getType()) {
                    String sortOrder = ((RQPSortItem)sortItem.getParent()).getSortOrder();
                    sqlSortKey.setAscending("ascending".equalsIgnoreCase(sortOrder));
                }
                sqlSortKey.addChild(sortKey);
            }
        } else {
            SQLSortKey sqlSortKey = (SQLSortKey)nodeFactory.createNode(301020);
            sqlSortKeyList.addChild(sqlSortKey);
            SQLLiteral sqlLiteral = (SQLLiteral)nodeFactory.createNode(301031);
            sqlLiteral.setDataType(DataTypeFactory.getIntegerType());
            sqlLiteral.setValue(ORDER_BY_LITERAL);
            sqlSortKey.addChild(sqlLiteral);
        }
        return sqlAggregate;
    }

    public static IXQEQueryNode createCaseExpression(IXQENodeFactory nodeFactory, IXQEQueryNode conditionChild, IXQEQueryNode thenExpr) {
        V5CaseExpression caseExpr = (V5CaseExpression)nodeFactory.createNode(201018);
        caseExpr.setSubType(1);
        V5CaseWhenClause when = (V5CaseWhenClause)nodeFactory.createNode(201019);
        caseExpr.addChild(when);
        V5ComparisonExpression equal = (V5ComparisonExpression)nodeFactory.createNode(201013);
        equal.setSubType(2);
        when.addChild(equal);
        thenExpr.detach();
        when.addChild(thenExpr);
        equal.addChild(conditionChild);
        SQLLiteral sqlLiteral = (SQLLiteral)nodeFactory.createNode(301031);
        equal.addChild(sqlLiteral);
        sqlLiteral.setDataType(DataTypeFactory.getSmallintType());
        sqlLiteral.setValue("1");
        IXQEQueryNode sqlNull = nodeFactory.createNode(301050);
        caseExpr.addChild(sqlNull);
        return caseExpr;
    }

    public static V5ValueSummaryFunction createV5SummaryFunctionMin(PlanningEnvironment environment) {
        V5ValueSummaryFunction v5Function = (V5ValueSummaryFunction)environment.getNodeFactory().createNode(201031);
        v5Function.setSubType(6);
        return v5Function;
    }

    public static IXQEQueryNode[] getAggregateScope(V5AggregateFunction aggregate) {
        RQPQuery aggregateQuery = RQPNode.getRQPQuery(aggregate);
        IXQEQueryNode forClause = aggregate.getFirstChildByType(201037);
        if (forClause == null) {
            IXQEQueryNode sqlPartition;
            IXQEQueryNode sqlWindow;
            if (aggregateQuery.getType() == 801025 && (sqlWindow = aggregate.getFirstChildByType(301041)) != null && (sqlPartition = sqlWindow.getFirstChildByType(301042)) != null) {
                return sqlPartition.getChildren();
            }
            return aggregateQuery.getGroupingItems();
        }
        return forClause.getChildren();
    }

    public static boolean exprContainsCaseOrIfExpression(IXQEQueryNode expr) {
        return expr.getFirstDescendantOfTypeOrdered(201018, true) != null || expr.getFirstDescendantOfTypeOrdered(201017, true) != null;
    }

    public static boolean hasAnalyticMovingRunningFunctions(IXQEQueryNode node) {
        int[] aggregateTypes = new int[]{201033, 201035};
        return node.getDescendantsOfTypes(aggregateTypes, false).length > 0;
    }

    public static boolean exprOrRefExprHasStandardAggregate(IXQEQueryNode expr) {
        if (expr.getType() == 801010) {
            return ExpressionAnalyzer.exprOrRefExprHasStandardAggregate(((RQPDataItemSelfRef)expr).getRefProjection());
        }
        if (expr.getType() == 801009) {
            return ExpressionAnalyzer.exprOrRefExprHasStandardAggregate(((RQPDataItemRef)expr).getReferencedItem());
        }
        if (RQPUtilities.hasStandardAggregateInExpression(expr)) {
            return true;
        }
        for (int i = 0; i < expr.getNumberChildren(); ++i) {
            if (!ExpressionAnalyzer.exprOrRefExprHasStandardAggregate(expr.getChild(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean eachTermInExprIsAggregated(IXQEQueryNode expr) {
        if (expr.getType() == 801010) {
            return ExpressionAnalyzer.eachTermInExprIsAggregated(((RQPDataItemSelfRef)expr).getRefProjection());
        }
        if (expr.getType() == 801009) {
            return ExpressionAnalyzer.eachTermInExprIsAggregated(((RQPDataItemRef)expr).getReferencedItem());
        }
        if (ExpressionAnalyzer.isAggregateFunction(expr)) {
            return true;
        }
        if (expr.getType() == 201116) {
            return false;
        }
        for (int i = 0; i < expr.getNumberChildren(); ++i) {
            if (ExpressionAnalyzer.eachTermInExprIsAggregated(expr.getChild(i))) continue;
            return false;
        }
        return true;
    }
}

