/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.ast.rqp.RQPBridgeQuery;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPFactQuery;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTNode;
import com.cognos.xqe.ast.sql.SQLQuantifier;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.PrePlanV5QueryToCogSQLQueryTransformationLibrary;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.BuildJoinPlan;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.OData.ODataUtilities;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.aggregateAwareness.IAggregateAwareness;
import com.cognos.xqe.transformation.v5tocogsql.util.itemNormalization.ItemNormalization;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FFNode;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.IUndirectedGraph;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class InitializeFactManager
extends RQPTransformation {
    private static final String COMMA_SPACE = ", ";
    private static final String DELIMITER = "__";
    private static final String FSEPARATOR = ";";
    public static final String PROP_STATE = "STATE";
    public static final String PROP_TOBEPUSHED_INSUBQUERY = "pushedInSubQuery";
    public static final String PROP_FACT_NODE_FROM_FF = "factNodeFromFactFinder";
    private static boolean sgFactSensitive = false;
    private static boolean sgFactSensitiveEarlyOut = false;
    private static boolean sgFactStreamIsConnected = true;
    private static String sgFactList = null;
    private static boolean sgDisablePreferredQuerySubject = false;
    private static final String statePopulateInputNode = "populateInputNode***************";
    private static final String stateCreateFactFinder = "createFactFinder***************";
    private static final String stateComputeDimensionStreamsForRowStitching = "computeDimensionStreamsForRowStitching***************";
    private static final String stateComputeStreams = "computeStreams***************";
    private static final String statePreProcessTheBridge = "preProcessTheBridge***************";
    private static final String stateComputeInput = "computeInput***************";
    private static final String stateDetectIncompatibleBridges = "detectIncompatibleBridges***************";
    private static final String stateRemoveFactStreamsNotAccessedFromInput = "removeFactStreamsNotAccessedFromInput***************";
    private static final String stateRemoveFactStreamGeneratedForFilter = "removeFactStreamGeneratedForFilter***************";
    private static final String statePreProcessFilters = "preProcessFilters***************";
    private static final String stateCreateFactQuery = "createFactQuery***************";
    private static final String stateCreateBridgeQuery = "createBridgeQuery***************";
    protected Pair usedByJoinGraph = null;

    public InitializeFactManager() {
        this.mName = "Initialize Fact Manager.";
        this.mPassNumbers = new int[]{30};
        this.mTypes = new int[]{801042};
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        sgFactSensitive = config.getBooleanProperty("general.joinpath[@factSensitive]", false);
        sgFactSensitiveEarlyOut = config.getBooleanProperty("general.joinpath[@factSensitiveEarlyOut]", false);
        sgFactStreamIsConnected = config.getBooleanProperty("general.joinpath[@factStreamIsConnected]", true);
        sgDisablePreferredQuerySubject = config.getBooleanProperty("general.joinpath[@disablePreferredQuerySubjectInFF]", false);
        sgFactList = config.getStringProperty("general.joinpath.facts", null);
        sgFactList = sgFactList != null && sgFactList.length() == 0 ? null : sgFactList + FSEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPFactManager rqpFactManager = (RQPFactManager)node;
        RQPQuery rqpQuery = rqpFactManager.getParentRQPQuery();
        V5Query query = rqpQuery.getRefV5Query();
        try (MetadataConnectionContext mc = null;){
            int severity;
            List<IMetadata> joins;
            IAggregateAwareness aw;
            if (environment.isMultiModelForQueryEnabled()) {
                V5Query v5query = query;
                if (v5query == null) {
                    v5query = RQPNode.getV5Query(rqpQuery);
                }
                if (v5query != null) {
                    mc = environment.pushMetadataConnectionContext(v5query.getMetadataPath());
                }
            }
            if ((aw = environment.getMetadataConnection().getAggregateAwareness()) != null) {
                aw.initialize(environment);
            }
            HashMap<Integer, IXQEQueryNode> detailFiltersToBeAnalyzed = new HashMap<Integer, IXQEQueryNode>();
            HashMap<Integer, Set<Integer>> inputNodeToDetailFilters = new HashMap<Integer, Set<Integer>>();
            rqpFactManager.setPropertyValue(PROP_STATE, statePopulateInputNode);
            HashMap<IMetadata, Set<IMetadata>> inputQSToQI = new HashMap<IMetadata, Set<IMetadata>>();
            this.populateInputNode(rqpFactManager, detailFiltersToBeAnalyzed, inputNodeToDetailFilters, environment, inputQSToQI);
            boolean isUsingOData = rqpFactManager.isUsingOData();
            List<IMetadata> qsSetToJoin = this.collectQuerySubjects(node, isUsingOData);
            if (qsSetToJoin.size() <= 1) {
                rqpFactManager.setPropertyValue("hasOnlyOneQS", true);
                return;
            }
            Object relationalSubquery = null;
            boolean singleLoadingCubeFromDMR = false;
            HashMap<String, IMetadata> idToJoin = null;
            IUndirectedGraph graph = null;
            List<IMetadata> querySubjectsInQuery = null;
            boolean ignoreFiltersNotApplicable = false;
            if (query != null) {
                Governors governor = query.getGovernors();
                if (governor != null) {
                    ignoreFiltersNotApplicable = governor.getIgnoreFiltersNotApplicable();
                }
                if ((relationalSubquery = query.getPropertyValue("relationalSubquery")) != null) {
                    List<IMetadata> allJoins = query.getPropertyAllJoins(environment);
                    if (allJoins != null && !allJoins.isEmpty()) {
                        rqpQuery.setAllJoinsForOuterMostQuery(allJoins);
                        idToJoin = new HashMap();
                        graph = RQPUtilities.buildGraph(environment, allJoins, idToJoin, querySubjectsInQuery);
                    }
                    if (query.getPropertyValue("singleLoadingCubeFromDMR") != null) {
                        singleLoadingCubeFromDMR = true;
                    }
                }
            }
            if (isUsingOData) {
                HashSet<IMetadata> involvedQS = new HashSet<IMetadata>();
                HashMap<String, IMetadata> mapLookUp = new HashMap<String, IMetadata>();
                HashSet<IMetadata> involvedItemsQuery = new HashSet<IMetadata>();
                IQuerySubject qs = InitializeFactManager.getQuerySubjectAndInvolvedQueryItem(involvedItemsQuery, rqpQuery);
                idToJoin = new HashMap();
                graph = ODataUtilities.createUndirectedGraph(environment, qs, involvedItemsQuery, involvedQS, mapLookUp, idToJoin);
            }
            if (graph == null && (joins = query.getPreferredJoins()) != null && !joins.isEmpty()) {
                idToJoin = new HashMap<String, IMetadata>();
                graph = RQPUtilities.buildGraph(environment, joins, idToJoin, querySubjectsInQuery);
            }
            boolean rowStitch = node.getGovernors().getRowStitchForFactLessQuery() != false || query.getPropertyValue("rowStitch") != null;
            rqpFactManager.setPropertyValue(PROP_STATE, stateCreateFactFinder);
            if (!this.createFactFinder(rqpFactManager, environment, graph, idToJoin, qsSetToJoin, rowStitch, inputQSToQI)) {
                return;
            }
            boolean qualifyStreamName = false;
            V5QuerySet v5QuerySet = (V5QuerySet)rqpFactManager.getAncestorOfType(101002);
            List resolvedQueries = (List)v5QuerySet.getPropertyValue("resolvedQueries");
            if (resolvedQueries != null && resolvedQueries.size() > 1) {
                qualifyStreamName = true;
            }
            FactFinder factFinder = rqpFactManager.getFactFinder();
            int nbOfFactsInRequest = factFinder.getFactsInEntitiesToJoin(qsSetToJoin);
            int nbOfFactsToSupportTheRequest = factFinder.getNumberOfFacts();
            if (rowStitch && nbOfFactsInRequest == 0 && nbOfFactsToSupportTheRequest > 0 && !factFinder.containsBridge()) {
                rqpFactManager.setPropertyValue(PROP_STATE, stateComputeDimensionStreamsForRowStitching);
                this.computeDimensionStreamsForRowStitching(rqpFactManager, qualifyStreamName, rqpFactManager.getRootRQPQuery().getName(), environment);
                rqpQuery.setPropertyValue("rowStitch", true);
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(XQEMessages.getMessage(XQEMessageKeys.PLN_RowStitchJoin, XQEMessages.getCurrProductLocale()));
                ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.PLN_RowStitchJoin);
                environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
            } else {
                rqpFactManager.setPropertyValue(PROP_STATE, stateComputeStreams);
                this.computeStreams(rqpFactManager, qualifyStreamName, rqpFactManager.getRootRQPQuery().getName(), environment);
                rqpFactManager.setPropertyValue(PROP_STATE, statePreProcessTheBridge);
                this.preProcessTheBridge(rqpFactManager, environment);
            }
            rqpFactManager.setPropertyValue(PROP_STATE, stateComputeInput);
            this.computeInput(rqpFactManager, environment, false);
            rqpFactManager.setPropertyValue(PROP_STATE, stateDetectIncompatibleBridges);
            this.detectIncompatibleBridges(rqpFactManager, qsSetToJoin, environment);
            rqpFactManager.setPropertyValue(PROP_STATE, stateRemoveFactStreamsNotAccessedFromInput);
            this.removeFactStreamsNotAccessedFromInput(rqpFactManager);
            rqpFactManager.setPropertyValue(PROP_STATE, stateRemoveFactStreamGeneratedForFilter);
            this.removeFactStreamGeneratedForFilter(rqpFactManager, detailFiltersToBeAnalyzed, inputNodeToDetailFilters);
            if ((ignoreFiltersNotApplicable || relationalSubquery != null) && rqpFactManager.isMultiFact() && detailFiltersToBeAnalyzed.size() != 0 && !singleLoadingCubeFromDMR) {
                rqpFactManager.setPropertyValue(PROP_STATE, statePreProcessFilters);
                this.preProcessFilters(rqpFactManager, graph, idToJoin, detailFiltersToBeAnalyzed, inputNodeToDetailFilters, rowStitch, environment, ignoreFiltersNotApplicable);
            }
            if ((severity = environment.getResponseMessageFolder().getMaxSeverityLevel()) == 3 && rqpFactManager.getNumberOfFactStreams() > 1 && !rqpFactManager.isUsingBridge()) {
                StringBuilder nagMessage = new StringBuilder();
                String v5QueryName = query.getV5QueryName();
                IMessageKey.Param1 messageKey = XQEMessageKeys.PLN_MultifactQueryInfoTitle;
                Locale locale = XQEMessages.getCurrProductLocale();
                String title = XQEMessages.getMessage(messageKey, locale, v5QueryName);
                nagMessage.append(title);
                nagMessage.append("\n\n");
                StringBuilder multifactMsgWithoutJoins = new StringBuilder();
                factFinder.dump(multifactMsgWithoutJoins, false, false);
                nagMessage.append(multifactMsgWithoutJoins.toString());
                StringBuilder multifactMsgWithJoins = new StringBuilder();
                factFinder.dump(multifactMsgWithJoins, true, false);
                nagMessage.append(multifactMsgWithJoins.toString());
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nagMessage.toString());
            }
            if (rqpFactManager.isMultiFact()) {
                rqpQuery.setJoinSelectionIsContextSensitive(false);
            }
            rqpFactManager.setPropertyValue(PROP_STATE, stateCreateFactQuery);
            this.createFactQuery(rqpFactManager, environment);
            rqpFactManager.setPropertyValue(PROP_STATE, stateCreateBridgeQuery);
            this.createBridgeQuery(rqpFactManager, environment);
        }
    }

    public void removeFactStreamsNotAccessedFromInput(RQPFactManager factManager) {
        LinkedHashSet<String> streamsReferencedInInput = new LinkedHashSet<String>();
        RQPTNode inputNode = factManager.getInputNode();
        for (IXQEQueryNode child : inputNode.getChildren()) {
            IXQEQueryNode[] streams;
            for (IXQEQueryNode s : streams = child.getChildren()) {
                RQPTNode stream = (RQPTNode)s;
                streamsReferencedInInput.add(stream.getName());
            }
        }
        RQPTNode streamsNode = factManager.getStreamsNode();
        for (IXQEQueryNode s : streamsNode.getChildren()) {
            RQPTNode stream = (RQPTNode)s;
            if (streamsReferencedInInput.contains(stream.getName())) continue;
            stream.detach();
            factManager.removeFactFromInputSharedDimensions(stream.getName());
            factManager.computeFinalFactStreamToQS();
        }
    }

    public void removeFactStreamGeneratedForFilter(RQPFactManager factManager, Map<Integer, IXQEQueryNode> detailFiltersToBeAnalyzed, Map<Integer, Set<Integer>> inputNodeToDetailFilters) {
        RQPTNode streamsNode = factManager.getStreamsNode();
        for (IXQEQueryNode factStream : streamsNode.getChildren()) {
            RQPTNode factStreamTNode = (RQPTNode)factStream;
            if (!this.factStreamCanBeRemoved(factManager, factStreamTNode)) continue;
            IXQEQueryNode fact = factStreamTNode.getChild(0);
            RQPTNode qsNode = (RQPTNode)fact.getChild(0);
            RQPTNode qsInputNode = factManager.getDimensionFromInputNode(qsNode.getName());
            String[] qsNames = new String[]{qsNode.getName(), qsInputNode.getTarget()};
            Set<Integer> mappedFilters = inputNodeToDetailFilters.get(qsInputNode.getId());
            for (Integer filterId : mappedFilters) {
                IXQEQueryNode filterNode = detailFiltersToBeAnalyzed.get(filterId);
                filterNode.setPropertyValue(PROP_TOBEPUSHED_INSUBQUERY, qsNames);
            }
            factStream.detach();
            factManager.removeFactFromInputSharedDimensions(factStreamTNode.getName());
            factManager.computeFinalFactStreamToQS();
        }
    }

    private boolean factStreamCanBeRemoved(RQPFactManager factManager, RQPTNode factStream) {
        if (factStream.getPropertyValue("ISFORDETQS") == null) {
            return false;
        }
        RQPTNode detFact = (RQPTNode)factStream.getChild(0);
        RQPTNode detQS = (RQPTNode)detFact.getChild(0);
        if (!factManager.isQuerySubjectASharedDimension(detQS.getName())) {
            return false;
        }
        RQPTNode detQSInputNode = factManager.getDimensionFromInputNode(detQS.getName());
        return detQSInputNode.getReferredFromFilterOnly();
    }

    public List<IMetadata> collectQuerySubjects(IXQEQueryNode node, boolean isUsingOData) {
        IXQEQueryNode[] children;
        RQPFactManager rqpFactManager = (RQPFactManager)node;
        LinkedList<IMetadata> qsSetToJoin = new LinkedList<IMetadata>();
        RQPTNode inputNode = (RQPTNode)rqpFactManager.getChild(0);
        for (IXQEQueryNode child : children = inputNode.getChildren()) {
            RQPTNode tNode = (RQPTNode)child;
            V5BoundModelIdentifier identifier = tNode.getV5BoundModelIdentifier();
            IMetadata qs = null;
            qs = !isUsingOData ? identifier.getQuerySubject() : ODataUtilities.getOwnerQuerySubjectOrMultiSetFolder(identifier.getMetadata());
            if (qs == null) continue;
            qsSetToJoin.add(qs);
        }
        return qsSetToJoin;
    }

    public boolean createFactFinder(RQPFactManager factManager, PlanningEnvironment environment, IUndirectedGraph graph, HashMap<String, IMetadata> idToJoin, List<IMetadata> qsListToJoin, boolean rowStitch, HashMap<IMetadata, Set<IMetadata>> inputQSToQI) {
        int nbOfFactsInRequest;
        RQPJoinPathFinder pathFinder = null;
        if (this.usedByJoinGraph != null) {
            pathFinder = new RQPJoinPathFinder(qsListToJoin, environment, factManager.getGovernors());
            this.usedByJoinGraph.setFirst(pathFinder.getAllJoinPaths());
            return true;
        }
        RQPQuery rqpQuery = factManager.getParentRQPQuery();
        Set<IMetadata> preferredQuerySubjects = null;
        if (!sgDisablePreferredQuerySubject) {
            preferredQuerySubjects = BuildJoinPlan.getPreferredQuerySubjects(rqpQuery, environment);
        }
        boolean joinPlanAgainstTheWholeModel = true;
        if (graph != null) {
            joinPlanAgainstTheWholeModel = false;
        }
        List<List<IMetadata>> allJoinPaths = null;
        boolean factAware = sgFactSensitive;
        if (factAware) {
            TreeSet<IMetadata> qsFact = new TreeSet<IMetadata>();
            ArrayList<IMetadata> qsNonFacts = new ArrayList<IMetadata>();
            for (IMetadata m : qsListToJoin) {
                boolean isFact = false;
                String mNamePlusSep = m.getName() + FSEPARATOR;
                if (sgFactList != null) {
                    isFact = sgFactList.contains(mNamePlusSep);
                } else if (m.getName().contains("FACT") && !m.getName().contains("CURRENCY")) {
                    isFact = true;
                }
                if (isFact) {
                    qsFact.add(m);
                    continue;
                }
                qsNonFacts.add(m);
            }
            for (IMetadata f : qsFact) {
                ArrayList<IMetadata> qsToJoin = new ArrayList<IMetadata>();
                qsToJoin.addAll(qsNonFacts);
                qsToJoin.add(f);
                TreeSet<IMetadata> preferredQS = null;
                if (preferredQuerySubjects != null) {
                    preferredQS = new TreeSet<IMetadata>();
                    preferredQS.addAll(preferredQuerySubjects);
                }
                try {
                    if (preferredQS != null && BuildJoinPlan.isPreferredModelIdHintPassed(rqpQuery)) {
                        preferredQS.addAll(qsToJoin);
                    }
                    RQPJoinPathFinder tPathFinder = new RQPJoinPathFinder(graph, idToJoin, qsToJoin, preferredQS, factManager.getGovernors(), environment);
                    if (allJoinPaths == null) {
                        allJoinPaths = tPathFinder.getAllJoinPaths();
                        continue;
                    }
                    allJoinPaths.addAll(tPathFinder.getAllJoinPaths());
                }
                catch (XQERuntimeException e) {
                    XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "JoinPath", LogLevel.INFO);
                    logger.log(LogLevel.WARN, "Failed finding a path based on specified fact: " + f.getName());
                    if (!sgFactSensitiveEarlyOut) continue;
                    int step = 0;
                    for (IMetadata fs : qsFact) {
                        ++step;
                        if (fs != f) continue;
                        break;
                    }
                    logger.log(LogLevel.WARN, "Finding based on specified facts - terminated at step: " + step + " of: " + qsFact.size());
                    allJoinPaths = null;
                    break;
                }
            }
        }
        if (allJoinPaths == null || factAware && allJoinPaths.size() == 0) {
            try {
                if (preferredQuerySubjects != null && BuildJoinPlan.isPreferredModelIdHintPassed(rqpQuery)) {
                    preferredQuerySubjects.addAll(qsListToJoin);
                }
                pathFinder = new RQPJoinPathFinder(graph, idToJoin, qsListToJoin, preferredQuerySubjects, factManager.getGovernors(), environment);
                if (factAware && sgFactStreamIsConnected && pathFinder != null && !pathFinder.isConnected()) {
                    pathFinder = null;
                    rqpQuery.setAllJoinsForOuterMostQuery(null);
                    joinPlanAgainstTheWholeModel = true;
                }
            }
            catch (XQERuntimeException e) {
                pathFinder = null;
                rqpQuery.setAllJoinsForOuterMostQuery(null);
                joinPlanAgainstTheWholeModel = true;
            }
            if (pathFinder != null && !joinPlanAgainstTheWholeModel && (allJoinPaths = pathFinder.getAllJoinPaths()).isEmpty()) {
                pathFinder = null;
                rqpQuery.setAllJoinsForOuterMostQuery(null);
                joinPlanAgainstTheWholeModel = true;
            }
            if (pathFinder == null) {
                pathFinder = new RQPJoinPathFinder(qsListToJoin, factManager.getGovernors(), environment);
            }
            allJoinPaths = pathFinder.getAllJoinPaths();
            if (!pathFinder.isConnected()) {
                return false;
            }
        }
        FactFinder factFinder = new FactFinder(environment);
        factManager.setFactFinder(factFinder);
        allJoinPaths = joinPlanAgainstTheWholeModel ? this.updateAllJoinPaths(factManager, allJoinPaths, null, null, qsListToJoin, environment) : this.updateAllJoinPaths(factManager, allJoinPaths, graph, idToJoin, qsListToJoin, environment);
        if (inputQSToQI != null && ItemNormalization.addDummyJoinsForItemNormalization(environment, allJoinPaths, inputQSToQI)) {
            factManager.setItemNormalization(true);
        }
        factFinder.addJoinPaths(allJoinPaths);
        if (!factFinder.isValid()) {
            return false;
        }
        TreeMap<IMetadata, List<IMetadata>> qsToQSItems = this.getUsedQSItems(factManager);
        if (!factManager.isUsingOData()) {
            factFinder.addFactsToAvoidDoubleCounting(environment, qsToQSItems);
        }
        if ((nbOfFactsInRequest = factFinder.getFactsInEntitiesToJoin(qsListToJoin)) == 0 && factFinder.getNumberOfFacts() > 1 && !factFinder.containsBridge()) {
            boolean isPrePlan = this.getTransformationLibrary() instanceof PrePlanV5QueryToCogSQLQueryTransformationLibrary;
            factFinder.filterOutNonOptimalFactStreams(qsToQSItems, environment, isPrePlan);
            if (!rowStitch) {
                factFinder.retainOnlyAlphabeticalFirstFact(environment);
            }
        }
        return true;
    }

    TreeMap<IMetadata, List<IMetadata>> getUsedQSItems(RQPFactManager factManager) {
        IXQEQueryNode[] children;
        TreeMap<IMetadata, List<IMetadata>> qsToUsedItems = new TreeMap<IMetadata, List<IMetadata>>();
        RQPTNode inputNode = (RQPTNode)factManager.getChild(0);
        for (IXQEQueryNode child : children = inputNode.getChildren()) {
            RQPTNode tNode = (RQPTNode)child;
            List<IMetadata> queryItems = tNode.getQueryItems();
            if (queryItems == null) continue;
            IQuerySubject qs = null;
            IMetadata metadata = queryItems.get(0);
            qs = metadata instanceof IQueryItem ? ((IQueryItem)metadata).getQuerySubject() : ((IMeasure)metadata).getQuerySubject();
            if (qs instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)((Object)qs)).isAccessedViaShortcut()) {
                IAccessedViaShortcut asc = (IAccessedViaShortcut)((Object)qs);
                IShortcut sc = asc.getShortcut();
                qsToUsedItems.put(sc, queryItems);
                tNode.setTarget(qs.getV5UniqueName());
                continue;
            }
            qsToUsedItems.put(qs, queryItems);
        }
        return qsToUsedItems;
    }

    public void computeStreams(RQPFactManager factManager, boolean qualifyStreamName, String queryName, PlanningEnvironment environment) {
        RQPTNode streamsNode = factManager.getStreamsNode();
        RQPTNode inputNode = factManager.getInputNode();
        RQPTNode bridgesNode = factManager.getBridgesNode();
        FactFinder factFinder = factManager.getFactFinder();
        TreeSet<FFNode> factNodes = new TreeSet<FFNode>();
        factFinder.getFactNodes(factNodes);
        int index = 1;
        int indexForBridge = 1;
        TreeMap<String, List<IMetadata>> factStreamToQSItems = new TreeMap<String, List<IMetadata>>();
        for (FFNode factNode : factNodes) {
            String name;
            RQPTNode fsNode = null;
            boolean processingBridgeNode = false;
            if (this.isBridgeTable(factNode)) {
                fsNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                name = "BRIDGE" + indexForBridge;
                fsNode.setName(name);
                fsNode.setPropertyValue(PROP_FACT_NODE_FROM_FF, factNode);
                bridgesNode.addChild(fsNode);
                ++indexForBridge;
                processingBridgeNode = true;
            } else {
                fsNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                name = qualifyStreamName ? queryName + "_" + "FS" + index : "FS" + index;
                fsNode.setName(name);
                fsNode.setPropertyValue(PROP_FACT_NODE_FROM_FF, factNode);
                streamsNode.addChild(fsNode);
                if (this.factlessTable(factNode)) {
                    fsNode.setFactlessFact(true);
                }
                ++index;
            }
            if (factNode.getIsForDetQS()) {
                fsNode.setPropertyValue("ISFORDETQS", "True");
            }
            TreeSet<IMetadata> factAliases = new TreeSet<IMetadata>();
            factNode.getAliasIds(factAliases);
            Iterator<IMetadata> iterator = factAliases.iterator();
            while (iterator.hasNext()) {
                IMetadata factEntity;
                IMetadata target = factEntity = iterator.next();
                RQPTNode chainNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                chainNode.setName(target);
                fsNode.addChild(chainNode);
                this.copyPropertiesFromInputNodes(chainNode, inputNode);
            }
            RQPTNode parentNode = (RQPTNode)fsNode.getChild(0);
            TreeSet<IMetadata> branchAliases = new TreeSet<IMetadata>();
            if (processingBridgeNode) {
                factNode.getBranchesInfoForTheBridge(branchAliases);
            } else {
                factNode.getBranchesInfo(branchAliases);
            }
            for (IMetadata entity : branchAliases) {
                RQPTNode chainNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                chainNode.setName(entity);
                parentNode.addChild(chainNode);
                this.copyPropertiesFromInputNodes(chainNode, inputNode);
            }
            if (!factFinder.hasFactWithDetQS()) continue;
            factStreamToQSItems.put(name, factFinder.getSupportedQueryItems(factNode));
        }
        factManager.setPropertyValue("FactStreamsToQSITEMS", factStreamToQSItems);
    }

    public void computeDimensionStreamsForRowStitching(RQPFactManager factManager, boolean qualifyStreamName, String queryName, PlanningEnvironment environment) {
        RQPTNode streamsNode = factManager.getStreamsNode();
        FactFinder factFinder = factManager.getFactFinder();
        TreeSet<FFNode> factNodes = new TreeSet<FFNode>();
        factFinder.getFactNodes(factNodes);
        int index = 1;
        for (FFNode factNode : factNodes) {
            Set<FFNode> branches = factFinder.getBranches(factNode);
            for (FFNode branch : branches) {
                TreeSet<IMetadata> dimEntities = new TreeSet<IMetadata>();
                branch.getAliasIds(dimEntities);
                branch.getBranchesInfo(dimEntities);
                RQPTNode fsNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                String name = qualifyStreamName ? queryName + DELIMITER + "DS" + index : "DS" + index;
                fsNode.setName(name);
                fsNode.setPropertyValue(PROP_FACT_NODE_FROM_FF, factNode);
                streamsNode.addChild(fsNode);
                RQPTNode chainNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                chainNode.setName(name);
                fsNode.addChild(chainNode);
                for (IMetadata entity : dimEntities) {
                    RQPTNode childNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                    childNode.setName(entity);
                    chainNode.addChild(childNode);
                }
                ++index;
            }
        }
        TreeMap factStreamToQSItems = new TreeMap();
        factManager.setPropertyValue("FactStreamsToQSITEMS", factStreamToQSItems);
    }

    private void copyPropertiesFromInputNodes(RQPTNode streamsNode, RQPTNode inputNode) {
        RQPTNode node = inputNode.getInputChildOfName(streamsNode.getName());
        if (node == null) {
            return;
        }
        streamsNode.setPropertyFilterNotProjectedAggNone(node.getPropertyFilterNotProjectedAggNone());
        streamsNode.setReferredFromFilterOnly(node.getReferredFromFilterOnly());
    }

    public void computeInput(RQPFactManager factManager, PlanningEnvironment environment, boolean skipRemoveFactFromInputSharedDimensions) {
        IXQEQueryNode[] bridges;
        RQPTNode newTNode;
        RQPTNode inputChild;
        String factName;
        IXQEQueryNode[] factNodeAliases;
        IXQEQueryNode[] factStreams;
        RQPTNode inputNode = factManager.getInputNode();
        RQPTNode streamsNode = factManager.getStreamsNode();
        RQPTNode bridgesNode = factManager.getBridgesNode();
        for (IXQEQueryNode factStream : factStreams = streamsNode.getChildren()) {
            RQPTNode factStreamTNode = (RQPTNode)factStream;
            String factStreamName = factStreamTNode.getName();
            boolean factStreamCoveredWrapper = false;
            for (IXQEQueryNode factNodeAlias : factNodeAliases = factStreamTNode.getChildren()) {
                IXQEQueryNode[] dimNodes;
                String wrappedQSName;
                factName = ((RQPTNode)factNodeAlias).getName();
                inputChild = inputNode.getInputChildOfName(factName);
                if (inputChild == null && (wrappedQSName = ((RQPTNode)factNodeAlias).getWrappedQSName()) != null) {
                    inputChild = inputNode.getInputChildOfName(wrappedQSName);
                }
                if (inputChild != null) {
                    newTNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                    newTNode.setName(factStreamName);
                    inputChild.addChild(newTNode);
                    factStreamCoveredWrapper = true;
                }
                for (IXQEQueryNode dimNode : dimNodes = factNodeAlias.getChildren()) {
                    String wrappedQSName2;
                    String dimName = ((RQPTNode)dimNode).getName();
                    inputChild = inputNode.getInputChildOfName(dimName);
                    if (inputChild == null && !factStreamCoveredWrapper && (wrappedQSName2 = ((RQPTNode)dimNode).getWrappedQSName()) != null) {
                        inputChild = inputNode.getInputChildOfName(wrappedQSName2);
                    }
                    if (inputChild == null) continue;
                    RQPTNode newTNode2 = (RQPTNode)environment.getNodeFactory().createNode(801043);
                    newTNode2.setName(factStreamName);
                    inputChild.addChild(newTNode2);
                }
            }
        }
        for (IXQEQueryNode bridge : bridges = bridgesNode.getChildren()) {
            IXQEQueryNode[] bridgeAliases;
            RQPTNode bridgeTNode = (RQPTNode)bridge;
            String bridgeName = bridgeTNode.getName();
            for (IXQEQueryNode bridgeAlias : bridgeAliases = bridgeTNode.getChildren()) {
                String name = ((RQPTNode)bridgeAlias).getName();
                inputChild = inputNode.getInputChildOfName(name);
                if (inputChild == null) continue;
                newTNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                newTNode.setName(bridgeName);
                inputChild.addChild(newTNode);
            }
        }
        for (int i = factStreams.length - 1; i >= 0; --i) {
            IXQEQueryNode factStream = factStreams[i];
            RQPTNode factStreamTNode = (RQPTNode)factStream;
            String factStreamName = factStreamTNode.getName();
            if (factStreamTNode.getPropertyValue("ISFORDETQS") != null) continue;
            boolean factLess = false;
            if (factStreamTNode.getFactlessFact()) {
                factLess = true;
            }
            boolean measureIsInInput = false;
            for (IXQEQueryNode factNodeAlias : factNodeAliases = factStreamTNode.getChildren()) {
                factName = ((RQPTNode)factNodeAlias).getName();
                inputChild = inputNode.getInputChildOfName(factName);
                if (inputChild != null) {
                    if (!inputChild.getPropertyFilterNotProjectedAggNone()) {
                        measureIsInInput = true;
                        continue;
                    }
                    if (!((RQPTNode)factNodeAlias).hasProjectedOutrigger(factManager, factStreamName)) continue;
                    measureIsInInput = true;
                    continue;
                }
                if (!factLess || !((RQPTNode)factNodeAlias).hasProjectedOutrigger(factManager, factStreamName)) continue;
                measureIsInInput = true;
            }
            if (measureIsInInput || skipRemoveFactFromInputSharedDimensions) continue;
            factManager.removeFactFromInputSharedDimensions(factStreamName);
        }
        factManager.computeFinalFactStreamToQS();
    }

    public void populateInputNode(RQPFactManager factManager, IXQEQueryNode startingNode, Map<Integer, IXQEQueryNode> detailFiltersToBeAnalyzed, Map<Integer, Set<Integer>> inputNodeToDetailFilters, PlanningEnvironment environment, HashMap<IMetadata, Set<IMetadata>> inputQSToQI) {
        List<IXQEQueryNode> v5Identifiers = startingNode.getDescendantsOfTypeOrdered(201116, true);
        boolean isUsingOData = factManager.isUsingOData();
        for (IXQEQueryNode v5Identifier : v5Identifiers) {
            IXQEQueryNode filterNode;
            RQPTNode iNode;
            if (this.identifierIsDescendantOfInEqualANYEqualALL(v5Identifier)) continue;
            if (inputQSToQI != null) {
                IMetadata qi = ((V5BoundModelIdentifier)v5Identifier).getMetadata();
                IMetadata qs = null;
                qs = !isUsingOData ? ((V5BoundModelIdentifier)v5Identifier).getQuerySubject() : ODataUtilities.getOwnerQuerySubjectOrMultiSetFolder(qi);
                Set<IMetadata> queryItems = inputQSToQI.get(qs);
                if (queryItems == null) {
                    queryItems = new HashSet<IMetadata>();
                    inputQSToQI.put(qs, queryItems);
                }
                queryItems.add(qi);
            }
            if (!(iNode = factManager.addInputChild((V5BoundModelIdentifier)v5Identifier, environment)).getReferredFromFilterOnly() || (filterNode = v5Identifier.getAncestorOfTypes(new int[]{101008, 801035})) == null) continue;
            if (!detailFiltersToBeAnalyzed.containsKey(filterNode.getId())) {
                detailFiltersToBeAnalyzed.put(filterNode.getId(), filterNode);
            }
            if (!inputNodeToDetailFilters.containsKey(iNode.getId())) {
                LinkedHashSet<Integer> mappedFilters = new LinkedHashSet<Integer>();
                mappedFilters.add(filterNode.getId());
                inputNodeToDetailFilters.put(iNode.getId(), mappedFilters);
                continue;
            }
            inputNodeToDetailFilters.get(iNode.getId()).add(filterNode.getId());
        }
    }

    private boolean identifierIsDescendantOfInEqualANYEqualALL(IXQEQueryNode v5Identifier) {
        int[] inTypes = new int[]{201011, 301076};
        IXQEQueryNode inExp = v5Identifier.getAncestorOfTypes(inTypes);
        if (inExp != null) {
            return inExp.getChild(1) == v5Identifier || v5Identifier.isAncestor(inExp.getChild(1));
        }
        V5ComparisonExpression v5InOrAllExp = (V5ComparisonExpression)v5Identifier.getAncestorOfType(201013);
        if (v5InOrAllExp != null) {
            return !(v5InOrAllExp.getOption() != 2 && v5InOrAllExp.getOption() != 1 || v5InOrAllExp.getChild(1) != v5Identifier && !v5Identifier.isAncestor(v5InOrAllExp.getChild(1)));
        }
        SQLQuantifier sqlInOrAllExp = (SQLQuantifier)v5Identifier.getAncestorOfType(301055);
        if (sqlInOrAllExp != null) {
            return !(!SQLQuantifier.SubType.ANY.equals((Object)sqlInOrAllExp.getSubType()) && !SQLQuantifier.SubType.ALL.equals((Object)sqlInOrAllExp.getSubType()) || sqlInOrAllExp.getChild(1) != v5Identifier && !v5Identifier.isAncestor(sqlInOrAllExp.getChild(1)));
        }
        return false;
    }

    public void populateInputNode(RQPFactManager factManager, Map<Integer, IXQEQueryNode> detailFiltersToBeAnalyzed, Map<Integer, Set<Integer>> inputNodeToDetailFilters, PlanningEnvironment environment, HashMap<IMetadata, Set<IMetadata>> inputQSToQI) {
        IXQEQueryNode[] children;
        RQPQuery rqpQuery = factManager.getParentRQPQuery();
        for (IXQEQueryNode child : children = rqpQuery.getChildren()) {
            if (child.getType() != 801016) continue;
            this.populateInputNode(factManager, child, detailFiltersToBeAnalyzed, inputNodeToDetailFilters, environment, inputQSToQI);
        }
        for (IXQEQueryNode child : children) {
            if (child.getType() == 801016) continue;
            this.populateInputNode(factManager, child, detailFiltersToBeAnalyzed, inputNodeToDetailFilters, environment, inputQSToQI);
        }
    }

    public void createFactQuery(RQPFactManager factManager, PlanningEnvironment environment) {
        IXQEQueryNode[] streams;
        if (!factManager.isUsingBridge() && !factManager.isMultiFact()) {
            if (factManager.getItemNormalization()) {
                RQPQuery rqpQuery = factManager.getParentRQPQuery();
                IXQEQueryNode[] streams2 = factManager.getStreamsNode().getChildren();
                if (streams2.length == 1) {
                    FFNode factNode = (FFNode)streams2[0].getPropertyValue(PROP_FACT_NODE_FROM_FF);
                    ArrayList<IMetadata> joinsForFactStream = new ArrayList<IMetadata>();
                    factNode.getAllJoins(joinsForFactStream);
                    rqpQuery.setJoinsForFactStream(joinsForFactStream);
                }
            }
            return;
        }
        RQPQuery rqpQuery = factManager.getParentRQPQuery();
        IXQEQueryNode subqueryList = rqpQuery.getSubqueryList();
        for (IXQEQueryNode stream : streams = factManager.getStreamsNode().getChildren()) {
            RQPTNode streamTNode = (RQPTNode)stream;
            RQPFactQuery factQuery = (RQPFactQuery)environment.getNodeFactory().createNode(801044);
            if (null != stream.getPropertyValue("ISFORDETQS")) {
                factQuery.setPropertyValue("ISFORDETQS", "true");
            }
            if (null != stream.getPropertyValue("IS_BRIDGE_DATA_STREAM")) {
                factQuery.setIsBridgeDataStream();
            }
            subqueryList.addChild(factQuery);
            factQuery.setName(streamTNode.getName());
            FFNode factNode = (FFNode)stream.getPropertyValue(PROP_FACT_NODE_FROM_FF);
            ArrayList<IMetadata> joinsForFactStream = new ArrayList<IMetadata>();
            factNode.getAllJoins(joinsForFactStream);
            factQuery.setJoinsForFactStream(joinsForFactStream);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        this.traceNodeCondition(true, "This query is running against the MFW4J", trace);
        return true;
    }

    private List<List<IMetadata>> updateAllJoinPaths(RQPFactManager factManager, List<List<IMetadata>> allJoinPaths, IUndirectedGraph graph, HashMap<String, IMetadata> idToJoin, List<IMetadata> qsList, PlanningEnvironment environment) {
        List<List<IMetadata>> singleFactJoinPaths;
        FactFinder factFinder = new FactFinder(null);
        factFinder.addJoinPaths(allJoinPaths);
        if (!factFinder.isValid()) {
            return allJoinPaths;
        }
        TreeSet<IMetadata> factEntities = new TreeSet<IMetadata>();
        factFinder.getFactQuerySubjects(factEntities);
        if (factEntities.size() < 2) {
            return allJoinPaths;
        }
        int nbOfFactsInRequest = factFinder.getFactsInEntitiesToJoin(qsList);
        if (nbOfFactsInRequest == 1 && (singleFactJoinPaths = this.getSingleFactStreamJoinPaths(allJoinPaths)).size() > 0) {
            factManager.setPropertyValue("computedSingleFactJoinPaths", singleFactJoinPaths);
            return singleFactJoinPaths;
        }
        return this.addMissingPathsForFacts(factManager, allJoinPaths, graph, idToJoin, qsList, environment);
    }

    private List<List<IMetadata>> getSingleFactStreamJoinPaths(List<List<IMetadata>> allJoinPaths) {
        ArrayList<List<IMetadata>> updatedJoinPaths = new ArrayList<List<IMetadata>>();
        for (int i = 0; i < allJoinPaths.size(); ++i) {
            List<IMetadata> path = allJoinPaths.get(i);
            FactFinder factFinder = new FactFinder(null);
            factFinder.addJoinPath(path);
            if (!factFinder.isValid()) continue;
            TreeSet<IMetadata> factEntities = new TreeSet<IMetadata>();
            factFinder.getFactQuerySubjects(factEntities);
            if (factEntities.size() != 1) continue;
            updatedJoinPaths.add(path);
        }
        return updatedJoinPaths;
    }

    private List<List<IMetadata>> addMissingPathsForFacts(RQPFactManager factManager, List<List<IMetadata>> allJoinPaths, IUndirectedGraph graph, HashMap<String, IMetadata> idToJoin, List<IMetadata> qsList, PlanningEnvironment environment) {
        FactFinder factFinder = new FactFinder(null);
        factFinder.addJoinPaths(allJoinPaths);
        TreeSet<IMetadata> factEntities = new TreeSet<IMetadata>();
        factFinder.getFactQuerySubjects(factEntities);
        TreeSet<IMetadata> dimEntities = new TreeSet<IMetadata>();
        factFinder.getDimensionQuerySubjects(dimEntities);
        TreeSet<IMetadata> entitiesToJoin = factFinder.getPhysicalEntities(qsList);
        factEntities.retainAll(entitiesToJoin);
        dimEntities.retainAll(entitiesToJoin);
        for (IMetadata fqs : factEntities) {
            for (IMetadata dqs : dimEntities) {
                if (this.directJoinBetweenFactAndDimension(allJoinPaths, fqs, dqs)) continue;
                ArrayList<IMetadata> qsListToJoin = new ArrayList<IMetadata>();
                qsListToJoin.add(fqs);
                qsListToJoin.add(dqs);
                RQPJoinPathFinder pathFinder = new RQPJoinPathFinder(graph, idToJoin, qsListToJoin, factManager.getGovernors(), environment);
                List<List<IMetadata>> moreJoinPaths = pathFinder.getAllJoinPaths();
                for (List<IMetadata> onePath : moreJoinPaths) {
                    if (this.pathGoesThroughOtherFacts(fqs, onePath, environment) || this.pathIsSegmentOfExistingJoinPath(allJoinPaths, onePath)) continue;
                    allJoinPaths.add(onePath);
                }
            }
        }
        return allJoinPaths;
    }

    private boolean pathGoesThroughOtherFacts(IMetadata fqs, List<IMetadata> joinPath, PlanningEnvironment environment) {
        FactFinder factFinder = new FactFinder(null);
        factFinder.addJoinPath(joinPath);
        TreeSet<IMetadata> factEntities = new TreeSet<IMetadata>();
        factFinder.getFactQuerySubjects(factEntities);
        return factEntities.size() > 1 || !factEntities.contains(fqs);
    }

    private boolean directJoinBetweenFactAndDimension(List<List<IMetadata>> allJoinPaths, IMetadata fqs, IMetadata dqs) {
        for (List<IMetadata> onePath : allJoinPaths) {
            for (IMetadata oneJoin : onePath) {
                IRelationship join = (IRelationship)oneJoin;
                IMetadata left = join.getLeftRefObject();
                IMetadata right = join.getRightRefObject();
                if ((left != fqs || right != dqs) && (left != dqs || right != fqs)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean pathIsSegmentOfExistingJoinPath(List<List<IMetadata>> allJoinPaths, List<IMetadata> segment) {
        for (List<IMetadata> onePath : allJoinPaths) {
            if (!onePath.containsAll(segment)) continue;
            return true;
        }
        return false;
    }

    public void preProcessFilters(RQPFactManager rqpFactManager, IUndirectedGraph graph, HashMap<String, IMetadata> idToJoin, Map<Integer, IXQEQueryNode> detailFiltersToBeAnalyzed, Map<Integer, Set<Integer>> inputNodeToDetailFilters, boolean rowStitch, PlanningEnvironment environment, boolean ignoreFiltersNotApplicable) {
        IXQEQueryNode[] children;
        boolean redoTheProcess = false;
        this.analyzeInputNodesRelatedWithFilters(rqpFactManager);
        RQPTNode inputNode = rqpFactManager.getInputNode();
        for (IXQEQueryNode child : children = inputNode.getChildren()) {
            RQPTNode childTNode = (RQPTNode)child;
            if (!childTNode.getReferredFromFilterOnly()) continue;
            Set<Integer> mappedFilters = inputNodeToDetailFilters.get(childTNode.getId());
            for (Integer filterId : mappedFilters) {
                IXQEQueryNode filterNode = detailFiltersToBeAnalyzed.get(filterId);
                if (filterNode == null) continue;
                redoTheProcess = true;
                if (ignoreFiltersNotApplicable) {
                    this.logWarningForDroppingFilter(environment, rqpFactManager, filterNode);
                }
                filterNode.detach();
                filterNode.removeFromIndex();
                detailFiltersToBeAnalyzed.remove(filterId);
            }
        }
        if (redoTheProcess) {
            inputNode.detachChildren();
            rqpFactManager.getStreamsNode().detachChildren();
            this.populateInputNode(rqpFactManager, detailFiltersToBeAnalyzed, inputNodeToDetailFilters, environment, null);
            List<IMetadata> qsSetToJoin = this.collectQuerySubjects(rqpFactManager, ODataUtilities.isUsingOData(environment));
            this.createFactFinder(rqpFactManager, environment, graph, idToJoin, qsSetToJoin, rowStitch, null);
            boolean qualifyStreamName = false;
            V5QuerySet v5QuerySet = (V5QuerySet)rqpFactManager.getAncestorOfType(101002);
            List resolvedQueries = (List)v5QuerySet.getPropertyValue("resolvedQueries");
            if (resolvedQueries != null && resolvedQueries.size() > 1) {
                qualifyStreamName = true;
            }
            this.computeStreams(rqpFactManager, qualifyStreamName, rqpFactManager.getRootRQPQuery().getName(), environment);
            this.computeInput(rqpFactManager, environment, false);
        }
    }

    private void logWarningForDroppingFilter(PlanningEnvironment environment, RQPFactManager rqpFactManager, IXQEQueryNode filterNode) {
        RQPTNode inputNode = rqpFactManager.getInputNode();
        IXQEQueryNode[] inputQSs = inputNode.getChildren();
        String streamName = null;
        String factStreamPrettyPrint = "";
        for (IXQEQueryNode inputQS : inputQSs) {
            RQPTNode rqpTNode = (RQPTNode)inputQS;
            if (rqpTNode.getPropertyValue("filterCanBeDropped") != filterNode || rqpTNode.getNumberChildren() <= 0) continue;
            IXQEQueryNode factStream = rqpTNode.getChild(0);
            if (factStream == null || factStream.getNodeType() != 801043) break;
            streamName = ((RQPTNode)factStream).getV5Name();
            break;
        }
        if (streamName != null) {
            factStreamPrettyPrint = rqpFactManager.getFactStreamToQSPrettyPrint(streamName);
        }
        ResponseMessage respMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_FilterCannotBeAppliedOnEmptyFact, this.getFilterExpression(filterNode), factStreamPrettyPrint);
        ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(respMsg, null, environment.getRoot());
    }

    private void analyzeInputNodesRelatedWithFilters(RQPFactManager factManager) {
        IXQEQueryNode[] children;
        RQPTNode inputNode = factManager.getInputNode();
        for (IXQEQueryNode child : children = inputNode.getChildren()) {
            IXQEQueryNode[] streams;
            RQPTNode childTNode = (RQPTNode)child;
            if (!childTNode.getReferredFromFilterOnly()) continue;
            for (IXQEQueryNode streamNode : streams = childTNode.getChildren()) {
                RQPTNode stream = (RQPTNode)streamNode;
                if (!this.hasProjectedFact(factManager, stream.getName())) continue;
                childTNode.setReferredFromFilterOnly(false);
            }
        }
    }

    public boolean hasProjectedFact(RQPFactManager factManager, String factStreamName) {
        IXQEQueryNode[] children;
        RQPTNode inputNode = factManager.getInputNode();
        for (IXQEQueryNode child : children = inputNode.getChildren()) {
            RQPTNode stream;
            IXQEQueryNode[] streams;
            RQPTNode childTNode = (RQPTNode)child;
            if (childTNode.getReferredFromFilterOnly() || (streams = childTNode.getChildren()).length != 1 || !factStreamName.equals((stream = (RQPTNode)streams[0]).getName()) || !factManager.isQuerySubjectAFact(childTNode.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isBridgeTable(FFNode factNode) {
        TreeSet<IMetadata> factAliases = new TreeSet<IMetadata>();
        factNode.getAliasIds(factAliases);
        for (IMetadata factEntity : factAliases) {
            IQuerySubject qs = null;
            if (factEntity instanceof IShortcut) {
                IShortcut sc = (IShortcut)factEntity;
                if (sc.getTargetWithShortcut() instanceof IQuerySubject) {
                    qs = (IQuerySubject)sc.getTargetWithShortcut();
                }
            } else if (factEntity instanceof IQuerySubject) {
                qs = (IQuerySubject)factEntity;
            }
            if (qs == null || !qs.getQuerySubjectUsage().equals((Object)IQuerySubject.QuerySubjectUsageEnum.BRIDGE)) continue;
            return true;
        }
        return false;
    }

    private boolean factlessTable(FFNode factNode) {
        TreeSet<IMetadata> factAliases = new TreeSet<IMetadata>();
        factNode.getAliasIds(factAliases);
        for (IMetadata factEntity : factAliases) {
            IQuerySubject qs;
            if (!(factEntity instanceof IQuerySubject) || (qs = (IQuerySubject)factEntity).getQueryItemsAndMeasures() == null) continue;
            for (IMetadata qi : qs.getQueryItemsAndMeasures()) {
                IQueryItem queryItem;
                if (!(qi instanceof IQueryItem) || !(queryItem = (IQueryItem)qi).getUsage().equals("fact")) continue;
                return false;
            }
        }
        return true;
    }

    private void createBridgeQuery(RQPFactManager factManager, PlanningEnvironment environment) {
        IXQEQueryNode[] bridges;
        if (!factManager.isUsingBridge()) {
            return;
        }
        RQPQuery rqpQuery = factManager.getParentRQPQuery();
        IXQEQueryNode subqueryList = rqpQuery.getSubqueryList();
        for (IXQEQueryNode bridge : bridges = factManager.getBridgesNode().getChildren()) {
            RQPTNode bridgeTNode = (RQPTNode)bridge;
            RQPBridgeQuery bridgeQuery = (RQPBridgeQuery)environment.getNodeFactory().createNode(801050);
            subqueryList.addChild(bridgeQuery);
            bridgeQuery.setName(bridgeTNode.getName());
            FFNode factNode = (FFNode)bridge.getPropertyValue(PROP_FACT_NODE_FROM_FF);
            ArrayList<IMetadata> joinsForBridge = new ArrayList<IMetadata>();
            factNode.getAllJoinsForTheBridge(joinsForBridge);
            bridgeQuery.setJoinsForBridge(joinsForBridge);
        }
    }

    private void preProcessTheBridge(RQPFactManager factManager, PlanningEnvironment environment) {
        IXQEQueryNode[] bridges;
        if (!factManager.isUsingBridge()) {
            return;
        }
        RQPTNode streamsNode = factManager.getStreamsNode();
        FactFinder factFinder = factManager.getFactFinder();
        int index = 1;
        for (IXQEQueryNode bridge : bridges = factManager.getBridgesNode().getChildren()) {
            FFNode factNode = (FFNode)bridge.getPropertyValue(PROP_FACT_NODE_FROM_FF);
            ArrayList<IMetadata> joinsForFactStream = new ArrayList<IMetadata>();
            factNode.getAllJoins(joinsForFactStream);
            for (IMetadata q : joinsForFactStream) {
                IRelationship relationship = (IRelationship)q;
                IXQEQueryNode[] v5Identifiers = RQPUtilities.getV5BoundIdentifiersFromRelationshipExpression(relationship, environment);
                if (v5Identifiers == null) continue;
                for (IXQEQueryNode v5Identifier : v5Identifiers) {
                    factManager.addInputChild((V5BoundModelIdentifier)v5Identifier, environment);
                }
            }
            Set<FFNode> branches = factFinder.getBranches(factNode);
            for (FFNode branch : branches) {
                TreeSet<IMetadata> dimEntities = new TreeSet<IMetadata>();
                branch.getAliasIds(dimEntities);
                branch.getBranchesInfo(dimEntities);
                for (IMetadata dimEntity : dimEntities) {
                    RQPTNode stream = this.getStreamNodeFromFactManager(factManager, dimEntity);
                    if (stream == null) {
                        RQPTNode fsNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                        String name = "DS" + index;
                        fsNode.setName(name);
                        fsNode.setPropertyValue(PROP_FACT_NODE_FROM_FF, factNode);
                        fsNode.setPropertyValue("IS_BRIDGE_DATA_STREAM", true);
                        streamsNode.addChild(fsNode);
                        RQPTNode chainNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                        chainNode.setName(name);
                        fsNode.addChild(chainNode);
                        for (IMetadata entity : dimEntities) {
                            RQPTNode childNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                            childNode.setName(entity);
                            chainNode.addChild(childNode);
                        }
                        ++index;
                        continue;
                    }
                    stream.setPropertyValue("IS_BRIDGE_DATA_STREAM", true);
                }
            }
        }
    }

    private void detectIncompatibleBridges(RQPFactManager factManager, List<IMetadata> qsUsedInQuery, PlanningEnvironment environment) {
        IXQEQueryNode[] bridges;
        if (!factManager.isUsingBridge()) {
            return;
        }
        RQPTNode bridgesNode = factManager.getBridgesNode();
        if (bridgesNode.getNumberChildren() == 1) {
            return;
        }
        TreeMap bridgeToStreamsMap = new TreeMap();
        for (IXQEQueryNode bridge : bridges = bridgesNode.getChildren()) {
            IXQEQueryNode[] inputNodes;
            RQPTNode bridgeNode = (RQPTNode)bridge.getChild(0);
            String bridgeName = bridgeNode.getName();
            if (bridgeToStreamsMap.get(bridgeName) != null) {
                throw new XQERuntimeException();
            }
            ArrayList<String> listStreams = new ArrayList<String>();
            for (IXQEQueryNode inputNode : inputNodes = bridgeNode.getChildren()) {
                RQPTNode dimension = factManager.getDimensionFromInputNode(((RQPTNode)inputNode).getName());
                String streamName = ((RQPTNode)dimension.getChild(0)).getName();
                if (listStreams.contains(streamName)) continue;
                listStreams.add(streamName);
            }
            bridgeToStreamsMap.put(bridgeName, listStreams);
        }
        ArrayList<String> parallelBridges = new ArrayList<String>();
        ArrayList<String> processedBridges = new ArrayList<String>();
        for (Map.Entry entry1 : bridgeToStreamsMap.entrySet()) {
            String bridge1 = (String)entry1.getKey();
            processedBridges.add(bridge1);
            List streams1 = (List)entry1.getValue();
            block3: for (Map.Entry entry2 : bridgeToStreamsMap.entrySet()) {
                String bridge2;
                if (entry1.equals(entry2) || processedBridges.contains(bridge2 = (String)entry2.getKey())) continue;
                List streams2 = (List)entry2.getValue();
                boolean match = false;
                boolean oneMatch = false;
                for (String stream1 : streams1) {
                    for (String stream2 : streams2) {
                        if (!stream1.equals(stream2)) continue;
                        if (oneMatch) {
                            if (!parallelBridges.contains(bridge1)) {
                                parallelBridges.add(bridge1);
                            }
                            if (!parallelBridges.contains(bridge2)) {
                                parallelBridges.add(bridge2);
                            }
                            match = true;
                            break;
                        }
                        oneMatch = true;
                        break;
                    }
                    if (!match) continue;
                    continue block3;
                }
            }
        }
        if (parallelBridges.size() > 0) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedParallelBridgeQuery, RQPNode.getRQPQuery(factManager).getName(), this.formatBridgeNames(parallelBridges));
        }
    }

    private String formatBridgeNames(List<String> bridgeNames) {
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < bridgeNames.size(); ++i) {
            if (i != 0) {
                names.append(COMMA_SPACE);
            }
            names.append(bridgeNames.get(i));
        }
        return names.toString();
    }

    private RQPTNode getStreamNodeFromFactManager(RQPFactManager factManager, IMetadata metadata) {
        IXQEQueryNode[] allBridges;
        IXQEQueryNode[] allStreams;
        if (!factManager.isUsingBridge()) {
            return null;
        }
        String v5Name = metadata.getV5UniqueName();
        for (IXQEQueryNode s : allStreams = factManager.getStreamsNode().getChildren()) {
            IXQEQueryNode[] allDimensions;
            RQPTNode streamNode = (RQPTNode)s;
            RQPTNode factQS = (RQPTNode)streamNode.getChild(0);
            if (factQS.getName().equals(v5Name)) {
                return streamNode;
            }
            for (IXQEQueryNode d : allDimensions = factQS.getChildren()) {
                RQPTNode dimNode = (RQPTNode)d;
                if (!dimNode.getName().equals(v5Name)) continue;
                return streamNode;
            }
        }
        for (IXQEQueryNode b : allBridges = factManager.getBridgesNode().getChildren()) {
            RQPTNode bridgeNode = (RQPTNode)b;
            RQPTNode bridgeQS = (RQPTNode)bridgeNode.getChild(0);
            if (!bridgeQS.getName().equals(v5Name)) continue;
            return bridgeNode;
        }
        return null;
    }

    private static IQuerySubject getQuerySubjectAndInvolvedQueryItem(Set<IMetadata> involvedItems, RQPQuery thisQuery) {
        IXQEQueryNode[] objs;
        IQuerySubject qs = null;
        for (IXQEQueryNode obj : objs = thisQuery.getDescendantsOfType(201116, false)) {
            V5BoundModelIdentifier modelObj = (V5BoundModelIdentifier)obj;
            if (!modelObj.isQueryItem()) continue;
            IQuerySubject theParentQS = modelObj.getQuerySubject();
            if (qs == null) {
                qs = theParentQS;
            } else if (qs != theParentQS) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_CrossJoinsNotPermitted, qs.getV5UniqueName() + COMMA_SPACE + theParentQS.getV5UniqueName());
            }
            involvedItems.add(modelObj.getMetadata());
        }
        return qs;
    }

    private String getFilterExpression(IXQEQueryNode filterNode) {
        IEmbeddedFilter embeddedFilter;
        String filterExpr = "";
        if (101008 == filterNode.getType()) {
            filterExpr = ((V5DetailFilter)filterNode).getOriginalExpression();
        } else if (801035 == filterNode.getType() && null != (embeddedFilter = ((RMEmbeddedFilter)filterNode).getFilter())) {
            filterExpr = embeddedFilter.getExpression();
        }
        return filterExpr;
    }

    public void setUsedByJoinGraph(Pair p) {
        this.usedByJoinGraph = p;
    }
}

