/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FFNode;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class InitializeRelationalDataItemDependency
extends RQPTransformation {
    public InitializeRelationalDataItemDependency() {
        this.mName = "Initialize relational data item dependency";
        this.mPassNumbers = new int[]{31};
        this.mTypes = new int[]{801017};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery query = (RQPQuery)node;
        RQPFactManager factManager = query.getFactManager();
        Map<IMetadata, Set<IMetadata>> qsDependencies = this.getQSDependencies(factManager);
        LinkedHashSet<IMetadata> dataItems = new LinkedHashSet<IMetadata>();
        HashMap<IMetadata, List<IMetadata>> qsToDataItems = new HashMap<IMetadata, List<IMetadata>>();
        this.getQSToDataItems(factManager, dataItems, qsToDataItems);
        Map<IMetadata, Set<IMetadata>> dataItemDependencies = this.getDataItemDependencies(qsDependencies, dataItems, qsToDataItems);
        factManager.setDataItemDependency(dataItemDependencies);
    }

    private Map<IMetadata, Set<IMetadata>> getQSDependencies(RQPFactManager factManager) {
        HashMap<IMetadata, Set<IMetadata>> qsDependencies = new HashMap<IMetadata, Set<IMetadata>>();
        TreeSet<FFNode> facts = new TreeSet<FFNode>();
        factManager.getFactFinder().getFactNodes(facts);
        for (FFNode fact : facts) {
            this.getQSDependenciesFromFactStream(qsDependencies, fact);
        }
        return qsDependencies;
    }

    private Set<IMetadata> getQSDependenciesFromFactStream(Map<IMetadata, Set<IMetadata>> qsToQSDependencies, FFNode currentNode) {
        LinkedHashSet<IMetadata> dependencies = new LinkedHashSet<IMetadata>();
        Set<FFNode> branches = currentNode.getDirectBranches().keySet();
        for (FFNode branch : branches) {
            Set<IMetadata> branchDependencies = this.getQSDependenciesFromFactStream(qsToQSDependencies, branch);
            dependencies.addAll(branchDependencies);
        }
        TreeSet<IMetadata> aliases = new TreeSet<IMetadata>();
        currentNode.getAliasIds(aliases);
        if (!dependencies.isEmpty()) {
            for (IMetadata alias : aliases) {
                Set<IMetadata> aliasDependencies = qsToQSDependencies.get(alias);
                if (aliasDependencies == null) {
                    aliasDependencies = new LinkedHashSet<IMetadata>();
                    qsToQSDependencies.put(alias, aliasDependencies);
                }
                aliasDependencies.addAll(dependencies);
            }
        }
        dependencies.addAll(aliases);
        return dependencies;
    }

    private void getQSToDataItems(RQPFactManager factManager, Set<IMetadata> dataItems, Map<IMetadata, List<IMetadata>> qsToDataItems) {
        RQPTNode inputNode = factManager.getInputNode();
        for (IXQEQueryNode inputNodeChild : inputNode.getChildren()) {
            RQPTNode inputQS = (RQPTNode)inputNodeChild;
            V5BoundModelIdentifier id = inputQS.getV5BoundModelIdentifier();
            IMetadata qs = id.getMetadata().getParentObject();
            List<IMetadata> queryItems = inputQS.getQueryItems();
            if (queryItems == null) continue;
            dataItems.addAll(queryItems);
            qsToDataItems.put(qs, queryItems);
        }
    }

    private Map<IMetadata, Set<IMetadata>> getDataItemDependencies(Map<IMetadata, Set<IMetadata>> qsDependencies, Set<IMetadata> dataItems, Map<IMetadata, List<IMetadata>> qsToDataItems) {
        HashMap<IMetadata, Set<IMetadata>> dataItemDependencies = new HashMap<IMetadata, Set<IMetadata>>();
        for (IMetadata dataItem : dataItems) {
            LinkedHashSet<IMetadata> dependencies = new LinkedHashSet<IMetadata>();
            dataItemDependencies.put(dataItem, dependencies);
            IMetadata qs = dataItem.getParentObject();
            Set<IMetadata> dependentQSs = qsDependencies.get(qs);
            if (dependentQSs == null) continue;
            for (IMetadata dependentQS : dependentQSs) {
                List<IMetadata> dependentDataItems = qsToDataItems.get(dependentQS);
                if (dependentDataItems == null) continue;
                dependencies.addAll(dependentDataItems);
            }
        }
        return dataItemDependencies;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        String msg = InitializeRelationalDataItemDependency.columnDependencyCondition(node);
        if (msg != null) {
            this.traceNodeCondition(false, msg, trace);
            return false;
        }
        this.traceNodeCondition(true, "Initialize data item dependency", trace);
        return true;
    }

    public static final String columnDependencyCondition(IXQEQueryNode node) {
        RQPQuery query = (RQPQuery)node;
        if (query.getRootRQPQuery() != query) {
            return "This is not the root RQPQuery";
        }
        V5Query v5Query = query.getRefV5Query();
        if (v5Query.isDMR()) {
            return "This is a DMR Query";
        }
        if (v5Query.isRelationalSubquery()) {
            return "This is a DMR Relational sub-query";
        }
        if (v5Query.isROLAP()) {
            return "This is a ROLAP Query";
        }
        if (!v5Query.isTabular()) {
            return "This is not a tabular query";
        }
        RQPFactManager factManager = query.getFactManager();
        if (factManager.isUsingBridge()) {
            return "This query uses a bridge";
        }
        if (query.isAutoSummaryFALSE()) {
            return "Autosummary is false";
        }
        FactFinder factFinder = factManager.getFactFinder();
        if (factFinder == null) {
            return "Fact finder is null";
        }
        if (!factFinder.isValid()) {
            return "Fact finder is not valid";
        }
        RQPProjectionList projection = query.getProjectionList();
        for (IXQEQueryNode proj : projection.getChildren()) {
            if (proj.getPropertyValue("RSAPIRefDataItem") == null) continue;
            return null;
        }
        return "No data items are projected in dataset";
    }
}

