/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SplitSummaryQueryToAvoidCircularReference;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MoveAnalyticFromLLSQ
extends RQPTransformation {
    private static final String PROP_NEW_QUERY_FOR_ANALYTIC_FUNCTION = "newQueryForAnaylyticFunction";

    public MoveAnalyticFromLLSQ() {
        this.mName = "MoveAnalyticFunctionFromLowestLevelSummaryQuery.";
        this.mPassNumbers = new int[]{74};
        this.mTypes = new int[]{201033};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        RQPQuery rootQuery = (RQPQuery)node.getAncestorOfType(801017);
        RQPSummaryQuery newSumQuery = null;
        IXQEQueryNode subqueryList = rootQuery.getSubqueryList();
        for (IXQEQueryNode subquery : subqueryList.getChildren()) {
            if (subquery.getType() == 801025 || subquery.getPropertyValue(PROP_NEW_QUERY_FOR_ANALYTIC_FUNCTION) == null) continue;
            newSumQuery = (RQPSummaryQuery)subquery;
        }
        if (newSumQuery == null) {
            newSumQuery = RQPQuery.createSummaryQueryWithSameScope(environment, rqpQuery);
            newSumQuery.setPropertyValue(PROP_NEW_QUERY_FOR_ANALYTIC_FUNCTION, Boolean.TRUE);
        }
        RQPDataItem dataItem = (RQPDataItem)node.getAncestorOfType(801008);
        List<RQPDataItemRef> diRefs = rootQuery.getReferencesMatchingName(rqpQuery.getName(), dataItem.getName());
        HashMap itemNameToReferenceObject = new HashMap();
        List references = null;
        for (RQPDataItemRef diRef : diRefs) {
            String itemName = diRef.getName();
            if (!itemNameToReferenceObject.containsKey(itemName)) {
                itemNameToReferenceObject.put(itemName, new ArrayList());
            }
            references = (List)itemNameToReferenceObject.get(itemName);
            references.add(diRef);
        }
        for (String itemName : itemNameToReferenceObject.keySet()) {
            SplitSummaryQueryToAvoidCircularReference.updateReferences(environment, (List)itemNameToReferenceObject.get(itemName), rqpQuery, newSumQuery, rqpQuery.getName());
        }
        dataItem.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The analytic function node is not under a RQP query", xqeTrace);
            return false;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        RQPQuery rootQuery = (RQPQuery)node.getAncestorOfType(801017);
        RQPSummaryQuery summaryQuery = (RQPSummaryQuery)rootQuery.getLowestLevelSummaryQuery();
        if (summaryQuery != rqpQuery) {
            this.traceNodeCondition(true, "Analytic is not in lowest level summary query", xqeTrace);
            return false;
        }
        V5AggregateBreakClause forClause = ((V5AggregateFunction)node).getForClause();
        if (forClause != null && !ExpressionAnalyzer.exprOrRefExprHasAggregate(forClause)) {
            this.traceNodeCondition(false, "The FOR clause of analytic function does not contain aggregate", xqeTrace);
            return false;
        }
        IXQEQueryNode subqueryList = rootQuery.getSubqueryList();
        boolean result = false;
        block0: for (IXQEQueryNode diRef : node.getDescendantsOfType(801009, false)) {
            RQPDataItemRef rqpDataItemRef = (RQPDataItemRef)diRef;
            String refQuery = rqpDataItemRef.getQueryName();
            for (IXQEQueryNode subquery : subqueryList.getChildren()) {
                RQPSummaryQuery sumQuery;
                if (subquery.getType() == 801025 || !(sumQuery = (RQPSummaryQuery)subquery).getName().equals(refQuery)) continue;
                result = true;
                continue block0;
            }
        }
        if (!result) {
            this.traceNodeCondition(false, "No need to move analytic function from lowest level summary query", xqeTrace);
        } else {
            this.traceNodeCondition(true, "Analytic function will be moved from lowest level summary query", xqeTrace);
        }
        return result;
    }
}

