/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.List;

public class MoveGroupingItemsToSubQuery
extends RQPTransformation {
    public MoveGroupingItemsToSubQuery() {
        this.mName = "Move grouping items to sub-query.";
        this.mPassNumbers = new int[]{43};
        this.mTypes = new int[]{801016};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] children;
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        for (IXQEQueryNode child : children = node.getChildren()) {
            IXQEQueryNode[] exps;
            RQPDataItem item = (RQPDataItem)child;
            if (!item.isGroupingItem()) continue;
            if (MoveGroupingItemsToSubQuery.hasRunningMovingAggrSortByStdAggr(item)) {
                item.removeProperty("groupingItem");
                continue;
            }
            IXQEQueryNode projExp = item.getExpression();
            this.createRQPDataItemForGroupingItem(environment, rqpQuery, item);
            List<IXQEQueryNode> calcs = projExp.getDescendantsOfCategory(201125, true);
            if (calcs.size() <= 0) continue;
            ArrayList<IXQEQueryNode> sameExps = new ArrayList<IXQEQueryNode>();
            for (IXQEQueryNode exp : exps = rqpQuery.getDescendantsOfType(projExp.getType(), false)) {
                if (projExp == exp || !projExp.isSameExpression(exp, false)) continue;
                sameExps.add(exp);
            }
            if (sameExps.isEmpty()) continue;
            item.setPropertyValue("sameExps", sameExps);
        }
    }

    private void createRQPDataItemForGroupingItem(PlanningEnvironment environment, RQPQuery rqpQuery, RQPDataItem groupingItemInRQ) {
        String groupingItemName = groupingItemInRQ.getName();
        RQPSummaryQuery summaryQuery = rqpQuery.getOrCreateDefaultSummaryQuery(environment);
        RQPTabularQuery tabularQuery = rqpQuery.getDefaultTabularQuery();
        IXQEQueryNode groupingItemExpr = groupingItemInRQ.getChild(0);
        RQPDataItem rqpDataItemInSQ = summaryQuery.createRQPDataItem(environment, groupingItemName);
        rqpDataItemInSQ.setGroupingItem(true);
        rqpDataItemInSQ.copyPropertiesFrom(groupingItemInRQ);
        RQPDataItem rqpDataItemInTQ = null;
        boolean hasAggregateInExpr = false;
        if (RQPUtilities.hasAggregateInExpression(groupingItemInRQ) && !RQPUtilities.hasOnlyAnalyticInExpression(groupingItemInRQ)) {
            groupingItemExpr.move(rqpDataItemInSQ);
            hasAggregateInExpr = true;
        } else {
            rqpDataItemInTQ = tabularQuery.createRQPDataItem(environment, groupingItemName);
            if (rqpQuery.getRefV5Query() != null && rqpQuery.v5ProjectionHasMovingOrRunning() && groupingItemExpr.getType() != 201026) {
                rqpDataItemInTQ.setGroupingItem(true);
            }
            groupingItemExpr.move(rqpDataItemInTQ);
            RQPDataItemRef rqpDataItemRefToTQ = RQPDataItemRef.create(environment, tabularQuery.getName(), rqpDataItemInTQ.getName());
            rqpDataItemInSQ.addChild(rqpDataItemRefToTQ);
        }
        RQPDataItemSelfRef rqpDataItemSelfRef = RQPDataItemSelfRef.create(environment, rqpDataItemInSQ.getName());
        if (groupingItemInRQ.isValueSetRefDataItem()) {
            rqpDataItemSelfRef.setColumnIsForGroupedReport();
        }
        summaryQuery.addToGroupByList(environment, rqpDataItemSelfRef);
        if (rqpQuery.getRootRQPQuery().isAutoSummaryTRUE() || hasAggregateInExpr || this.allProjectionsAreValueSetRefDataItems(rqpQuery.getRootRQPQuery())) {
            RQPDataItemRef rqpDataItemRefToSQ = RQPDataItemRef.create(environment, summaryQuery.getName(), rqpDataItemInSQ.getName());
            groupingItemInRQ.addChild(rqpDataItemRefToSQ);
        } else {
            RQPDataItemRef rqpDataItemRefToTQ = RQPDataItemRef.create(environment, tabularQuery.getName(), rqpDataItemInTQ.getName());
            groupingItemInRQ.addChild(rqpDataItemRefToTQ);
        }
    }

    private boolean allProjectionsAreValueSetRefDataItems(RQPQuery rqpQuery) {
        RQPProjectionList projList = rqpQuery.getProjectionList();
        for (int i = 0; i < projList.getNumberChildren(); ++i) {
            RQPDataItem projection = (RQPDataItem)projList.getChild(i);
            V5ValueSet vs = projection.getValueSet();
            if (vs == null || !vs.hasDescendantOfType(101015, false)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasRunningMovingAggrSortByStdAggr(IXQEQueryNode expr) {
        IXQEQueryNode[] sorts;
        if (!RQPUtilities.hasMovingRunningInExpression(expr)) {
            return false;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(expr);
        IXQEQueryNode sortList = rqpQuery.getFirstChildByType(801020);
        if (sortList == null) {
            return false;
        }
        for (IXQEQueryNode sort : sorts = sortList.getChildren()) {
            IXQEQueryNode[] rqpDataItemRefs;
            IXQEQueryNode[] aggrs;
            if (sort.getChild(0).getType() != 801010) continue;
            IXQEQueryNode projExpr = ((RQPDataItemSelfRef)sort.getChild(0)).getExpression();
            for (IXQEQueryNode aggr : aggrs = projExpr.getDescendantsOfType(201031, true)) {
                if (aggr.getFirstChildByType(201037) != null) continue;
                return true;
            }
            for (IXQEQueryNode rqpDataItemRef : rqpDataItemRefs = projExpr.getDescendantsOfType(801009, true)) {
                for (IXQEQueryNode aggr : aggrs = ((RQPDataItemRef)rqpDataItemRef).getReferencedItem().getDescendantsOfType(201031, false)) {
                    if (aggr.getFirstChildByType(201037) != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static RQPDataItem createRQPDataItemInSubQueryAndRefInParentQuery(PlanningEnvironment environment, RQPQuery subQuery, IXQEQueryNode expressionToMove, String preferredName, boolean avoidDuplicate, V5ValueSet valueSet) {
        IXQEQueryNode parentNode = expressionToMove.getParent();
        if (parentNode == null) {
            return null;
        }
        int exprPosition = parentNode.getPositionOfChild(expressionToMove);
        RQPDataItem rqpDataItemInSubQuery = null;
        if (avoidDuplicate) {
            rqpDataItemInSubQuery = subQuery.getRQPDataItemWithSameExpression(expressionToMove, valueSet);
        }
        if (rqpDataItemInSubQuery == null) {
            rqpDataItemInSubQuery = subQuery.createRQPDataItem(environment, preferredName);
            if (valueSet != null) {
                rqpDataItemInSubQuery.setValueSet(valueSet);
            }
            rqpDataItemInSubQuery.copyPropertiesFrom(expressionToMove);
            if (MoveGroupingItemsToSubQuery.isInLogicalExpression(expressionToMove)) {
                rqpDataItemInSubQuery.setGroupingItem(false);
            }
            expressionToMove.move(rqpDataItemInSubQuery);
        } else {
            expressionToMove.detach();
        }
        RQPDataItemRef rqpDataItemRef = RQPDataItemRef.create(environment, subQuery.getName(), rqpDataItemInSubQuery.getName());
        parentNode.addChild(rqpDataItemRef, exprPosition);
        return rqpDataItemInSubQuery;
    }

    public static RQPDataItem createRQPDataItemInSubQueryAndRefInParentQuery(PlanningEnvironment environment, RQPQuery subQuery, IXQEQueryNode expressionToMove, String preferredName, boolean avoidDuplicate) {
        return MoveGroupingItemsToSubQuery.createRQPDataItemInSubQueryAndRefInParentQuery(environment, subQuery, expressionToMove, preferredName, avoidDuplicate, null);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPDataItem item;
        IXQEQueryNode source;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parentQuery = node.getParent();
        if (parentQuery.getType() != 801017) {
            this.traceNodeCondition(false, "The projection list is not under a RQPQuery", trace);
            return false;
        }
        if (((RQPQuery)parentQuery).isMultiFactQuery()) {
            this.traceNodeCondition(false, "The projection list is under a multi-fact RQP query", trace);
            return false;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        if (rqpQuery.isBridgeWrapperQuery()) {
            this.traceNodeCondition(false, "Skip this transformation in the context of a bridge query.", trace);
            return false;
        }
        if (rqpQuery.isRelalionalSubqueryForFirstAndLast()) {
            this.traceNodeCondition(false, "Skip this transformation in the context of a DMR relationalSubquery for first and last.", trace);
            return false;
        }
        boolean isQueryOperation = false;
        IXQEQueryNode querySet = node.getAncestorOfType(101002);
        IXQEQueryNode query = querySet.getFirstChildByType(101006);
        if (query != null && (source = query.getFirstChildByType(101007)) != null && null != source.getFirstChildByType(101018)) {
            isQueryOperation = true;
        }
        boolean propertyHasAggregate = false;
        boolean hasProperty = false;
        boolean hasUnProjectedItem = false;
        IXQEQueryNode[] children = node.getChildren();
        if (!isQueryOperation) {
            for (IXQEQueryNode child : children) {
                item = (RQPDataItem)child;
                if (null == item.getPropertyValue("RSAPIRefDataItem")) {
                    hasUnProjectedItem = true;
                    break;
                }
                if (item.isGroupingItem()) continue;
                hasProperty = true;
                if (!RQPUtilities.hasAggregateInExpression(item)) continue;
                propertyHasAggregate = true;
                break;
            }
        }
        if (!hasUnProjectedItem && hasProperty && !propertyHasAggregate) {
            return false;
        }
        for (IXQEQueryNode child : children) {
            item = (RQPDataItem)child;
            if (!item.isGroupingItem() || item.hasDescendantOfType(801009, false) || MoveGroupingItemsToSubQuery.hasRunningMovingAggrSortByStdAggr(item)) continue;
            this.traceNodeCondition(true, "The grouping items of this projection list should be moved to tabular/summary query", trace);
            return true;
        }
        this.traceNodeCondition(false, "The grouping items of this projection list have been moved to tabular/summary query", trace);
        return false;
    }

    static boolean isInLogicalExpression(IXQEQueryNode item) {
        IXQEQueryNode logicalAncestor = item.getAncestorOfType(201003);
        return null != logicalAncestor;
    }
}

