/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSortList;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.List;

public class NagSortWarning
extends RQPTransformation {
    String sortVerifiedProperty = "sortVerified";

    public NagSortWarning() {
        this.mName = "Nag message about sort being missing or incomplete";
        this.mPassNumbers = new int[]{43};
        this.mTypes = new int[]{801041};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = (RQPQuery)node.getChild(0);
        RQPSortList sortList = this.getSortList(rqpQuery);
        if (sortList == null) {
            this.nagSortMessage(environment, rqpQuery, XQEMessageKeys.PLN_RelMissingSort);
        } else if (rqpQuery.isAutoSummaryTRUE()) {
            this.verifySortForAutoSummaryTrue(environment, rqpQuery, sortList);
        } else {
            this.verifySortForAutoSummaryFalse(environment, rqpQuery, sortList);
        }
        node.setPropertyValue(this.sortVerifiedProperty, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((RequestEnvironment)environment.getRequestEnvironment()).getMaxSeverityLevel() < 3) {
            this.traceQueryCondition(false, "Query Feedback severity level less than informational.", trace);
            return false;
        }
        Boolean alreadyVerified = (Boolean)node.getPropertyValue(this.sortVerifiedProperty);
        if (alreadyVerified != null && alreadyVerified.booleanValue()) {
            this.traceQueryCondition(false, "Sort already verified.", trace);
            return false;
        }
        return true;
    }

    private void verifySortForAutoSummaryTrue(PlanningEnvironment environment, RQPQuery rqpQuery, RQPSortList sortList) {
        List<RQPDataItem> groupingColumns = rqpQuery.getProjectionsMarkedAsGroupingColumns();
        if (!this.verifyProjectionsInSortList(groupingColumns, sortList)) {
            this.nagSortMessage(environment, rqpQuery, XQEMessageKeys.PLN_RelIncompleteSort);
        }
    }

    private void verifySortForAutoSummaryFalse(PlanningEnvironment environment, RQPQuery rqpQuery, RQPSortList sortList) {
        ArrayList<RQPDataItem> projectionItems = new ArrayList<RQPDataItem>();
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        for (IXQEQueryNode projection : projectionList.getChildren()) {
            RQPDataItem rqpDataItem = (RQPDataItem)projection;
            projectionItems.add(rqpDataItem);
        }
        if (!this.verifyProjectionsInSortList(projectionItems, sortList)) {
            this.nagSortMessage(environment, rqpQuery, XQEMessageKeys.PLN_RelIncompleteSortAutoSummaryFalse);
        }
    }

    private RQPSortList getSortList(RQPQuery rqpQuery) {
        RQPSortList sortList = null;
        IXQEQueryNode[] children = rqpQuery.getChildrenOfType(801020);
        if (children.length > 0) {
            sortList = (RQPSortList)children[0];
        }
        return sortList;
    }

    private void nagSortMessage(PlanningEnvironment environment, IXQEQueryNode node, IMessageKey.Param1 message) {
        RSAPIDataset dataset = (RSAPIDataset)node.getAncestorOfType(401005);
        String queryName = dataset.getRefQueryName();
        IMessageKey.Param1 messageKey = message;
        String nagMsg = XQEMessages.getMessage(messageKey, XQEMessages.getCurrProductLocale(), queryName);
        ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nagMsg);
    }

    private boolean verifyProjectionsInSortList(List<RQPDataItem> rqpDataItems, RQPSortList rqpSortList) {
        boolean allProjectionsFound = true;
        int[] types = new int[]{201031, 201033, 201035};
        for (RQPDataItem rqpDataItem : rqpDataItems) {
            if (rqpDataItem.getDescendantsOfTypes(types, false).length > 0 || this.projectionInSortList(rqpDataItem, rqpSortList)) continue;
            allProjectionsFound = false;
            break;
        }
        return allProjectionsFound;
    }

    private boolean projectionInSortList(RQPDataItem rqpDataItem, RQPSortList rqpSortList) {
        boolean found = false;
        for (IXQEQueryNode sortItem : rqpSortList.getDescendantsOfType(801010, false)) {
            RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)sortItem;
            if (!selfRef.getName().equals(rqpDataItem.getName())) continue;
            found = true;
            break;
        }
        return found;
    }
}

