/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnection;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class PrepareDatabaseConnections
extends Transformation {
    public PrepareDatabaseConnections() {
        this.mName = "Resolve Connection Strings";
        this.mPassNumbers = new int[]{107};
        this.mTypes = new int[]{301016};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<DataSourceConnection> assemblyOfConnections;
        String connectionString;
        DataSourceConnection dsconn;
        SQLRelation sqlRelNode = (SQLRelation)node;
        String modelDS = sqlRelNode.getModelDatasourceName();
        IDataSource ds = sqlRelNode.getDataSource();
        MultiRequestContext multiCntxt = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext();
        if (ds == null) {
            ds = multiCntxt.getDataSourceByModelName(modelDS);
        }
        if ((dsconn = (DataSourceConnection)ds.getDataSourceConnection()).signonInInvalidState()) {
            dsconn.invalidateResolvedSignon();
        }
        if (!(connectionString = dsconn.getConnectionString(null)).startsWith(";LOCAL;JSON;")) {
            environment.setTreeHasBeenModified();
            return;
        }
        dsconn.tryExpand();
        DataSourceConnection relevantDSConn = dsconn;
        List<DataSourceConnection> list = assemblyOfConnections = dsconn.getAssemblyOfConnections();
        synchronized (list) {
            int connAssemblySize = assemblyOfConnections.size();
            for (int i = 0; !sqlRelNode.getName().equals(relevantDSConn.getName()) && i < connAssemblySize; ++i) {
                relevantDSConn = assemblyOfConnections.get(i);
            }
            if (relevantDSConn.getName().equals(sqlRelNode.getName()) || connAssemblySize == 0) {
                connectionString = relevantDSConn.getConnectionString(null);
                String resolvedConnectionString = null;
                if (MacroExpander.containsPound(connectionString)) {
                    MacroExpander ma = new MacroExpander();
                    resolvedConnectionString = ma.expand(null, environment, connectionString);
                } else {
                    resolvedConnectionString = connectionString;
                }
                sqlRelNode.setConnectionString(resolvedConnectionString);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        SQLRelation sqlRelNode = (SQLRelation)node;
        if (sqlRelNode.getDataSource() != null || sqlRelNode.getModelDatasourceName() != null) {
            String modelDS = sqlRelNode.getModelDatasourceName();
            IDataSource ds = sqlRelNode.getDataSource();
            MultiRequestContext multiCntxt = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext();
            if (ds == null) {
                ds = multiCntxt.getDataSourceByModelName(modelDS);
            }
            if (ds.getDataSourceConnection() instanceof DataSourceConnection) {
                DataSourceConnection dsconn = (DataSourceConnection)ds.getDataSourceConnection();
                String connectionString = dsconn.getConnectionString(null);
                if (connectionString.startsWith(";LOCAL;JSON;")) {
                    this.traceNodeCondition(true, "DataSource or Model DS Name defined against JSON connection.", xqeTrace);
                    return true;
                }
                if (dsconn.signonInInvalidState()) {
                    this.traceNodeCondition(true, "Signon has to be cleared.", xqeTrace);
                    return true;
                }
            } else {
                this.traceNodeCondition(false, "Complete connection string.", xqeTrace);
                return false;
            }
        }
        this.traceNodeCondition(false, "DataSource is not defined against JSON connection, and signon is in good state.", xqeTrace);
        return false;
    }
}

