/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public class ProcessStdAggregatesInGroupBy
extends RQPTransformation {
    public ProcessStdAggregatesInGroupBy() {
        this.mName = "ProcessStdAggregatesInGroupBy";
        this.mPassNumbers = new int[]{44, 51, 60};
        this.mTypes = new int[]{801010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode projExpression = ((RQPDataItemSelfRef)node).getRefProjection().getExpression();
        IXQEQueryNode[] aggregates = ExpressionAnalyzer.getAggregateNodes(projExpression);
        if (this.allAggregatesAreStdWithAutoForClause(aggregates) && !ExpressionAnalyzer.exprContainsCaseOrIfExpression(projExpression)) {
            IXQEQueryNode groupByList = node.getParent();
            node.extract();
            if (groupByList.getNumberChildren() == 0) {
                groupByList.extract();
            }
            return;
        }
        this.addForClauseToForAutoAggregates(environment, projExpression, aggregates);
    }

    private boolean allAggregatesAreStdWithAutoForClause(IXQEQueryNode[] aggregates) {
        if (aggregates == null || aggregates.length == 0) {
            return false;
        }
        for (IXQEQueryNode a : aggregates) {
            if (a.getType() != 201031) {
                return false;
            }
            V5AggregateFunction aggr = (V5AggregateFunction)a;
            if (aggr.getForClause() == null) continue;
            return false;
        }
        return true;
    }

    private void addForClauseToForAutoAggregates(PlanningEnvironment environment, IXQEQueryNode projExpression, IXQEQueryNode[] aggregates) {
        for (IXQEQueryNode a : aggregates) {
            V5AggregateFunction aggr = (V5AggregateFunction)a;
            if (aggr.getForClause() != null) continue;
            this.addForClause(environment, projExpression, aggr);
        }
    }

    private void addForClause(PlanningEnvironment environment, IXQEQueryNode projExpression, V5AggregateFunction aggr) {
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)environment.getNodeFactory().createNode(201037);
        RQPQuery summaryQuery = RQPSummaryQuery.getSummaryQueryMatchingAggregateForClause(environment, aggr, new int[]{801024, 801012});
        IXQEQueryNode[] forClauseItems = summaryQuery.getGroupingItems();
        if (forClauseItems != null) {
            for (IXQEQueryNode forClauseItem : forClauseItems) {
                IXQEQueryNode itemExpr = forClauseItem;
                if (itemExpr.getType() == 801010) {
                    itemExpr = ((RQPDataItemSelfRef)forClauseItem).getExpression();
                }
                if (ExpressionAnalyzer.exprOrRefExprHasAggregate(itemExpr)) continue;
                forClause.addChild(environment.getNodeFactory().deepCopyNode(itemExpr));
            }
        }
        aggr.addChild(forClause);
    }

    private boolean allAggregatesHaveForClause(IXQEQueryNode[] aggregates) {
        for (IXQEQueryNode a : aggregates) {
            V5AggregateFunction aggr = (V5AggregateFunction)a;
            if (aggr.getForClause() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (node.getAncestorOfType(801013) == null) {
            return false;
        }
        RQPDataItem projection = ((RQPDataItemSelfRef)node).getRefProjection();
        IXQEQueryNode[] standardAggregates = projection.getDescendantsOfType(201031, true);
        if (standardAggregates.length == 0) {
            return false;
        }
        return !this.allAggregatesHaveForClause(standardAggregates);
    }
}

