/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.PushDetailExpressionToTabularQuery;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class PushDetailCaseAndIfExpressionToTabularQuery
extends PushDetailExpressionToTabularQuery {
    public PushDetailCaseAndIfExpressionToTabularQuery() {
        this.mName = "Push detail case/if expression to tabular query.";
        this.mPassNumbers = new int[]{64};
        this.mTypes = new int[]{201018, 201017};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery sumQuery = RQPNode.getRQPQuery(node);
        List<RQPDataItem> grpProjs = sumQuery.getProjectionsMarkedAsGroupingColumns();
        IXQEQueryNode[] aggrs = node.getDescendantsOfType(201031, false);
        IXQEQueryNode backup = environment.getNodeFactory().deepCopyNode(node);
        for (IXQEQueryNode aggr : aggrs) {
            this.addScope(aggr, grpProjs, environment);
        }
        if (!PushDetailCaseAndIfExpressionToTabularQuery.pushWholeExpressionToTabularQuery(environment, node)) {
            node.exchange(backup);
            RQPTabularQuery.pushDetailExpressionsToTabularQuery(backup, environment);
        }
        RQPTabularQuery tabularQuery = sumQuery.getParentRQPQuery().getDefaultTabularQuery();
        tabularQuery.setPropertyValue("canNotBeCollapsed", true);
    }

    private static boolean pushWholeExpressionToTabularQuery(PlanningEnvironment environment, IXQEQueryNode expression) {
        RQPQuery parentRQPQuery = (RQPQuery)expression.getAncestorOfType(801044);
        if (parentRQPQuery == null) {
            parentRQPQuery = (RQPQuery)expression.getAncestorOfType(801017);
        }
        RQPTabularQuery tabularQuery = parentRQPQuery.getDefaultTabularQuery();
        IXQEQueryNode itemAncestor = expression.getAncestorOfType(801008);
        if (itemAncestor == null) {
            return false;
        }
        RQPDataItem projection = (RQPDataItem)itemAncestor;
        if (201018 != expression.getType() && 201017 != expression.getType() && !projection.isGroupingItem()) {
            return false;
        }
        if (201018 != expression.getType() && 201017 != expression.getType() && RQPUtilities.hasAggregateInExpression(expression)) {
            return false;
        }
        if (expression.getType() == 201116) {
            return false;
        }
        if (expression.getDescendantsOfType(801009, true).length > 0) {
            return false;
        }
        RQPDataItem tabularItem = tabularQuery.getRQPDataItem(environment, expression, projection.getName());
        RQPDataItemRef rqpDataItemRef = RQPDataItemRef.create(environment, tabularQuery.getName(), tabularItem.getName());
        expression.exchange(rqpDataItemRef);
        return true;
    }

    private void addScope(IXQEQueryNode aggr, List<RQPDataItem> grpProjs, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLWindow sqlWindow = (SQLWindow)nodeFactory.createNode(301041);
        aggr.addChild(sqlWindow);
        if (grpProjs.isEmpty()) {
            return;
        }
        SQLPartition sqlPartition = (SQLPartition)nodeFactory.createNode(301042);
        sqlWindow.addChild(sqlPartition);
        for (IXQEQueryNode iXQEQueryNode : grpProjs) {
            IXQEQueryNode projExp;
            IXQEQueryNode partitionByItem = projExp = iXQEQueryNode.getChild(0);
            if (801009 == projExp.getType()) {
                partitionByItem = ((RQPDataItemRef)projExp).getReferencedItem();
            }
            if (partitionByItem.getNodeType() == 801008) {
                sqlPartition.addChild(nodeFactory.deepCopyNode(partitionByItem.getChild(0)));
                continue;
            }
            sqlPartition.addChild(nodeFactory.deepCopyNode(partitionByItem));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The Case/If node is not under under RQPQuery structures or is alreay under tabular query", xqeTrace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (201031 != parent.getType()) {
            this.traceNodeCondition(false, "The Case/If node is not aggregated.", xqeTrace);
            return false;
        }
        if (!node.hasDescendantOfType(201031, false)) {
            this.traceNodeCondition(false, "The Case/If node does not contain aggregate.", xqeTrace);
            return false;
        }
        if (!RQPUtilities.isDetailExpression(node)) {
            this.traceNodeCondition(false, "The Case/If node does not return detail result.", xqeTrace);
            return false;
        }
        IXQEQueryNode rqpDataItem = node.getAncestorOfType(801008);
        if (rqpDataItem != null && ((RQPDataItem)rqpDataItem).isGroupingItem()) {
            this.traceNodeCondition(false, "The Case/If node is inside one of the grouping columns.", xqeTrace);
            return false;
        }
        List<IXQEQueryNode> identifiers = node.getDescendantsOfCategory(201115, true);
        int numberOfIdentifiersThatAreNotBoundParameter = 0;
        for (IXQEQueryNode identifier : identifiers) {
            if (identifier.getType() == 201127) continue;
            ++numberOfIdentifiersThatAreNotBoundParameter;
        }
        if (numberOfIdentifiersThatAreNotBoundParameter == 0) {
            this.traceNodeCondition(false, "The Case/If node does not have any bound identifiers.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The Case/If node needs to be pushed to the tabular query", xqeTrace);
        return true;
    }
}

