/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class PushDetailExpressionToTabularQuery
extends RQPTransformation {
    public static final String STAY_IN_OUTER_QUERY = "stayInOuterQuery";

    public PushDetailExpressionToTabularQuery() {
        this.mName = "Push detail expression to tabular query.";
        this.mPassNumbers = new int[]{65};
        this.mTypes = new int[]{201040, 201116, 201097, 201060, 201103};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPTabularQuery.pushDetailExpressionsToTabularQuery(node, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean b;
        XQETrace xqeTrace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The V5BoundMultipartIdentifier node is not under RQPQuery structures", xqeTrace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent.getNumberChildren() == 2 && node.getParent().getType() == 201011 && parent.getChild(1) == node) {
            this.traceNodeCondition(false, "The IN predicate argument does not get pushed to the tabular query.", xqeTrace);
            return false;
        }
        RQPQuery rqpQuery = RQPQuery.getRQPQuery(node);
        if (rqpQuery.getType() == 801025 || rqpQuery.isBridgeTabularQuery()) {
            this.traceNodeCondition(false, "The target node is already under the tabular query.", xqeTrace);
            return false;
        }
        if (rqpQuery.isRelalionalSubqueryForFirstAndLast()) {
            this.traceNodeCondition(false, "Skip this transformation in the context of a DMR relationalSubquery for first and last.", xqeTrace);
            return false;
        }
        if (node.getType() == 201040 && !PushDetailExpressionToTabularQuery.canPushScalarFunctionToTabularQuery(node)) {
            this.traceNodeCondition(false, "The projection needs to stay outside fact streams.", xqeTrace);
            return false;
        }
        if (node.getAncestorOfType(801035) != null) {
            this.traceNodeCondition(false, "The V5BoundMultipartIdentifier node will be under the tabular query.", xqeTrace);
            return false;
        }
        if (node.getType() == 201060 && (b = (Boolean)node.getPropertyValue("isDetail")) != null && !b.booleanValue()) {
            return false;
        }
        this.traceNodeCondition(false, "The V5BoundMultipartIdentifier node needs to be pushed to the tabular query", xqeTrace);
        return true;
    }

    public static boolean canPushScalarFunctionToTabularQuery(IXQEQueryNode node) {
        if (PushDetailExpressionToTabularQuery.shouldStayInOuterQuery(node)) {
            return false;
        }
        if (node.getDescendantsOfType(801009, true).length > 0) {
            return false;
        }
        if (RQPUtilities.hasAggregateInExpression(node)) {
            return false;
        }
        return !PushDetailExpressionToTabularQuery.containsCalculationReference(node);
    }

    private static boolean containsCalculationReference(IXQEQueryNode node) {
        for (IXQEQueryNode ref : node.getDescendantsOfType(201060, false)) {
            V5BoundDataItemReference boundRef = (V5BoundDataItemReference)ref;
            if (boundRef.isQueryRefItem()) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldStayInOuterQuery(IXQEQueryNode node) {
        IXQEQueryNode detailFilter = node.getAncestorOfType(101008);
        IXQEQueryNode projection = node.getAncestorOfType(801008);
        return projection != null && projection.getBooleanPropertyValue(STAY_IN_OUTER_QUERY) != null || detailFilter != null && detailFilter.getBooleanPropertyValue(STAY_IN_OUTER_QUERY) != null;
    }
}

