/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DetectNoOpAggregates;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class PushExprContainsDetailAndAggregateExprToTabularQuery
extends RQPTransformation {
    public PushExprContainsDetailAndAggregateExprToTabularQuery() {
        this.mName = "PushAggregateExprContainsDetailAndAggregateExprToTabularQuery";
        this.mPassNumbers = new int[]{44};
        this.mTypes = new int[]{201031, 201033, 201035};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5AggregateBreakClause forClause;
        RQPQuery queryOfAggregate = RQPQuery.getRQPQuery(node);
        RQPTabularQuery tabularQuery = queryOfAggregate.getParentRQPQuery().getDefaultTabularQuery();
        RQPDataItem itemAncestor = (RQPDataItem)node.getAncestorOfType(801008);
        String preferredName = itemAncestor.getName();
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        if (aggregate.getRollupAggregateNode() && (forClause = aggregate.getForClause()) == null) {
            IXQEQueryNode[] scope;
            forClause = (V5AggregateBreakClause)environment.getNodeFactory().createNode(201037);
            for (IXQEQueryNode scopeItem : scope = DetectNoOpAggregates.getScope(aggregate, environment)) {
                RQPDataItemRef diRef = (RQPDataItemRef)scopeItem.getFirstChildByType(801009);
                IXQEQueryNode pbExpr = environment.getNodeFactory().deepCopyNode(diRef.getReferencedItem().getExpression());
                forClause.addChild(pbExpr);
            }
            aggregate.addChild(forClause);
        }
        RQPDataItem tabularItem = tabularQuery.getRQPDataItem(environment, node, preferredName);
        RQPDataItemRef rqpDataItemRef = RQPDataItemRef.create(environment, tabularQuery.getName(), tabularItem.getName());
        node.exchange(rqpDataItemRef);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The expression node is not under under RQPQuery structures", trace);
            return false;
        }
        RQPQuery queryOfAggregate = RQPQuery.getRQPQuery(node);
        if (queryOfAggregate.getParentRQPQuery().isAutoSummaryTRUE()) {
            this.traceNodeCondition(false, "The transformation is applicable only for query with autoSummary=false", trace);
            return false;
        }
        RQPDataItem itemAncestor = (RQPDataItem)node.getAncestorOfType(801008);
        if (itemAncestor == null) {
            this.traceNodeCondition(false, "The expression node is not from the projection list", trace);
            return false;
        }
        if (!this.expContainsDetailAndAggregateExpr(environment, node)) {
            this.traceNodeCondition(false, "The expression node does not contain both aggregate and detail expression", trace);
            return false;
        }
        return true;
    }

    public boolean expContainsDetailAndAggregateExpr(PlanningEnvironment environment, IXQEQueryNode expression) {
        return this.isExpressionContainsAggregateExpr(expression) && RQPUtilities.containsDetailExpr(expression);
    }

    private boolean isExpressionContainsAggregateExpr(IXQEQueryNode expr) {
        for (int i = 0; i < expr.getNumberChildren(); ++i) {
            if (!RQPUtilities.hasAggregateInExpression(expr.getChild(i))) continue;
            return true;
        }
        return false;
    }
}

