/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ReplaceNullValuesWithIsNull
extends Transformation {
    public ReplaceNullValuesWithIsNull() {
        this(new int[]{49});
    }

    public ReplaceNullValuesWithIsNull(int[] passNumbers) {
        this.mName = "Replace Null Values with IS NULL expression";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{301026, 301076};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLIsNull isNullNode;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        boolean allNulls = true;
        SQLComparison.SubType subType = SQLComparison.SubType.EQUAL;
        if (node.getType() == 301026) {
            subType = ((SQLComparison)node).getSubType();
        }
        SQLAbstractBooleanFunction nodeToExchange = isNullNode = (SQLIsNull)nodeFactory.createNode(301024);
        if (subType == SQLComparison.SubType.NOTEQUAL) {
            SQLLogical logicalNode = (SQLLogical)environment.getNodeFactory().createNode(301027);
            logicalNode.setSubType(SQLLogical.SubType.NOT);
            logicalNode.addChild(isNullNode);
            nodeToExchange = logicalNode;
        }
        isNullNode.addChild(nodeFactory.deepCopyNode(node.getChild(0)));
        IXQEQueryNode[] literalNodes = node.getDescendantsOfType(301031, false);
        if (literalNodes.length > 0) {
            allNulls = false;
        }
        if (allNulls) {
            node.exchange(nodeToExchange);
        } else {
            IXQEQueryNode[] nullNodes = node.getDescendantsOfType(301050, false);
            for (int i = 0; i < nullNodes.length; ++i) {
                nullNodes[i].extract();
            }
            SQLLogical logical = (SQLLogical)nodeFactory.createNode(301027);
            logical.setSubType(SQLLogical.SubType.OR);
            logical.addChild(isNullNode);
            node.insertParent(logical);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode valueList;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getType() == 301026 && node.hasChildOfType(301050)) {
            status = true;
        }
        if (node.getType() == 301076 && (valueList = node.getFirstChildByType(301030)) != null && valueList.hasChildOfType(301050)) {
            status = true;
        }
        if (status) {
            SQLComparison comparison;
            SQLComparison.SubType subType;
            this.traceQueryCondition(status, "There are NULL values in the value list.", trace);
            if (node.getType() == 301026 && (subType = (comparison = (SQLComparison)node).getSubType()) != SQLComparison.SubType.EQUAL && subType != SQLComparison.SubType.NOTEQUAL) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidNullValueComparison, subType.key());
            }
        } else {
            this.traceQueryCondition(status, "There aren't any NULL values in the value list.", trace);
        }
        return status;
    }
}

