/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.V5QueryTypeCheck;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ReplaceQRDWithRQPQuery
extends Transformation {
    public ReplaceQRDWithRQPQuery() {
        this.mName = "Replace QRD with RQPQuery.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{101055};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        block22: {
            RQPQuery rootQuery = (RQPQuery)environment.getNodeFactory().createNode(801017);
            RQPSql rqpSQL = null;
            if (node.getParent().getType() == 401005) {
                rqpSQL = (RQPSql)environment.getNodeFactory().createNode(801041);
                rqpSQL.setPropertyValue("dumped", false);
                node.insertParent(rqpSQL);
            }
            String refQueryName = (String)node.getPropertyValue("refQuery");
            rootQuery.setPropertyValue("refQuery", refQueryName);
            if (rqpSQL != null) {
                rqpSQL.setName(refQueryName);
                String topNRows = (String)node.getPropertyValue("topNRows");
                if (topNRows != null) {
                    rqpSQL.setPropertyValue("topNRows", topNRows);
                }
            }
            rootQuery.setName(refQueryName);
            node.exchange(rootQuery, true);
            V5Query refV5Query = rootQuery.getRefV5Query();
            try (MetadataConnectionContext mc = null;){
                IXQEQueryNode[] v5Queries;
                V5Query rootDSQS;
                Boolean autoSumAttribute;
                if (environment.isMultiModelForQueryEnabled()) {
                    V5Query v5query = refV5Query;
                    if (v5query == null) {
                        v5query = RQPNode.getV5Query(rootQuery);
                    }
                    if (v5query != null) {
                        mc = environment.pushMetadataConnectionContext(v5query.getMetadataPath());
                    }
                }
                rootQuery.createDefaultTabularQuery(environment);
                rootQuery.createDefaultSummaryQuery(environment);
                rootQuery.createRMQueryList(environment);
                rootQuery.createFactManager(environment);
                rootQuery.createJoinInfo(environment);
                if (refV5Query != null) {
                    rootQuery.setPropertyValue("v5ref", refV5Query);
                }
                V5Selection v5Selection = refV5Query.getV5Selection();
                if (refV5Query.getDistinct()) {
                    rootQuery.setDistinct(true);
                }
                boolean autoSummary = (autoSumAttribute = v5Selection.getBooleanPropertyValue("autoSummary")) == null || autoSumAttribute != false;
                rootQuery.setPropertyValue("autoSummary", autoSummary);
                Boolean origAutoSummary = (Boolean)v5Selection.getPropertyValue("originalAutoSummary");
                if (origAutoSummary != null) {
                    rootQuery.setPropertyValue("originalAutoSummary", origAutoSummary);
                }
                if ((rootDSQS = (V5Query)refV5Query.getPropertyValue("rootDSQSQuery")) != null) {
                    rootQuery.setPropertyValue("rootDSQSQuery", rootDSQS);
                }
                if (rqpSQL == null) break block22;
                rootQuery.setPropertyValue("isReferencedByQRD", Boolean.TRUE);
                IXQEQueryNode dataSet = rootQuery.getAncestorOfType(401005);
                if (dataSet == null) break block22;
                Object subquerySource = refV5Query.getPropertyValue("relationalSubquerySource");
                if (subquerySource != null) {
                    rqpSQL.setPropertyValue("relationalSubquerySource", subquerySource);
                }
                if (refV5Query.getPropertyValue("relationalSubquery") != null) {
                    rqpSQL.setPropertyValue("relationalSubquery", true);
                    return;
                }
                if (refV5Query.getPropertyValue("hasOlapOperand") != null) {
                    rqpSQL.setPropertyValue("relationalSubquery", true);
                    return;
                }
                if (node.getPropertyValue("relationalCrossTab") != null) {
                    rqpSQL.setPropertyValue("relationalSubquery", true);
                    return;
                }
                IXQEQueryNode v5QuerySet = dataSet.getAncestorOfType(101002);
                if (v5QuerySet == null) break block22;
                for (IXQEQueryNode v5Query : v5Queries = v5QuerySet.getChildrenOfType(101006)) {
                    if (v5Query.getPropertyValue("isTabular") != Boolean.FALSE) continue;
                    rqpSQL.setPropertyValue("relationalSubquery", true);
                    break;
                }
            }
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (V5QueryTypeCheck.isRelationalQuery(node)) {
            status = true;
            this.traceQueryCondition(status, "The V5 Query is a relational query.", trace);
        } else {
            String notRelationalQuery = "The V5 Query is not a relational query.";
            status = false;
            this.traceQueryCondition(status, "The V5 Query is not a relational query.", trace);
        }
        return status;
    }
}

