/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.AggregateExpressionBuilder;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ResolveDataItemReferenceCalculateAggregate
extends Transformation {
    public ResolveDataItemReferenceCalculateAggregate() {
        this.mName = "ResolveDataItemReferenceCalculateAggregate.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{101003};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem targetDataItem = (V5DataItem)RQPUtilities.findTargetDataItem(node, ((V5DataItem)node).getNameProperty());
        if (targetDataItem != null) {
            node.exchange(environment.getNodeFactory().deepCopyNode(targetDataItem), false);
            return;
        }
        V5Selection selection = RQPUtilities.getV5Selection(node);
        V5DataItem dataItemInSelection = selection.getDataItemByRefName(((V5DataItem)node).getNameProperty());
        if (dataItemInSelection == null) {
            node.extract();
            return;
        }
        if (dataItemInSelection == node.getParent()) {
            node.extract();
            return;
        }
        IXQEQueryNode child = dataItemInSelection.getChild(0);
        IXQEQueryNode nodeAggExpr = environment.getNodeFactory().deepCopyNode(child);
        IXQEQueryNode[] dataItemRefChildren = nodeAggExpr.getDescendantsOfType(101003, true);
        for (int i = 0; i < dataItemRefChildren.length; ++i) {
            IXQEQueryNode[] aggFunc = dataItemRefChildren[i].getAncestorsOfTypes(new int[]{201031, 201033});
            boolean isChildOfGroupAggregation = false;
            for (int j = 0; j < aggFunc.length; ++j) {
                if (!RQPUtilities.isGroupAggrationFunction(((V5AggregateFunction)aggFunc[j]).getSubType())) continue;
                isChildOfGroupAggregation = true;
                break;
            }
            if (isChildOfGroupAggregation) {
                dataItemRefChildren[i].extract();
                continue;
            }
            IXQEQueryNode childExpr = null;
            boolean useDetailExpression = dataItemRefChildren[i].getAncestorOfType(201037) != null;
            childExpr = useDetailExpression ? ((V5DataItem)dataItemRefChildren[i]).getDetailExpression() : ((V5DataItem)dataItemRefChildren[i]).getAggregateExpression(environment);
            if (childExpr == null) {
                IXQEQueryNode dataItem = RQPUtilities.findTargetDataItem(dataItemInSelection, ((V5DataItem)dataItemRefChildren[i]).getNameProperty());
                childExpr = useDetailExpression ? ((V5DataItem)dataItem).getDetailExpression() : ((V5DataItem)dataItem).getAggregateExpression(environment);
            }
            IXQEQueryNode tmpAggrExpr = environment.getNodeFactory().deepCopyNode(childExpr);
            if (nodeAggExpr == dataItemRefChildren[i]) {
                nodeAggExpr = tmpAggrExpr;
                continue;
            }
            dataItemRefChildren[i].exchange(tmpAggrExpr, false);
        }
        AggregateExpressionBuilder aggregateExprBuilder = new AggregateExpressionBuilder(environment);
        IXQEQueryNode aggregateExpr = aggregateExprBuilder.generateAggregateExpression(dataItemInSelection.getAggregateProperty(), nodeAggExpr);
        dataItemInSelection.setAggregateExpression(aggregateExpr);
        this.replaceChildV5DataItemDetailExpressionWithDetailContext(environment, dataItemInSelection);
        this.updateDetailContext(environment, selection, dataItemInSelection);
        if (dataItemInSelection != node) {
            node.exchange(environment.getNodeFactory().deepCopyNode(dataItemInSelection), false);
        }
    }

    private void replaceChildV5DataItemDetailExpressionWithDetailContext(PlanningEnvironment environment, IXQEQueryNode expr) {
        IXQEQueryNode[] dataItemRefChildren = expr.getDescendantsOfType(101003, false);
        for (int j = 0; j < dataItemRefChildren.length; ++j) {
            ((V5DataItem)dataItemRefChildren[j]).getDetailExpression().exchange(((V5DataItem)dataItemRefChildren[j]).getDetailContext(environment));
            dataItemRefChildren[j].extract();
        }
    }

    private void updateDetailContext(PlanningEnvironment environment, V5Selection selection, V5DataItem dataItemInSelection) {
        IXQEQueryNode dc = (IXQEQueryNode)dataItemInSelection.getPropertyValue("detailContext");
        IXQEQueryNode[] dataItemRefChildren = dc.getDescendantsOfType(101003, false);
        for (int j = 0; j < dataItemRefChildren.length; ++j) {
            V5DataItem di = (V5DataItem)dataItemRefChildren[j];
            V5DataItem refDIInSelection = selection.getDataItemByRefName(di.getNameProperty());
            if (refDIInSelection != null) {
                di.getDetailExpression().exchange(refDIInSelection.getDetailContext(environment));
            }
            di.extract();
        }
        if (dc.getType() == 101003) {
            dataItemInSelection.setDetailContext(((V5DataItem)dc).getDetailExpression());
            dc.extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean passedInNodeMatchesTheDataItemInSelection;
        XQETrace xqeTrace = environment.getTrace();
        if (null != ((V5DataItem)node).getAggregateExpression()) {
            return false;
        }
        String aggr = ((V5DataItem)node).getAggregateProperty();
        if (aggr == null || !aggr.equals("calculated")) {
            return false;
        }
        if (!node.isWithinScope(101006, 1002)) {
            this.traceNodeCondition(false, "The node is not a relational query.", xqeTrace);
            return false;
        }
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (querySet == null) {
            return false;
        }
        if (!querySet.hasDescendantOfType(801017, false)) {
            this.traceNodeCondition(false, "The query is not a relational query.", xqeTrace);
            return false;
        }
        V5Selection selection = RQPUtilities.getV5Selection(node);
        V5DataItem dataItemInSelection = selection.getDataItemByRefName(((V5DataItem)node).getNameProperty());
        boolean bl = passedInNodeMatchesTheDataItemInSelection = dataItemInSelection == node || dataItemInSelection == node.getParent();
        if (dataItemInSelection != null && !passedInNodeMatchesTheDataItemInSelection && null == dataItemInSelection.getAggregateExpression()) {
            return false;
        }
        IXQEQueryNode[] descendants = node.getDescendantsOfType(101003, false);
        if (descendants.length == 0) {
            return false;
        }
        for (int i = 0; i < descendants.length; ++i) {
            V5DataItem v5DiDescendant = (V5DataItem)descendants[i];
            if (v5DiDescendant.hasDescendantOfType(101003, false)) {
                return false;
            }
            if (null != v5DiDescendant.getAggregateExpression()) continue;
            if (v5DiDescendant.getPropertyValue("refModelObjectName") != null) {
                return false;
            }
            V5DataItem targetDataItem = (V5DataItem)RQPUtilities.findTargetDataItem(node, v5DiDescendant.getNameProperty());
            if (null != targetDataItem) continue;
            return false;
        }
        return true;
    }
}

