/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.PushDetailExpressionToTabularQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class RewriteTabularReferencesInOutermostQueryInTermsOfLLSQ
extends RQPTransformation {
    public RewriteTabularReferencesInOutermostQueryInTermsOfLLSQ() {
        this.mName = "Push detail expression to tabular query.";
        this.mPassNumbers = new int[]{66};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery refQuery;
        RQPDataItemRef dataItemRef;
        List<IXQEQueryNode> allDIRefs = RewriteTabularReferencesInOutermostQueryInTermsOfLLSQ.getAllDIRefsInQuery(node);
        RQPQuery summaryQuery = null;
        for (IXQEQueryNode diRef : allDIRefs) {
            dataItemRef = (RQPDataItemRef)diRef;
            refQuery = dataItemRef.getQuery();
            if (refQuery.isTabularQuery()) continue;
            summaryQuery = refQuery;
            break;
        }
        for (IXQEQueryNode diRef : allDIRefs) {
            dataItemRef = (RQPDataItemRef)diRef;
            refQuery = dataItemRef.getQuery();
            if (!refQuery.isTabularQuery()) continue;
            RQPDataItem dataItem = dataItemRef.getReferencedItem();
            IXQEQueryNode expression = dataItem.getExpression();
            String preferredName = RQPSummaryQuery.getDataItemName(summaryQuery, expression);
            RQPDataItem newRQPDataItem = summaryQuery.getRQPDataItem(environment, expression, preferredName);
            RQPDataItemRef newDIRef = RQPDataItemRef.create(environment, newRQPDataItem);
            dataItemRef.exchange(newDIRef);
            IXQEQueryNode newExpression = newRQPDataItem.getChild(0);
            PushDetailExpressionToTabularQuery transformation = new PushDetailExpressionToTabularQuery();
            if (!(newExpression instanceof V5BoundModelIdentifier) || !transformation.passesNodeCondition(newExpression, environment)) continue;
            transformation.apply(newExpression, environment);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        if (rqpQuery.getRootRQPQuery() != rqpQuery) {
            this.traceNodeCondition(false, "The input node is not the outermost RQPQuery.", xqeTrace);
            return false;
        }
        if (rqpQuery.isAutoSummaryFALSE()) {
            this.traceNodeCondition(false, "autoSummary=TRUE must be set.", xqeTrace);
            return false;
        }
        List<IXQEQueryNode> allDIRefs = RewriteTabularReferencesInOutermostQueryInTermsOfLLSQ.getAllDIRefsInQuery(node);
        TreeSet<String> refQueryNames = new TreeSet<String>();
        for (IXQEQueryNode diRef : allDIRefs) {
            refQueryNames.add(((RQPDataItemRef)diRef).getQueryName());
        }
        if (refQueryNames.size() <= 1) {
            this.traceNodeCondition(false, "Outermost query references only one single subquery.", xqeTrace);
            return false;
        }
        List<RQPQuery> subqueriesToJoin = rqpQuery.getSubqueriesToJoin();
        if (refQueryNames.size() > 1 && subqueriesToJoin.size() > 1) {
            this.traceNodeCondition(false, "The LLSQ and the tablar query are joinable.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(false, "The transformation needs to be applied.", xqeTrace);
        return true;
    }

    private static List<IXQEQueryNode> getAllDIRefsInQuery(IXQEQueryNode node) {
        int[] listsToSearch;
        ArrayList<IXQEQueryNode> allDIRefs = new ArrayList<IXQEQueryNode>();
        for (int list : listsToSearch = new int[]{801016, 801011}) {
            IXQEQueryNode listChild = node.getFirstChildByType(list);
            if (listChild == null) continue;
            List<IXQEQueryNode> diRefs = listChild.getDescendantsOfTypeOrdered(801009, false, 801017);
            allDIRefs.addAll(diRefs);
        }
        return allDIRefs;
    }
}

