/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.List;

public class SetDetailContextOfV5DataItem
extends Transformation {
    public SetDetailContextOfV5DataItem() {
        this.mName = "SetDetailContextOfV5DataItem";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{101009};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] allDataItems;
        Boolean autoSumAttribute;
        V5Selection selection = (V5Selection)node;
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        V5QuerySet querySet = (V5QuerySet)query.getAncestorOfType(101002);
        ArrayList<IXQEQueryNode> needDetailContext = new ArrayList<IXQEQueryNode>();
        if (node.getGovernors().getRemoveAggregateOpWhenFltPAAIsFalse().booleanValue()) {
            IXQEQueryNode[] detailFilters;
            for (IXQEQueryNode f : detailFilters = query.getV5DetailFilters()) {
                V5DetailFilter filter = (V5DetailFilter)f;
                if (filter.getPostAutoAggregation()) continue;
                this.getOriginalV5DataItem(filter, needDetailContext);
            }
        }
        if (node.getGovernors().getRemoveAggregateOpWhenDataItemAggIsNone().booleanValue()) {
            IXQEQueryNode[] dataItemsInSelection = selection.getChildren();
            for (IXQEQueryNode di : dataItemsInSelection) {
                V5DataItem dataItem = (V5DataItem)di;
                String aggregate = dataItem.getAggregateProperty();
                if (aggregate == null || !aggregate.equals("none")) continue;
                this.getOriginalV5DataItem(dataItem, needDetailContext);
            }
        }
        boolean autoSummary = (autoSumAttribute = selection.getBooleanPropertyValue("autoSummary")) == null || autoSumAttribute != false;
        boolean generateDetailContextForDecomposedQuery = false;
        if (querySet.getAncestorOfType(101072) != null || !query.isRelStyle() || query.isDMR() || query.isROLAP() || query.isDMRtoRQP() || query.getDynamicSQS() != null || query.getPropertyValue("queryForNonDSQSItems") != null) {
            generateDetailContextForDecomposedQuery = true;
        }
        for (IXQEQueryNode di : allDataItems = query.getDescendantsOfType(101003, false)) {
            V5DataItem dataItem = (V5DataItem)di;
            V5DataItem originalV5DataItem = dataItem.getOriginalV5DataItem();
            if (originalV5DataItem != null && !generateDetailContextForDecomposedQuery) continue;
            this.applyOnDataItem(environment, (V5DataItem)di, autoSummary, needDetailContext.contains(di));
        }
    }

    private void applyOnDataItem(PlanningEnvironment environment, V5DataItem dataItem, boolean autoSummary, boolean needDetailContextForDataItemOrFilter) {
        if (autoSummary && !needDetailContextForDataItemOrFilter) {
            IXQEQueryNode dataItemRef = environment.getNodeFactory().createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", dataItem.getNameProperty());
            dataItem.setDetailContext(dataItemRef);
            return;
        }
        String aggr = dataItem.getAggregateProperty();
        if (aggr != null && !aggr.equals("automatic") && !aggr.equals("calculated")) {
            IXQEQueryNode dataItemRef = environment.getNodeFactory().createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", dataItem.getNameProperty());
            dataItem.setDetailContext(dataItemRef);
            return;
        }
        List<IXQEQueryNode> aggregatesToBeDropped = this.getAggregatesThatCanBeDropped(dataItem.getDetailExpression());
        if (aggregatesToBeDropped.size() == 0) {
            IXQEQueryNode dataItemRef = environment.getNodeFactory().createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", dataItem.getNameProperty());
            dataItem.setDetailContext(dataItemRef);
            return;
        }
        IXQEQueryNode dataItemExpr = environment.getNodeFactory().deepCopyNode(dataItem.getDetailExpression());
        aggregatesToBeDropped = this.getAggregatesThatCanBeDropped(dataItemExpr);
        for (IXQEQueryNode aggregate : aggregatesToBeDropped) {
            if (aggregate == dataItemExpr) {
                dataItemExpr = aggregate.getChild(0);
            }
            aggregate.extract();
        }
        dataItem.setDetailContext(dataItemExpr);
    }

    private void getOriginalV5DataItem(IXQEQueryNode filterOrDataItemNode, List<IXQEQueryNode> originalV5DataItems) {
        IXQEQueryNode[] dataItemRefUnderFilter;
        for (IXQEQueryNode dir : dataItemRefUnderFilter = filterOrDataItemNode.getDescendantsOfType(101003, false)) {
            V5DataItem dataItemref = (V5DataItem)dir;
            V5DataItem originalV5DataItem = dataItemref.getOriginalV5DataItem();
            if (originalV5DataItem == null || originalV5DataItems.contains(originalV5DataItem)) continue;
            originalV5DataItems.add(originalV5DataItem);
        }
    }

    private List<IXQEQueryNode> getAggregatesThatCanBeDropped(IXQEQueryNode dataItemExpr) {
        IXQEQueryNode[] aggrFuncNodes = this.getAggregateFuncNodes(dataItemExpr);
        ArrayList<IXQEQueryNode> aggrThatCanBeDropped = new ArrayList<IXQEQueryNode>();
        if (aggrFuncNodes == null) {
            return aggrThatCanBeDropped;
        }
        for (IXQEQueryNode node : aggrFuncNodes) {
            V5AggregateFunction aggregateAncestor;
            V5AggregateFunction aggregate = (V5AggregateFunction)node;
            if (aggregate.getForClause() != null || !RQPUtilities.isAggregateToBeAdjustedForDetailContext(aggregate) || (aggregateAncestor = (V5AggregateFunction)aggregate.getAncestorOfType(201031)) != null && this.isSummaryAggregate(aggregateAncestor)) continue;
            aggrThatCanBeDropped.add(aggregate);
        }
        return aggrThatCanBeDropped;
    }

    private IXQEQueryNode[] getAggregateFuncNodes(IXQEQueryNode expr) {
        int[] aggrFuncTypes = new int[]{201031, 201033};
        return expr.getDescendantsOfTypes(aggrFuncTypes, true);
    }

    private boolean isSummaryAggregate(V5AggregateFunction aggregate) {
        return RQPUtilities.isGroupAggrationFunction(aggregate.getSubType());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (!node.isWithinScope(101006, 1002)) {
            this.traceNodeCondition(false, "The node is not a relational query.", xqeTrace);
            return false;
        }
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        V5QuerySet querySet = (V5QuerySet)v5Query.getAncestorOfType(101002);
        if (querySet == null) {
            this.traceNodeCondition(false, "The query is out of the tree.", xqeTrace);
            return false;
        }
        if (!querySet.hasDescendantOfType(801017, false)) {
            this.traceNodeCondition(false, "The query is not a relational query.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "Generate the detail context.", xqeTrace);
        return true;
    }
}

