/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class SplitSummaryQueryToAvoidCircularReference
extends RQPTransformation {
    public static final String PROP_SUBQUERY_TOBE_SPLIT = "subQueryToBeSplit";
    public static final String PROP_SUBQUERY_TOBE_UPDATED = "subQueryToBeUpdated";
    private static final String ARROW = "->";

    public SplitSummaryQueryToAvoidCircularReference() {
        this.mName = "SplitSummaryQueryToAvoidCircularReference.";
        this.mPassNumbers = new int[]{74};
        this.mTypes = new int[]{801024};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPSummaryQuery originalSummaryQuery = (RQPSummaryQuery)node;
        RQPQuery queryToBeSplit = (RQPQuery)node.getPropertyValue(PROP_SUBQUERY_TOBE_SPLIT);
        RQPSummaryQuery newSumQuery = RQPQuery.createSummaryQueryWithSameScope(environment, queryToBeSplit);
        RQPQuery queryToBeUpdated = (RQPQuery)node.getPropertyValue(PROP_SUBQUERY_TOBE_UPDATED);
        List<RQPDataItemRef> diRefs = queryToBeUpdated.getProjectionList().getReferencesMatchingName(queryToBeSplit.getName(), null);
        HashMap itemNameToReferenceObject = new HashMap();
        List references = null;
        for (RQPDataItemRef diRef : diRefs) {
            String itemName = diRef.getName();
            if (!itemNameToReferenceObject.containsKey(itemName)) {
                itemNameToReferenceObject.put(itemName, new ArrayList());
            }
            references = (List)itemNameToReferenceObject.get(itemName);
            references.add(diRef);
        }
        for (String itemName : itemNameToReferenceObject.keySet()) {
            SplitSummaryQueryToAvoidCircularReference.updateReferences(environment, (List)itemNameToReferenceObject.get(itemName), queryToBeSplit, newSumQuery, originalSummaryQuery.getName());
        }
        newSumQuery.setCanRewriteAsWindowedAggregates(false);
        originalSummaryQuery.removeProperty(PROP_SUBQUERY_TOBE_SPLIT);
        originalSummaryQuery.removeProperty(PROP_SUBQUERY_TOBE_UPDATED);
    }

    public static void updateReferences(PlanningEnvironment environment, List<RQPDataItemRef> oldReferences, RQPQuery queryToBeSplit, RQPSummaryQuery newSumQuery, String originalSummaryQueryName) {
        String itemName = oldReferences.get(0).getName();
        RQPDataItem projection = queryToBeSplit.getRQPDataItemByName(itemName);
        if (projection.getReferencesMatchingName(originalSummaryQueryName, null).size() > 0) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_CircularReferenceInSubQueries, originalSummaryQueryName);
        }
        RQPDataItem newProjection = newSumQuery.createRQPDataItem(environment, itemName);
        newProjection.addChild(environment.getNodeFactory().deepCopyNode(projection.getExpression()));
        for (RQPDataItemRef diRef : oldReferences) {
            diRef.setQueryName(newSumQuery.getName());
            diRef.setName(newProjection.getName());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPSummaryQuery currentSubQuery = (RQPSummaryQuery)node;
        Stack<RQPQuery> visitedQueries = new Stack<RQPQuery>();
        List<RQPQuery> refQueries = currentSubQuery.getSubquerySources();
        for (RQPQuery refQuery : refQueries) {
            if (!this.detectCircularReferenceBetween(currentSubQuery, currentSubQuery, refQuery, visitedQueries)) continue;
            this.traceNodeCondition(false, "This summary query has circular reference for sub-queries", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "This summary query does not have circular reference for sub-queries", xqeTrace);
        return false;
    }

    private boolean detectCircularReferenceBetween(RQPQuery originalSubQuery, RQPQuery subQueryToBeUpdated, RQPQuery subQueryToConsider, Stack<RQPQuery> visitedQueries) {
        visitedQueries.push(subQueryToConsider);
        List<RQPQuery> subQueries = subQueryToConsider.getSubquerySources();
        for (RQPQuery subQuery : subQueries) {
            if (subQuery.getName().equals(originalSubQuery.getName())) {
                originalSubQuery.setPropertyValue(PROP_SUBQUERY_TOBE_SPLIT, subQueryToConsider);
                originalSubQuery.setPropertyValue(PROP_SUBQUERY_TOBE_UPDATED, subQueryToBeUpdated);
                return true;
            }
            boolean throwInnerCircularReference = false;
            for (RQPQuery query : visitedQueries) {
                if (!query.getName().equals(subQuery.getName())) continue;
                throwInnerCircularReference = true;
                break;
            }
            if (throwInnerCircularReference) {
                StringBuilder str = new StringBuilder();
                str.append(originalSubQuery.getName());
                str.append(ARROW);
                for (RQPQuery query : visitedQueries) {
                    str.append(query.getName());
                    str.append(ARROW);
                }
                str.append(subQuery.getName());
                throw new XQERuntimeException(XQEMessageKeys.PLN_CircularReferenceInSubQueries, str.toString());
            }
            if (!this.detectCircularReferenceBetween(originalSubQuery, subQueryToConsider, subQuery, visitedQueries)) continue;
            return true;
        }
        visitedQueries.pop();
        return false;
    }
}

