/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.MoveGroupingItemsToSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class SplitSummaryQueryToAvoidGeneratingNestedStdAggregates
extends RQPTransformation {
    public SplitSummaryQueryToAvoidGeneratingNestedStdAggregates() {
        this.mName = "SplitSummaryQueryToAvoidGeneratingNestedStdAggregates.";
        this.mPassNumbers = new int[]{76};
        this.mTypes = new int[]{201031};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IXQEQueryNode> nestedSummaryFunctions = node.getDescendantsOfTypesOrdered(new int[]{201031}, false);
        V5AggregateFunction nestedAgg = null;
        for (IXQEQueryNode nestedAggr : nestedSummaryFunctions) {
            if (nestedAggr.getAncestorOfType(201037) != null || nestedAggr.getAncestorOfType(201036) != null) continue;
            nestedAgg = (V5AggregateFunction)nestedAggr;
            break;
        }
        if (nestedAgg != null) {
            RQPDataItem projection = (RQPDataItem)node.getAncestorOfType(801008);
            RQPQuery originalSummaryQuery = RQPNode.getRQPQuery(node);
            RQPSummaryQuery newSumQuery = originalSummaryQuery.findSumQueryCreatedFromSplitAndWithSameScope();
            if (newSumQuery == null) {
                newSumQuery = RQPQuery.createSummaryQueryWithSameScope(environment, (RQPSummaryQuery)originalSummaryQuery);
            }
            MoveGroupingItemsToSubQuery.createRQPDataItemInSubQueryAndRefInParentQuery(environment, newSumQuery, nestedAgg, projection.getName(), true);
            newSumQuery.setCanRewriteAsWindowedAggregates(false);
            if (newSumQuery.getPropertyValue("createdFromSplit") == null) {
                newSumQuery.setPropertyValue("createdFromSplit", true);
            }
            if (originalSummaryQuery == originalSummaryQuery.getRootRQPQuery().getLowestLevelSummaryQuery()) {
                originalSummaryQuery.setLowestLevelSummaryQueryProperty(newSumQuery);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The V5SummaryFunction node is not under a RQP query", xqeTrace);
            return false;
        }
        RQPDataItem di = (RQPDataItem)node.getAncestorOfType(801008);
        if (di == null) {
            this.traceNodeCondition(false, "The V5SummaryFunction is not in a projection expression", xqeTrace);
            return false;
        }
        if (di.isGroupingItem()) {
            this.traceNodeCondition(false, "Cannot split when the dataItem is a grouping item.", xqeTrace);
            return false;
        }
        RQPQuery parentQuery = RQPNode.getRQPQuery(node);
        if (!parentQuery.isSummarizedQuery()) {
            this.traceNodeCondition(false, "The V5SummaryFunction is not in a summary query", xqeTrace);
            return false;
        }
        List<IXQEQueryNode> nestedSummaryFunctions = node.getDescendantsOfTypesOrdered(new int[]{201031}, false);
        int numberNestedAggregatesUnderForClause = 0;
        for (IXQEQueryNode nestedAggr : nestedSummaryFunctions) {
            if (nestedAggr.getAncestorOfType(201037) == null && nestedAggr.getAncestorOfType(201036) == null) continue;
            ++numberNestedAggregatesUnderForClause;
        }
        if (numberNestedAggregatesUnderForClause == nestedSummaryFunctions.size()) {
            this.traceNodeCondition(false, "All the nested aggregates are under the explicit FOR|AT clause", xqeTrace);
            return false;
        }
        if (nestedSummaryFunctions.size() > 0) {
            this.traceNodeCondition(true, "The V5SummaryFunction has nested aggregate in the same scope", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "The V5SummaryFunction does not have nested aggregate in the same summary query", xqeTrace);
        return false;
    }
}

