/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;
import org.apache.commons.collections.iterators.ArrayIterator;

public class SplitSummaryQueryToAvoidJoiningWithTabularQuery
extends RQPTransformation {
    public SplitSummaryQueryToAvoidJoiningWithTabularQuery() {
        this.mName = "Split the summary query to avoid joining with tabular query.";
        this.mPassNumbers = new int[]{74};
        this.mTypes = new int[]{801024, 801012};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPSummaryQuery originalSummaryQuery = (RQPSummaryQuery)node;
        RQPSummaryQuery newSumQuery = RQPQuery.createSummaryQueryWithSameScope(environment, originalSummaryQuery);
        IXQEQueryNode[] projections = originalSummaryQuery.getProjectionList().getChildren();
        ArrayIterator iterator = new ArrayIterator((Object)projections);
        while (iterator.hasNext()) {
            RQPDataItem projection = (RQPDataItem)iterator.next();
            if (projection.isGroupingItem() || !this.conditionToMoveProjection(projection, originalSummaryQuery)) continue;
            projection.moveToQuery(environment, newSumQuery);
        }
        originalSummaryQuery.setPropertyValue("beingSplit", true);
        if (originalSummaryQuery.getRootRQPQuery().getDefaultSummaryQuery() == originalSummaryQuery) {
            newSumQuery.setCanRewriteAsWindowedAggregates(false);
        }
    }

    protected boolean conditionToMoveProjection(RQPDataItem projection, RQPSummaryQuery originalSummaryQuery) {
        return this.hasReferenceToLowerSumQuery(projection, originalSummaryQuery);
    }

    private boolean hasReferenceToLowerSumQuery(RQPDataItem projection, RQPSummaryQuery originalSummaryQuery) {
        IXQEQueryNode[] summaryAggregates;
        for (IXQEQueryNode aggregate : summaryAggregates = ExpressionAnalyzer.getSummaryFunctions(projection)) {
            if (aggregate.getNumberChildren() == 0) continue;
            List<RQPDataItemRef> diRefs = ExpressionAnalyzer.getAllReferences(aggregate.getChild(0));
            for (RQPDataItemRef diRef : diRefs) {
                RQPQuery queryReference = diRef.getQuery();
                if (queryReference.getType() != 801024 || !originalSummaryQuery.groupingColumnsAreSubsetOf((RQPSummaryQuery)queryReference)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsReferencesToTabularQueryAndLowerScopeSumQuery(RQPSummaryQuery originalSumQuery) {
        RQPProjectionList projList = originalSumQuery.getProjectionList();
        if (projList == null) {
            return false;
        }
        boolean hasReferenceToTabularQuery = false;
        boolean hasReferenceToLowerScopeSumQuery = false;
        block0: for (int i = 0; i < projList.getNumberChildren(); ++i) {
            RQPDataItem projection = (RQPDataItem)projList.getChild(i);
            if (projection.isGroupingItem()) continue;
            IXQEQueryNode[] summaryAggregates = ExpressionAnalyzer.getSummaryFunctions(projection);
            boolean projHasReferenceToTabularQuery = false;
            boolean projHasReferenceToLowerScopeSumQuery = false;
            for (IXQEQueryNode aggregate : summaryAggregates) {
                if (aggregate.getNumberChildren() == 0) continue;
                List<RQPDataItemRef> diRefs = ExpressionAnalyzer.getAllReferences(aggregate.getChild(0));
                for (RQPDataItemRef diRef : diRefs) {
                    RQPQuery queryReference = diRef.getQuery();
                    if (queryReference.getType() == 801025 && this.canNotRewriteInTermsOfLowestLevelSummary(aggregate)) {
                        projHasReferenceToTabularQuery = true;
                        hasReferenceToTabularQuery = true;
                    }
                    if (queryReference.getType() != 801024 || RQPSummaryQuery.isForReportSubquery(originalSumQuery) && RQPSummaryQuery.isForReportSubquery(queryReference) || !originalSumQuery.groupingColumnsAreSubsetOf((RQPSummaryQuery)queryReference)) continue;
                    projHasReferenceToLowerScopeSumQuery = true;
                    hasReferenceToLowerScopeSumQuery = true;
                }
                if (projHasReferenceToTabularQuery && projHasReferenceToLowerScopeSumQuery) {
                    hasReferenceToTabularQuery = false;
                    continue block0;
                }
                if (!hasReferenceToTabularQuery || !hasReferenceToLowerScopeSumQuery) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canNotRewriteInTermsOfLowestLevelSummary(IXQEQueryNode aggregate) {
        if (((V5AggregateFunction)aggregate).getDistinct()) {
            return true;
        }
        if (aggregate.getType() == 201035 || aggregate.getType() == 201033) {
            return true;
        }
        if (((V5AggregateFunction)aggregate).getSubType() == 5) {
            return true;
        }
        return ExpressionAnalyzer.getAggregateNodes(aggregate.getChild(0)).length > 0;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPSummaryQuery sumQuery = (RQPSummaryQuery)node;
        if (!sumQuery.getRootRQPQuery().isAutoSummaryTRUE()) {
            this.traceNodeCondition(false, "This query is not a grouped query", xqeTrace);
            return false;
        }
        if (!this.containsReferencesToTabularQueryAndLowerScopeSumQuery(sumQuery)) {
            this.traceNodeCondition(false, "This query does not contain references to tabular queryand to lower scope summary query", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "This summary query needs to be split to avoid double counting", xqeTrace);
        return true;
    }
}

