/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;

public class ConvertForAutoToForExplicitInPostAggrDetailFilter
extends RQPTransformation {
    public ConvertForAutoToForExplicitInPostAggrDetailFilter() {
        this.mName = "ConvertForAutoToForExplicitInPostAggrDetailFilter";
        this.mPassNumbers = new int[]{20};
        this.mTypes = new int[]{801023};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.removeProperty("detailContext");
        RQPSummaryFilterList summaryFilterList = (RQPSummaryFilterList)node;
        RQPQuery rqpQuery = summaryFilterList.getParentRQPQuery();
        RQPProjectionList projList = rqpQuery.getProjectionList();
        ArrayList<RQPDataItem> groupingItems = new ArrayList<RQPDataItem>();
        for (int i = 0; i < projList.getNumberChildren(); ++i) {
            IXQEQueryNode proj = projList.getChild(i);
            if (proj.getType() != 801008) continue;
            RQPDataItem rqpDI = (RQPDataItem)proj;
            if (rqpDI.isGroupingItem()) {
                groupingItems.add(rqpDI);
                continue;
            }
            Object o = rqpDI.getPropertyValue("detailContext");
            if (o == null) continue;
            groupingItems.add(rqpDI);
        }
        IXQEQueryNode[] filters = node.getChildrenOfType(101011);
        for (IXQEQueryNode filter : filters) {
            IXQEQueryNode[] aggrFuncs;
            Boolean filterConvertedFromDetail = (Boolean)filter.getPropertyValue("convertedFromDetail");
            if (filterConvertedFromDetail == null || !filterConvertedFromDetail.booleanValue()) continue;
            for (IXQEQueryNode aggr : aggrFuncs = filter.getDescendantsOfType(201031, false)) {
                V5ValueSummaryFunction summaryFunc = (V5ValueSummaryFunction)aggr;
                if (summaryFunc.getForClause() != null) continue;
                this.createExplicitForClause(environment, summaryFunc, groupingItems);
            }
        }
        for (RQPDataItem rqpDI : groupingItems) {
            if (rqpDI.isGroupingItem()) continue;
            rqpDI.removeProperty("detailContext");
        }
    }

    protected void createExplicitForClause(PlanningEnvironment env, V5ValueSummaryFunction summaryFunc, ArrayList<RQPDataItem> groupingItems) {
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)env.getNodeFactory().createNode(201037);
        summaryFunc.addChild(forClause);
        for (RQPDataItem rqpDI : groupingItems) {
            IXQEQueryNode expr = null;
            if (rqpDI.isGroupingItem()) {
                expr = env.getNodeFactory().deepCopyNode(rqpDI.getExpression());
            } else {
                V5DataItem v5DataItem = (V5DataItem)rqpDI.getPropertyValue("detailContext");
                expr = env.getNodeFactory().deepCopyNode(v5DataItem.getDetailContext(env));
            }
            forClause.addChild(expr);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        Object f = node.getPropertyValue("detailContext");
        if (f == null) {
            this.traceNodeCondition(false, "not required.", trace);
            return false;
        }
        this.traceNodeCondition(true, "need to convert for-auto to for-explicit in post-aggregate detail filter.", trace);
        return true;
    }
}

