/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunctionSubtype;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters.CreateRQPSubqueryForSummaryFilters;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class ConvertSummaryFiltersToDetail
extends RQPTransformation {
    public ConvertSummaryFiltersToDetail() {
        this.mName = "ConvertSummaryFiltersToDetail";
        this.mPassNumbers = new int[]{83};
        this.mTypes = new int[]{101011, 101008};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery aggrRecomputeQuery = RQPNode.getRQPQuery(node);
        IXQEQueryNode filterExpression = node.getChild(0);
        RQPQuery queryRQ0 = aggrRecomputeQuery.getSubqueryForSummaryFilters();
        this.pushAggregatesIntoSubQueryForSummaryFilter(environment, node, queryRQ0);
        List<IXQEQueryNode> rqpDataItemRefs = filterExpression.getDescendantsOfTypeOrdered(801009, false);
        for (IXQEQueryNode rqpDataItemRef : rqpDataItemRefs) {
            RQPDataItem refDI;
            RQPDataItemRef rqpDI = (RQPDataItemRef)rqpDataItemRef;
            if (rqpDI.getQueryName().equals(queryRQ0.getName()) || (refDI = rqpDI.getReferencedItem()) == null || refDI.getPropertyValue("aggrOnSharedDim") != null) continue;
            if (!ExpressionAnalyzer.exprOrRefExprHasAggregate(refDI)) {
                RQPDataItem parentDI = queryRQ0.findProjection(rqpDI.getName());
                if (parentDI != null && !queryRQ0.getName().equals(rqpDI.getQueryName())) {
                    rqpDI.setQueryName(queryRQ0.getName());
                    continue;
                }
                RQPDataItem dataItemInRQ0 = queryRQ0.getRQPDataItem(environment, (IXQEQueryNode)rqpDI, rqpDI.getName());
                RQPDataItemRef aggrRecomputeDI = RQPDataItemRef.create(environment, dataItemInRQ0);
                rqpDI.exchange(aggrRecomputeDI);
                continue;
            }
            RQPDataItem dataItemInRQ0 = null;
            dataItemInRQ0 = refDI.getParentRQPQuery() == queryRQ0 ? refDI : queryRQ0.getRQPDataItem(environment, (IXQEQueryNode)rqpDI, rqpDI.getName());
            RQPDataItemRef aggrRecomputeDI = RQPDataItemRef.create(environment, dataItemInRQ0);
            rqpDI.exchange(aggrRecomputeDI);
        }
        filterExpression.detach();
        aggrRecomputeQuery.addToDetailFilterList(environment, filterExpression);
        node.detach();
    }

    private void pushAggregatesIntoSubQueryForSummaryFilter(PlanningEnvironment environment, IXQEQueryNode filterExpression, RQPQuery subQueryForSummaryFilter) {
        List<IXQEQueryNode> topAggregates = this.getTopAggregates(filterExpression);
        for (IXQEQueryNode aggregate : topAggregates) {
            if (aggregate.getType() == 201033 && ((V5AggregateFunction)aggregate).getSubType() == 14 && this.comeFromSummaryFilterInvolvingMultiFact(aggregate, subQueryForSummaryFilter.getParentRQPQuery())) {
                ((V5AggregateFunction)aggregate).setDistinct(true);
            }
            String preferredName = V5AggregateFunctionSubtype.getName(((V5AggregateFunction)aggregate).getSubType());
            RQPDataItem proj = subQueryForSummaryFilter.getRQPDataItem(environment, aggregate, preferredName);
            RQPDataItemRef aggrRecomputeDI = RQPDataItemRef.create(environment, proj);
            aggregate.exchange(aggrRecomputeDI);
        }
    }

    private boolean comeFromSummaryFilterInvolvingMultiFact(IXQEQueryNode aggregate, RQPQuery rootQuery) {
        if (aggregate.getAncestorOfType(801023) == null) {
            return false;
        }
        return CreateRQPSubqueryForSummaryFilters.exprInvolvesMultiFacts(aggregate.getChild(0));
    }

    private List<IXQEQueryNode> getTopAggregates(IXQEQueryNode expr) {
        IXQEQueryNode[] aggregates = ExpressionAnalyzer.getAggregateNodes(expr);
        ArrayList<IXQEQueryNode> topAggs = new ArrayList<IXQEQueryNode>();
        int[] types = new int[]{201031, 201033, 201035};
        for (IXQEQueryNode agg : aggregates) {
            if (agg.getAncestorOfTypes(types) != null) continue;
            topAggs.add(agg);
        }
        return topAggs;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean postAutoAggregation;
        RQPQuery lowestLevelSummaryQuery;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        if (node.getParent().getType() != 801023) {
            this.traceNodeCondition(false, "The summary filter is not in the scope of a RQPQuery.", xqeTrace);
            return false;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        if (rqpQuery == (lowestLevelSummaryQuery = rqpQuery.getLowestLevelSummaryQuery())) {
            this.traceNodeCondition(false, "Summary filters from the lowest scope are not converted to detail.", xqeTrace);
            return false;
        }
        if (node.getType() == 101008 && !(postAutoAggregation = ((V5DetailFilter)node).getPostAutoAggregation())) {
            this.traceNodeCondition(false, "Not a Summary Filter, Detail Filter with PostAutoAggregation is false.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The summary filter will be converted to a detail filter in parent query.", xqeTrace);
        return true;
    }
}

