/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.HashSet;
import java.util.List;

public class CreateRQPSubqueryForSummaryFilters
extends RQPTransformation {
    public static final String PROP_INVOLVES_MULTIFACT = "involvesMultiFact";
    public static final String PROP_BOOL_NEED_DISTINCT_RECOMPUTE = "needDistinctRecompute";

    public CreateRQPSubqueryForSummaryFilters() {
        this.mName = "CreateRQPSubqueryForSummaryFilters";
        this.mPassNumbers = new int[]{81};
        this.mTypes = new int[]{801023};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] summaryFilterLists;
        IXQEQueryNode subqueryList;
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node).getParentRQPQuery();
        RQPQuery newRQPQuery = (RQPQuery)environment.getNodeFactory().createNode(801017);
        newRQPQuery.setIsSubqueryForSummaryFilters();
        newRQPQuery.setName(this.generateQueryName(rqpQuery));
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        if (projectionList != null) {
            projectionList.move(newRQPQuery);
        }
        if ((subqueryList = rqpQuery.getSubqueryList()) != null) {
            subqueryList.move(newRQPQuery);
        }
        newRQPQuery.setPropertyValue("underSubQueryForSF", true);
        for (IXQEQueryNode child : subqueryList.getChildren()) {
            child.setPropertyValue("underSubQueryForSF", true);
        }
        rqpQuery.addChild(environment.getNodeFactory().deepCopyNode(newRQPQuery.getSubqueryList()));
        this.setFlagToRecomputeDistinctAggregates(rqpQuery);
        for (IXQEQueryNode s : summaryFilterLists = rqpQuery.getSubqueryList().getDescendantsOfType(801023, false)) {
            s.detach();
        }
        rqpQuery.addToSubqueryList(environment, newRQPQuery, false);
        RQPQuery lowestLevelSQ = rqpQuery.getLowestLevelSummaryQueryProperty();
        if (lowestLevelSQ != null) {
            RQPQuery lowestLevelOfRQ0 = newRQPQuery.getSubquery(lowestLevelSQ.getName());
            newRQPQuery.setLowestLevelSummaryQueryProperty(lowestLevelOfRQ0);
        }
        rqpQuery.setLowestLevelSummaryQueryProperty(newRQPQuery);
        this.createRQPDataItems(rqpQuery, newRQPQuery, environment);
        newRQPQuery.addNonProjectedDataItemsFromLowestLevelSQ(environment);
        if (rqpQuery.hasChildOfType(801011)) {
            RQPDetailFilterList detailFilterList = (RQPDetailFilterList)rqpQuery.getFirstChildByType(801011);
            detailFilterList.detach();
            newRQPQuery.addChild(detailFilterList);
        }
    }

    private void setFlagToRecomputeDistinctAggregates(RQPQuery rqpQuery) {
        for (IXQEQueryNode subquery : rqpQuery.getSubqueryList().getChildren()) {
            if (!RQPUtilities.hasDistinctAggregateInProjection((RQPQuery)subquery)) continue;
            subquery.setPropertyValue(PROP_BOOL_NEED_DISTINCT_RECOMPUTE, Boolean.TRUE);
        }
    }

    private String generateQueryName(RQPQuery parentQuery) {
        StringBuilder sb = new StringBuilder("RSF");
        sb = sb.append("_");
        sb = sb.append(parentQuery.getName());
        return sb.toString();
    }

    private void createRQPDataItems(RQPQuery rqpQuery, RQPQuery subquery, PlanningEnvironment environment) {
        RQPProjectionList subqueryProjectionList = subquery.getOrCreateProjectionList(environment);
        if (rqpQuery.getProjectionList() == null) {
            RQPProjectionList newProjectionList = rqpQuery.getOrCreateProjectionList(environment);
            newProjectionList.setPropertyValue("rowSetNames", subqueryProjectionList.getPropertyValue("rowSetNames"));
            newProjectionList.setPropertyValue("columnNames", subqueryProjectionList.getPropertyValue("columnNames"));
        }
        int projectionListSize = subqueryProjectionList.getNumberChildren();
        for (int i = 0; i < projectionListSize; ++i) {
            RQPDataItem subqueryDataItem = (RQPDataItem)subqueryProjectionList.getChild(i);
            RQPDataItem newDataItem = RQPDataItem.create(environment, subqueryDataItem.getName());
            newDataItem.copyPropertiesFrom(subqueryDataItem);
            if (subqueryDataItem.getOriginalName() != null) {
                newDataItem.setOriginalName(subqueryDataItem.getOriginalName());
            }
            if (this.needToKeepExpressionInOutermostQuery(subqueryDataItem, rqpQuery)) {
                newDataItem.addChild(environment.getNodeFactory().deepCopyNode(subqueryDataItem.getExpression()));
                if (subqueryDataItem.getPropertyValue(PROP_INVOLVES_MULTIFACT) != null) {
                    newDataItem.setPropertyValue(PROP_INVOLVES_MULTIFACT, true);
                    this.updateReferencesInExpression(environment, newDataItem, rqpQuery, subquery);
                }
            } else {
                newDataItem.addChild(RQPDataItemRef.create(environment, subqueryDataItem));
            }
            rqpQuery.addToProjectionList(environment, newDataItem);
        }
    }

    private void updateReferencesInExpression(PlanningEnvironment environment, RQPDataItem newDataItem, RQPQuery rqpQuery, RQPQuery subQuery) {
        IXQEQueryNode[] forClauses;
        for (IXQEQueryNode forClause : forClauses = newDataItem.getDescendantsOfType(201037, false)) {
            for (IXQEQueryNode forClauseChild : forClause.getChildren()) {
                RQPDataItem rqpDataItem;
                if (forClauseChild.getType() != 201055 || (rqpDataItem = subQuery.getRQPDataItemWithSameExpression(forClauseChild)) == null) continue;
                RQPDataItemRef ref = RQPDataItemRef.create(environment, rqpDataItem);
                forClauseChild.exchange(ref);
            }
        }
        List<IXQEQueryNode> rqpDataItemRefs = newDataItem.getDescendantsOfTypeOrdered(801009, false);
        for (IXQEQueryNode rqpDataItemRef : rqpDataItemRefs) {
            RQPDataItemRef rqpDI = (RQPDataItemRef)rqpDataItemRef;
            if (rqpDI.getQueryName().equals(subQuery.getName())) continue;
            RQPDataItem rqpDataItem = subQuery.getRQPDataItemWithSameExpression(rqpDI);
            if (rqpDataItem == null) {
                rqpDataItem = subQuery.createRQPDataItem(environment, rqpDI.getName());
                rqpDataItem.addChild(environment.getNodeFactory().deepCopyNode(rqpDI));
            }
            rqpDI.setName(rqpDataItem.getName());
            rqpDI.setQueryName(subQuery.getName());
        }
    }

    private boolean needToKeepExpressionInOutermostQuery(RQPDataItem rqpDi, RQPQuery rootRQPQuery) {
        if (rqpDi.isFooterHeaderItem() && ExpressionAnalyzer.exprOrRefExprHasAggregate(rqpDi.getExpression()) && CreateRQPSubqueryForSummaryFilters.exprInvolvesMultiFacts(rqpDi)) {
            rqpDi.setPropertyValue(PROP_INVOLVES_MULTIFACT, true);
            return true;
        }
        return ExpressionAnalyzer.exprOrRefExprHasAggregate(rqpDi.getExpression()) && !ExpressionAnalyzer.refQueryIsFactQuery(rqpDi.getExpression());
    }

    public static boolean exprInvolvesMultiFacts(IXQEQueryNode expression) {
        HashSet<String> factQueries = new HashSet<String>();
        ExpressionAnalyzer.getRefItemsReferringFactQuery(expression, factQueries);
        return factQueries.size() > 1;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        if (node.getNumberChildren() > 0) {
            this.traceNodeCondition(true, "A RQPQuery will be created to compute aggregates before applying the summary filter.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "The RQPSummaryFilterList is empty.", xqeTrace);
        return false;
    }
}

