/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters.PushSummaryFilterContainingDetailValueToTabularQuery;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;

public class PushPrefilteredAggsToSubqueryForSummaryFilters
extends RQPTransformation {
    public PushPrefilteredAggsToSubqueryForSummaryFilters() {
        this.mName = "PushPrefilteredAggsToSubqueryForSummaryFilters";
        this.mPassNumbers = new int[]{84};
        this.mTypes = new int[]{801008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery summaryQuery = RQPNode.getRQPQuery(node);
        RQPQuery rqpSubquery = summaryQuery.getParentRQPQuery();
        RQPQuery parentRQPQuery = (RQPQuery)rqpSubquery.getAncestorOfType(801017);
        if (summaryQuery.isSummarizedQuery()) {
            IXQEQueryNode[] refsToRQ;
            RQPDataItem inRQPDataItem = (RQPDataItem)node;
            for (IXQEQueryNode r : refsToRQ = parentRQPQuery.getProjectionList().getDescendantsOfType(801009, false)) {
                IXQEQueryNode[] ref = (IXQEQueryNode[])r;
                if (!ref.isReferenceTo(inRQPDataItem)) continue;
                this.createReferenceInRQ0Subquery(environment, rqpSubquery, (RQPDataItemRef)ref);
            }
            IXQEQueryNode subqueryList = parentRQPQuery.getSubqueryList();
            for (int i = 0; i < subqueryList.getNumberChildren(); ++i) {
                IXQEQueryNode[] moreRefsToRQ;
                RQPQuery subquery = (RQPQuery)subqueryList.getChild(i);
                if (subquery.getProjectionList() == null || !subquery.isSummarizedQuery() || subquery == summaryQuery) continue;
                for (IXQEQueryNode r : moreRefsToRQ = subquery.getProjectionList().getDescendantsOfType(801009, false)) {
                    RQPDataItemRef ref = (RQPDataItemRef)r;
                    if (!ref.isReferenceTo(inRQPDataItem)) continue;
                    this.createReferenceInRQ0Subquery(environment, rqpSubquery, ref);
                }
            }
        } else {
            RQPDataItem inRQPDataItem = (RQPDataItem)node;
            RQPDataItem rqpDataItemInOuterQuery = parentRQPQuery.findProjection(inRQPDataItem.getName());
            IXQEQueryNode[] aggregatesInRQ0 = ExpressionAnalyzer.getAggregateNodes(inRQPDataItem);
            IXQEQueryNode[] aggregatesInOuterQuery = ExpressionAnalyzer.getAggregateNodes(rqpDataItemInOuterQuery);
            for (int i = 0; i < aggregatesInRQ0.length; ++i) {
                RQPDataItemRef refToDataItemInSubquery;
                RQPDataItem dataItemInSubquery;
                V5AggregateFunction aggregate = (V5AggregateFunction)aggregatesInRQ0[i];
                if (!aggregate.getPrefilter()) continue;
                if (!RQPUtilities.containsAnalyticOrMovingRunningOnDetailExpr(aggregate)) {
                    dataItemInSubquery = rqpSubquery.getRQPDataItem(environment, (IXQEQueryNode)aggregate, inRQPDataItem.getName());
                    refToDataItemInSubquery = RQPDataItemRef.create(environment, dataItemInSubquery);
                    aggregatesInOuterQuery[i].exchange(refToDataItemInSubquery);
                    continue;
                }
                if (RQPNode.getRQPQuery(aggregate) == rqpSubquery.getDefaultTabularQuery()) continue;
                dataItemInSubquery = rqpSubquery.getRQPDataItem(environment, (IXQEQueryNode)aggregate, inRQPDataItem.getName());
                refToDataItemInSubquery = RQPDataItemRef.create(environment, dataItemInSubquery);
                PushSummaryFilterContainingDetailValueToTabularQuery.pushAggregateToTabularQuery(node, environment, rqpSubquery, rqpSubquery.getDefaultTabularQuery(), false, aggregate);
                aggregatesInOuterQuery[i].exchange(refToDataItemInSubquery);
            }
        }
    }

    private void createReferenceInRQ0Subquery(PlanningEnvironment environment, RQPQuery rqpSubquery, RQPDataItemRef ref) {
        RQPDataItem dataItemInSubquery = rqpSubquery.getRQPDataItem(environment, (IXQEQueryNode)ref, ref.getName());
        RQPDataItemRef refToDataItemInSubquery = RQPDataItemRef.create(environment, dataItemInSubquery);
        ref.exchange(refToDataItemInSubquery);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery summaryQuery = RQPNode.getRQPQuery(node);
        if (summaryQuery.isTabularQuery()) {
            this.traceNodeCondition(false, "Prefiltered aggregate already pushed to tabular query.", xqeTrace);
            return false;
        }
        RQPQuery rqpQuery = summaryQuery.getParentRQPQuery();
        if (!rqpQuery.isSubqueryForSummaryFilters()) {
            this.traceNodeCondition(false, "Only RQPDataItem in subquery for summary filters are considered.", xqeTrace);
            return false;
        }
        if (!this.queryContainsSummaryFilters(summaryQuery.getRootRQPQuery())) {
            this.traceNodeCondition(false, "The are no summary filters.", xqeTrace);
            return false;
        }
        if (!this.projectionContainsPrefilteredAggregate(node)) {
            this.traceNodeCondition(false, "There are no pre-filtered aggregates.", xqeTrace);
            return false;
        }
        if (summaryQuery.isSummarizedQuery() && !this.parentRQPQueryContainsReferenceTo(rqpQuery, (RQPDataItem)node)) {
            return this.subqueryInParentRQPQueryContainsReferenceTo(rqpQuery, summaryQuery, (RQPDataItem)node);
        }
        return true;
    }

    private boolean projectionContainsPrefilteredAggregate(IXQEQueryNode node) {
        IXQEQueryNode[] aggregates;
        for (IXQEQueryNode a : aggregates = ExpressionAnalyzer.getAggregateNodes(node)) {
            V5AggregateFunction aggregate = (V5AggregateFunction)a;
            if (!aggregate.getPrefilter()) continue;
            return true;
        }
        return false;
    }

    private boolean parentRQPQueryContainsReferenceTo(RQPQuery rqpQuery, RQPDataItem rqpDataItem) {
        IXQEQueryNode[] refsToRQ;
        RQPQuery parentRQPQuery = (RQPQuery)rqpQuery.getAncestorOfType(801017);
        for (IXQEQueryNode r : refsToRQ = parentRQPQuery.getProjectionList().getDescendantsOfType(801009, false)) {
            RQPDataItemRef ref = (RQPDataItemRef)r;
            if (!ref.isReferenceTo(rqpDataItem)) continue;
            return true;
        }
        return false;
    }

    private boolean queryContainsSummaryFilters(RQPQuery rootRQPQuery) {
        IXQEQueryNode[] summaryFilterLists = rootRQPQuery.getDescendantsOfType(801023, false);
        return summaryFilterLists != null && summaryFilterLists.length > 0;
    }

    private boolean subqueryInParentRQPQueryContainsReferenceTo(RQPQuery rqpQuery, RQPQuery summaryQuery, RQPDataItem rqpDataItem) {
        RQPQuery parentRQPQuery = (RQPQuery)rqpQuery.getAncestorOfType(801017);
        IXQEQueryNode subqueryList = parentRQPQuery.getSubqueryList();
        for (int i = 0; i < subqueryList.getNumberChildren(); ++i) {
            IXQEQueryNode[] refsToRQ;
            RQPProjectionList projectionList;
            RQPQuery subquery = (RQPQuery)subqueryList.getChild(i);
            if (!subquery.isSummarizedQuery() || subquery == summaryQuery || (projectionList = subquery.getProjectionList()) == null) continue;
            for (IXQEQueryNode r : refsToRQ = projectionList.getDescendantsOfType(801009, false)) {
                RQPDataItemRef ref = (RQPDataItemRef)r;
                if (!ref.isReferenceTo(rqpDataItem)) continue;
                return true;
            }
        }
        return false;
    }
}

