/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5SummaryFilterLevel;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeAggregatesInAppropriateSubQueries;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ProcessDataItemRefInValueSet;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class PushSummaryFilterContainingDetailValueToTabularQuery
extends RQPTransformation {
    public PushSummaryFilterContainingDetailValueToTabularQuery() {
        this.mName = "PushSummaryFilterContainingDetailValueToTabularQuery";
        this.mPassNumbers = new int[]{50};
        this.mTypes = new int[]{101011};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] aggregates = ExpressionAnalyzer.getAggregateNodes(node);
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        RQPTabularQuery tabularQuery = rqpQuery.getParentRQPQuery().getDefaultTabularQuery();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        boolean bFilterContainsDistinctAggregate = this.filterContainsDistinctAggregate(node);
        for (IXQEQueryNode aggregate : aggregates) {
            PushSummaryFilterContainingDetailValueToTabularQuery.pushAggregateToTabularQuery(node, environment, rqpQuery, tabularQuery, bFilterContainsDistinctAggregate, aggregate);
        }
        List<IXQEQueryNode> prefilterAggregates = this.getPrefilterAggregatesOnDetails(rqpQuery.getProjectionList());
        for (IXQEQueryNode pAggregate : prefilterAggregates) {
            PushSummaryFilterContainingDetailValueToTabularQuery.pushAggregateToTabularQuery(node, environment, rqpQuery, tabularQuery, false, pAggregate);
        }
        List<V5BoundMultiPartIdentifier> detailValues = this.collectDetailExpr(node);
        for (V5BoundMultiPartIdentifier detailValue : detailValues) {
            RQPTabularQuery.pushDetailExpressionsToTabularQuery(detailValue, environment);
        }
        this.moveSummaryFilterToTabularQueryProperty(node, nodeFactory, tabularQuery);
        tabularQuery.setPropertyValue("canNotBeCollapsed", true);
    }

    public static void pushAggregateToTabularQuery(IXQEQueryNode node, PlanningEnvironment environment, RQPQuery rqpQuery, RQPTabularQuery tabularQuery, boolean bFilterContainsDistinctAggregate, IXQEQueryNode aggregate) {
        if (bFilterContainsDistinctAggregate) {
            ((V5AggregateFunction)aggregate).setAvoidRewritingDistinctAggregate();
        }
        if (aggregate.getAncestorOfType(801025) == null) {
            DistributeAggregatesInAppropriateSubQueries.addAggregateToSubqueryAndCreateReferenceToIt(node, tabularQuery, (V5AggregateFunction)aggregate, environment);
        }
        PushSummaryFilterContainingDetailValueToTabularQuery.addForClauseToAggregate(environment, node, (V5AggregateFunction)aggregate, rqpQuery);
    }

    private List<IXQEQueryNode> getPrefilterAggregatesOnDetails(RQPProjectionList projectionList) {
        ArrayList<IXQEQueryNode> list = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            IXQEQueryNode[] aggregates;
            IXQEQueryNode proj = projectionList.getChild(i);
            for (IXQEQueryNode a : aggregates = ExpressionAnalyzer.getAggregateNodes(proj)) {
                V5AggregateFunction aggregate = (V5AggregateFunction)a;
                if (!aggregate.getPrefilter() || !RQPUtilities.containsAnalyticOrMovingRunningOnDetailExpr(aggregate)) continue;
                list.add(aggregate);
            }
        }
        return list;
    }

    private void moveSummaryFilterToTabularQueryProperty(IXQEQueryNode summaryFilterExpression, XQENodeFactory nodeFactory, RQPTabularQuery tabularQuery) {
        summaryFilterExpression.detach();
        RQPSummaryFilterList summaryFilterList = null;
        Object propertyValue = tabularQuery.getPropertyValue("summaryFilterListToBeConvertedToDetailFilter");
        if (propertyValue == null) {
            summaryFilterList = (RQPSummaryFilterList)nodeFactory.createNode(801023);
            summaryFilterList.addChild(summaryFilterExpression);
            tabularQuery.setPropertyValue("summaryFilterListToBeConvertedToDetailFilter", summaryFilterList);
        } else {
            summaryFilterList = (RQPSummaryFilterList)propertyValue;
            summaryFilterList.addChild(summaryFilterExpression);
        }
    }

    private static void addForClauseToAggregate(PlanningEnvironment environment, IXQEQueryNode v5SummaryFilter, V5AggregateFunction aggregate, RQPQuery rqpQuery) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (aggregate.getForClause() != null) {
            if (PushSummaryFilterContainingDetailValueToTabularQuery.canBeSimplified(aggregate)) {
                aggregate.extract();
            }
            return;
        }
        if (aggregate.getType() != 201031) {
            PushSummaryFilterContainingDetailValueToTabularQuery.addForReportScope(nodeFactory, aggregate);
            return;
        }
        if (ExpressionAnalyzer.hasAggregateAncestor(aggregate) && !ExpressionAnalyzer.hasAnalyticAggregateAncestor(aggregate)) {
            if (PushSummaryFilterContainingDetailValueToTabularQuery.canBeSimplified(aggregate)) {
                aggregate.extract();
            } else {
                PushSummaryFilterContainingDetailValueToTabularQuery.addDefaultSummaryScope(nodeFactory, rqpQuery, aggregate);
            }
            return;
        }
        RQPSummaryFilterList.AggregateScope aggScope = DistributeAggregatesInAppropriateSubQueries.determineScopeOfAggregateInFilterExpression(v5SummaryFilter, aggregate, environment, aggregate);
        switch (aggScope) {
            case summaryFilterLevelScope: {
                V5SummaryFilterLevel summaryFilterLevel = (V5SummaryFilterLevel)v5SummaryFilter.getFirstChildByType(101012);
                PushSummaryFilterContainingDetailValueToTabularQuery.addContextLevelScope(nodeFactory, rqpQuery, summaryFilterLevel.getRefDataItem(), aggregate, v5SummaryFilter);
                break;
            }
            case contextLevelScope: {
                String contextLevel = (String)aggregate.getPropertyValue("contextLevel");
                PushSummaryFilterContainingDetailValueToTabularQuery.addContextLevelScope(nodeFactory, rqpQuery, contextLevel, aggregate, v5SummaryFilter);
                break;
            }
            case defaultSummaryScope: {
                PushSummaryFilterContainingDetailValueToTabularQuery.addDefaultSummaryScope(nodeFactory, rqpQuery, aggregate);
                break;
            }
            case forReportScope: {
                PushSummaryFilterContainingDetailValueToTabularQuery.addForReportScope(nodeFactory, aggregate);
            }
            default: {
                return;
            }
        }
    }

    private static boolean canBeSimplified(V5AggregateFunction aggregate) {
        if (aggregate.getType() != 201031) {
            return false;
        }
        IXQEQueryNode[] aggregateAncestors = aggregate.getAncestorsOfTypes(new int[]{201033, 201035, 201031});
        if (aggregateAncestors.length == 0 || aggregateAncestors[0].getType() != 201031) {
            return false;
        }
        V5AggregateFunction outerAggregate = (V5AggregateFunction)aggregateAncestors[0];
        if (aggregate.getSubType() != outerAggregate.getSubType()) {
            return false;
        }
        if (outerAggregate != aggregate.getParent()) {
            return false;
        }
        if (outerAggregate.getForClause().getNumberChildren() == 0) {
            return true;
        }
        return PushSummaryFilterContainingDetailValueToTabularQuery.nestedAggregateGroupingItemsSameOrHigherScope(outerAggregate, aggregate);
    }

    private static void addDefaultSummaryScope(XQENodeFactory nodeFactory, RQPQuery rqpQuery, V5AggregateFunction aggregate) {
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
        List<RQPDataItem> groupingItems = rqpQuery.getProjectionsMarkedAsGroupingColumns();
        for (RQPDataItem dI : groupingItems) {
            V5DataItem v5DataItem = RQPUtilities.getV5DataItemInSelection(dI, dI.getName());
            forClause.addChild(nodeFactory.deepCopyNode(v5DataItem.getDetailExpression()));
        }
        aggregate.addChild(forClause);
    }

    private static void addContextLevelScope(XQENodeFactory nodeFactory, RQPQuery rqpQuery, String refDataItem, V5AggregateFunction aggregate, IXQEQueryNode v5SummaryFilter) {
        V5ValueSet valueSet = RQPSummaryQuery.getValueSetOfRefDataItem(refDataItem, rqpQuery, v5SummaryFilter);
        List<V5DataItem> groupingItems = ProcessDataItemRefInValueSet.getGroupingItems(valueSet, rqpQuery.getRootRQPQuery(), false);
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
        for (V5DataItem dI : groupingItems) {
            forClause.addChild(nodeFactory.deepCopyNode(dI.getDetailExpression()));
        }
        aggregate.addChild(forClause);
    }

    private static void addForReportScope(XQENodeFactory nodeFactory, V5AggregateFunction aggregate) {
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
        aggregate.addChild(forClause);
    }

    public static boolean nestedAggregateGroupingItemsSameOrHigherScope(V5AggregateFunction outerAggregate, V5AggregateFunction nestedAggregate) {
        IXQEQueryNode[] nestedGroupingItems = ExpressionAnalyzer.getAggregateScope(nestedAggregate);
        IXQEQueryNode[] outerGroupingItems = ExpressionAnalyzer.getAggregateScope(outerAggregate);
        return RQPSummaryQuery.groupingItemsAreSubsetOf(nestedGroupingItems, outerGroupingItems);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (node.getParent().getType() != 801023) {
            this.traceNodeCondition(false, "The summary filter is not in the scope of a RQPQuery.", xqeTrace);
            return false;
        }
        if (RQPUtilities.containsAnalyticOrMovingRunningOnDetailExpr(node) || RQPUtilities.containsDetailExpr(node)) {
            this.traceNodeCondition(true, "The summary filter contains detail value and needs to be pushedto the tabular query.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "The summary filter doesn't contain detail value.", xqeTrace);
        return false;
    }

    private boolean filterContainsDistinctAggregate(IXQEQueryNode node) {
        IXQEQueryNode[] aggNodes;
        for (IXQEQueryNode aggNode : aggNodes = node.getDescendantsOfType(201031, false)) {
            V5AggregateFunction aggregate = (V5AggregateFunction)aggNode;
            if (!aggregate.getDistinct()) continue;
            return true;
        }
        return false;
    }

    private List<V5BoundMultiPartIdentifier> collectDetailExpr(IXQEQueryNode expression) {
        List<IXQEQueryNode> allV5BoundMI = expression.getDescendantsOfCategory(201115, false);
        ArrayList<V5BoundMultiPartIdentifier> detailValues = new ArrayList<V5BoundMultiPartIdentifier>();
        for (IXQEQueryNode b : allV5BoundMI) {
            V5BoundMultiPartIdentifier modelId;
            if (b.getType() == 201127 || b.getType() == 201060 && b.getParent().getType() == 201011 && b.getParent().getChild(1) == b || RQPUtilities.isIdentifierInAggregateFunction(modelId = (V5BoundMultiPartIdentifier)b)) continue;
            detailValues.add(modelId);
        }
        return detailValues;
    }
}

