/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ApplyRollupAggregate;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class ResolveDataItemReferenceInSummaryFilter
extends RQPTransformation {
    public ResolveDataItemReferenceInSummaryFilter() {
        this.mName = "ResolveDataItemReference for Summary Filter.";
        this.mPassNumbers = new int[]{19};
        this.mTypes = new int[]{101011};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] dataItemRefUnderFilter = node.getDescendantsOfType(101003, false);
        for (int j = 0; j < dataItemRefUnderFilter.length; ++j) {
            V5DataItem v5DataItem = (V5DataItem)dataItemRefUnderFilter[j];
            IXQEQueryNode expression = this.getAggregateExpressionFromV5DataItem(v5DataItem, node, environment);
            v5DataItem.exchange(expression);
        }
        if (!RQPUtilities.hasAggregateInExpression(node)) {
            this.convertSummaryFilterToDetailFilter(environment, (V5SummaryFilter)node);
        }
    }

    private void convertSummaryFilterToDetailFilter(PlanningEnvironment environment, V5SummaryFilter node) {
        V5DetailFilter v5DetailFilter = (V5DetailFilter)environment.getNodeFactory().createNode(101008);
        IXQEQueryNode summaryFilterExpression = node.getChild(0);
        summaryFilterExpression.detach();
        v5DetailFilter.addChild(summaryFilterExpression);
        v5DetailFilter.setOriginalExpression(node.getOriginalExpression());
        RQPSummaryFilterList summaryFilterList = (RQPSummaryFilterList)node.getParent();
        summaryFilterList.getRootRQPQuery().addToDetailFilterList(environment, v5DetailFilter);
        node.detach();
        if (summaryFilterList.getNumberChildren() == 0) {
            summaryFilterList.detach();
        }
    }

    private IXQEQueryNode getAggregateExpressionFromV5DataItem(V5DataItem v5DataItem, IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode retAggregateExpression = null;
        RQPSummaryFilterList sfList = (RQPSummaryFilterList)node.getParent();
        boolean autoSummary = this.getAutoSummary(sfList);
        boolean isUnderSummaryFunction = this.isUnderSummaryFunction(v5DataItem);
        boolean applyDefaultSummaryScope = false;
        boolean needToDetermineAggregateScope = false;
        if (this.isUnderFOROrATClause(v5DataItem)) {
            retAggregateExpression = v5DataItem.getDetailContext(environment);
        } else if (this.canUseRollupExpression(v5DataItem, node)) {
            if (isUnderSummaryFunction) {
                if (autoSummary) {
                    retAggregateExpression = v5DataItem.getAggregateExpression(environment);
                    applyDefaultSummaryScope = true;
                } else {
                    retAggregateExpression = v5DataItem.getDetailContext(environment);
                }
            } else {
                retAggregateExpression = this.getRollupExpression(v5DataItem, node, environment);
            }
        } else if (isUnderSummaryFunction) {
            if (!v5DataItem.getIsProjected() || this.isConvertedFromDetail(node)) {
                retAggregateExpression = v5DataItem.getDetailContext(environment);
            } else {
                retAggregateExpression = v5DataItem.getAggregateExpression(environment);
                applyDefaultSummaryScope = true;
            }
        } else {
            boolean rollupNone = v5DataItem.getRollupAggregateProperty().equals("none");
            retAggregateExpression = !autoSummary && rollupNone ? v5DataItem.getDetailContext(environment) : (this.isConvertedFromDetail(node) && (!autoSummary || !((V5SummaryFilter)node).getPostAutoAggregation()) ? v5DataItem.getDetailContext(environment) : (v5DataItem.getIsProjected() && !this.isConvertedFromDetail(node) && v5DataItem.getAggregateProperty().equals("none") && rollupNone ? v5DataItem.getDetailContext(environment) : v5DataItem.getAggregateExpression(environment)));
            needToDetermineAggregateScope = true;
        }
        IXQEQueryNode newNode = environment.getNodeFactory().deepCopyNode(retAggregateExpression);
        if (applyDefaultSummaryScope) {
            this.setDefaultSummaryScope(newNode);
        }
        if (needToDetermineAggregateScope) {
            this.determineAggregateScope(v5DataItem, node, newNode);
        }
        return newNode;
    }

    private boolean getAutoSummary(RQPSummaryFilterList sfList) {
        RQPQuery rqpQuery = RQPNode.getRQPQuery(sfList);
        Boolean origAutoSummary = rqpQuery.getBooleanPropertyValue("originalAutoSummary");
        boolean autoSummary = true;
        autoSummary = origAutoSummary != null ? origAutoSummary.booleanValue() : rqpQuery.isAutoSummaryTRUE();
        return autoSummary;
    }

    private boolean isUnderFOROrATClause(V5DataItem dataItemReference) {
        IXQEQueryNode parentNode = dataItemReference.getParent();
        if (parentNode != null) {
            int parentNodeType = parentNode.getType();
            return parentNodeType == 201037 || parentNodeType == 201036;
        }
        return false;
    }

    private String findContextLevel(IXQEQueryNode v5DataItem, RQPQuery rootQuery) {
        String v5DIName = ((V5DataItem)v5DataItem).getNameProperty();
        List<IXQEQueryNode> valueSets = rootQuery.getDescendantsOfTypeOrdered(101057, false);
        for (IXQEQueryNode valueSet : valueSets) {
            String refDataItem = ((V5ValueSet)valueSet).getRefDataItemProperty();
            if (refDataItem == null) continue;
            if (v5DIName.equals(refDataItem)) {
                return refDataItem;
            }
            IXQEQueryNode[] groupBody = valueSet.getChildrenOfType(101051);
            if (groupBody.length == 0 || !this.findDataItemRef(v5DIName, groupBody[0].getChildren())) continue;
            return refDataItem;
        }
        return null;
    }

    private boolean findDataItemRef(String name, IXQEQueryNode[] dataItemRefs) {
        for (IXQEQueryNode dataItemRef : dataItemRefs) {
            String diName = ((V5DataItemRef)dataItemRef).getDataItemRefProperty();
            if (!name.equals(diName)) continue;
            return true;
        }
        return false;
    }

    private void setContextLevelOnSummaryFunctions(String contextLevel, IXQEQueryNode expression) {
        IXQEQueryNode[] summaryFunctions;
        for (IXQEQueryNode sf : summaryFunctions = ExpressionAnalyzer.getSummaryFunctions(expression)) {
            V5AggregateFunction summaryFunc;
            if (sf.getAncestorOfType(201031) != null || (summaryFunc = (V5AggregateFunction)sf).getForClause() != null || summaryFunc.getPropertyValue("applyDefaultSummaryScope") != null) continue;
            summaryFunc.setPropertyValue("contextLevel", contextLevel);
        }
    }

    private void setDefaultSummaryScope(IXQEQueryNode expression) {
        IXQEQueryNode[] summaryFunctions;
        for (IXQEQueryNode sf : summaryFunctions = ExpressionAnalyzer.getSummaryFunctions(expression)) {
            V5AggregateFunction summaryFunc = (V5AggregateFunction)sf;
            if (summaryFunc.getForClause() != null) continue;
            summaryFunc.setPropertyValue("applyDefaultSummaryScope", true);
        }
    }

    private void determineAggregateScope(V5DataItem v5DataItem, IXQEQueryNode summaryFilterNode, IXQEQueryNode unwoundExpr) {
        if (v5DataItem.getIsProjected()) {
            if (v5DataItem.getAggregateProperty().equals("none") || v5DataItem.getRollupAggregateProperty().equals("none")) {
                this.setDefaultSummaryScope(unwoundExpr);
                return;
            }
            RQPQuery rootQuery = RQPNode.getRQPQuery(summaryFilterNode).getParentRQPQuery();
            String contextLevel = this.findContextLevel(v5DataItem, rootQuery);
            if (contextLevel != null && (v5DataItem.getRollupAggregateProperty().equals("automatic") || v5DataItem.getRollupAggregateProperty().equals("calculated"))) {
                this.setContextLevelOnSummaryFunctions(contextLevel, unwoundExpr);
            }
        }
    }

    private boolean canUseRollupExpression(V5DataItem v5DataItem, IXQEQueryNode node) {
        if (this.isConvertedFromDetail(node)) {
            return false;
        }
        if (!v5DataItem.getIsProjected()) {
            return false;
        }
        return V5AggregateEnum.isStandardAggregate(v5DataItem.getRollupAggregateProperty());
    }

    private boolean isConvertedFromDetail(IXQEQueryNode node) {
        return node.getPropertyValue("convertedFromDetail") == Boolean.TRUE;
    }

    private boolean isUnderSummaryFunction(V5DataItem v5DataItem) {
        IXQEQueryNode[] aggregateAncestors = v5DataItem.getAncestorsOfTypes(new int[]{201033, 201035, 201031});
        return aggregateAncestors.length > 0 && aggregateAncestors[0].getType() == 201031;
    }

    private IXQEQueryNode getRollupExpression(V5DataItem v5DataItem, IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode rollupExpression = v5DataItem.getRollupExpression();
        if (rollupExpression == null) {
            RQPQuery rootQuery = RQPNode.getRQPQuery(node).getParentRQPQuery();
            String rollupAggregate = v5DataItem.getRollupAggregateProperty();
            rollupExpression = ApplyRollupAggregate.generateRollupAggrExpr(environment, rootQuery, v5DataItem, rollupAggregate, null);
        }
        return rollupExpression;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (!node.hasDescendantOfType(101003, false)) {
            this.traceNodeCondition(false, "The SummaryFilter has been resolved", trace);
            return false;
        }
        return true;
    }
}

