/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.AggregateExpressionBuilder;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class ResolveDetailExpressionInSummaryFilter
extends RQPTransformation {
    public ResolveDetailExpressionInSummaryFilter() {
        this.mName = "ResolveNonAggregatePostAggregationDetailFilter.";
        this.mPassNumbers = new int[]{19};
        this.mTypes = new int[]{101011};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IXQEQueryNode> allV5BoundMI = node.getDescendantsOfTypeOrdered(201116, false);
        for (IXQEQueryNode b : allV5BoundMI) {
            V5BoundModelIdentifier modelId = (V5BoundModelIdentifier)b;
            if (RQPUtilities.isIdentifierInAggregateFunction(modelId)) continue;
            AggregateExpressionBuilder aggregateExprBuilder = new AggregateExpressionBuilder(environment);
            IXQEQueryNode aggregateExpr = aggregateExprBuilder.generateAggregateExpression("automatic", modelId);
            modelId.exchange(aggregateExpr);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] allDetailExpNodes;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        Boolean filterConvertedFromDetail = (Boolean)node.getPropertyValue("convertedFromDetail");
        if (filterConvertedFromDetail == null || !filterConvertedFromDetail.booleanValue()) {
            this.traceNodeCondition(false, "Not a Summary Filter that get converted from a Detail Filter.", xqeTrace);
            return false;
        }
        RQPQuery rqpQuery = (RQPQuery)node.getAncestorOfType(801017);
        if (!rqpQuery.getRootRQPQuery().isAutoSummaryTRUE()) {
            this.traceNodeCondition(false, "Summary Filter with autoSummary=false", xqeTrace);
            return false;
        }
        if (!((V5SummaryFilter)node).getPostAutoAggregation()) {
            return false;
        }
        for (IXQEQueryNode b : allDetailExpNodes = RQPUtilities.getDetailExprNodes(node)) {
            if (b.getType() != 201116 || RQPUtilities.isIdentifierInAggregateFunction(b) || RQPUtilities.isIdentifierUnderBreakClause(b)) continue;
            return true;
        }
        return false;
    }
}

