/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.optimization.RewriteAggregateInTermsOfLowestScope;

public class UpdateReferencesToLowestLevelSQ
extends RQPTransformation {
    public UpdateReferencesToLowestLevelSQ() {
        this.mName = "UpdateReferencesToLowestLevelSQ";
        this.mPassNumbers = new int[]{85};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int[] listsToCheck;
        RQPQuery subquery = (RQPQuery)node;
        RQPQuery lowestLevelSQ = subquery.getLowestLevelSummaryQuery();
        RQPQuery parentRQPQuery = (RQPQuery)subquery.getAncestorOfType(801017);
        boolean autoSummary = parentRQPQuery.getRootRQPQuery().isAutoSummaryTRUE();
        RQPQuery rootRQPQuery = parentRQPQuery.getRootRQPQuery();
        for (int listType : listsToCheck = new int[]{801016, 801022}) {
            IXQEQueryNode list = parentRQPQuery.getFirstChildByType(listType);
            if (list == null) continue;
            for (int i = 0; i < list.getNumberChildren(); ++i) {
                IXQEQueryNode[] refsToSubqueries;
                IXQEQueryNode childNode = list.getChild(i);
                if (listType == 801022 && (childNode == subquery || ((RQPQuery)childNode).isFactQuery())) continue;
                for (IXQEQueryNode r : refsToSubqueries = childNode.getDescendantsOfType(801009, false)) {
                    RQPDataItemRef ref = (RQPDataItemRef)r;
                    if (autoSummary) {
                        if (!ref.getQueryName().equals(lowestLevelSQ.getName())) continue;
                        this.replaceOuterProjsWithReferencesToRQ0(subquery, ref, environment);
                        continue;
                    }
                    if (parentRQPQuery != rootRQPQuery) {
                        if (!ref.getQueryName().equals(lowestLevelSQ.getName())) continue;
                        this.replaceOuterProjsWithReferencesToRQ0(subquery, ref, environment);
                        continue;
                    }
                    RQPDataItem rqpDI = ref.getNextReferencedItem();
                    RQPQuery rqpQueryOfDI = RQPNode.getRQPQuery(rqpDI);
                    if (rqpQueryOfDI.getType() != 801025 || rqpQueryOfDI.getParent() != subquery.getParent()) continue;
                    this.replaceOuterProjsWithReferencesToRQ0(subquery, ref, environment);
                }
            }
        }
        if (autoSummary || parentRQPQuery != rootRQPQuery || !RewriteAggregateInTermsOfLowestScope.isReferencedInParentRQPQuery(lowestLevelSQ)) {
            parentRQPQuery.getSubquery(lowestLevelSQ.getName()).detach();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        if (!rqpQuery.isSubqueryForSummaryFilters()) {
            this.traceNodeCondition(true, "Subquery is not the subQuery for summary filter.", xqeTrace);
            return false;
        }
        RQPQuery lowestLevelSQ = rqpQuery.getLowestLevelSummaryQuery();
        if (lowestLevelSQ == null) {
            this.traceNodeCondition(false, "SubQuery doesn't have lowest level summary query.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "Subqueries will  be copied to the outer query.", xqeTrace);
        return true;
    }

    private void replaceOuterProjsWithReferencesToRQ0(RQPQuery subquery, RQPDataItemRef diRef, PlanningEnvironment environment) {
        RQPDataItem rqpDI = diRef.getNextReferencedItem();
        RQPQuery rqpQueryOfDI = RQPNode.getRQPQuery(rqpDI);
        RQPDataItem rqpDataItem = rqpQueryOfDI.getRQPDataItem(environment, rqpDI.getExpression(), rqpDI.getName());
        RQPDataItemRef diRef2 = RQPDataItemRef.create(environment, rqpDataItem);
        rqpDataItem = subquery.getRQPDataItem(environment, (IXQEQueryNode)diRef2, diRef.getName());
        diRef.exchange(RQPDataItemRef.create(environment, rqpDataItem));
    }
}

