/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPTNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.MoserRelationship;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnwindModuleJoinsReferencingPackages
extends RQPTransformation {
    private static final String DYNAMIC_SQS_JOIN = "dynamicSQSJoin_";
    private static final String MODULE_JOINS_UNWOUND = "moduleJoinsUnwound";
    public static final String PROP_MINIQS_MAP = "minimizedQSMap";

    public UnwindModuleJoinsReferencingPackages(int[] passNumbers) {
        this.mName = "Unwind joins that reference packages to avoid cross-join error";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{101006};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query = (V5Query)node;
        Boolean testingJoins = v5Query.getBooleanPropertyValue("queryForTestJoin");
        if (testingJoins != null && testingJoins.booleanValue()) {
            return false;
        }
        Boolean unwound = v5Query.getBooleanPropertyValue(MODULE_JOINS_UNWOUND);
        if (unwound != null && unwound.booleanValue()) {
            return false;
        }
        MetadataConnection md = v5Query.getMetadataConnectionMetadataPath(environment);
        if (!(md instanceof MoserMetadataConnection)) {
            return false;
        }
        List<IMetadata> joins = this.getModuleJoinsToPackage(environment);
        if (joins == null || joins.isEmpty()) {
            return false;
        }
        return this.needsUnwinding(environment, joins);
    }

    private boolean needsUnwinding(PlanningEnvironment environment, List<IMetadata> joins) {
        MoserMetadataConnection mdMoser = (MoserMetadataConnection)environment.getMetadataConnection();
        for (IMetadata j : joins) {
            MoserRelationship r;
            if (!(j instanceof MoserRelationship) || !UnwindModuleJoinsReferencingPackages.isFromPackage(mdMoser, (r = (MoserRelationship)j).getLeftRefObject()) && !UnwindModuleJoinsReferencingPackages.isFromPackage(mdMoser, r.getRightRefObject()) || r.getIsUnwound()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query = (V5Query)node;
        ArrayList<IMetadata> joinsInModule = new ArrayList<IMetadata>(this.getModuleJoinsToPackage(environment));
        this.remapRelationshipsToUnwoundQS(environment, v5Query, joinsInModule);
        v5Query.setBooleanPropertyValue(MODULE_JOINS_UNWOUND, "true");
    }

    private List<IMetadata> getModuleJoinsToPackage(PlanningEnvironment environment) {
        MoserMetadataConnection mdMoser = (MoserMetadataConnection)environment.getMetadataConnection();
        List<IMetadata> joinsInModule = CollectionCast.upcast(mdMoser.getModule().getRelationships(), IMetadata.class);
        ArrayList<IMetadata> joinsToPackage = new ArrayList<IMetadata>();
        for (IMetadata j : joinsInModule) {
            MoserRelationship r;
            if (!(j instanceof MoserRelationship) || !UnwindModuleJoinsReferencingPackages.isFromPackage(mdMoser, (r = (MoserRelationship)j).getLeftRefObject()) && !UnwindModuleJoinsReferencingPackages.isFromPackage(mdMoser, r.getRightRefObject())) continue;
            joinsToPackage.add(r);
        }
        return joinsToPackage;
    }

    private static boolean isFromPackage(MoserMetadataConnection mdMoser, IMetadata md) {
        MetadataConnection metadataConnection = UnwindModuleJoinsReferencingPackages.getMetadataConnectionOfMetadataObject(mdMoser, md);
        return !(metadataConnection instanceof MoserMetadataConnection);
    }

    private static MetadataConnection getMetadataConnectionOfMetadataObject(MoserMetadataConnection moserMDConnection, IMetadata md) {
        MetadataConnection metadataConnection = md.getConnection();
        if (metadataConnection == null) {
            metadataConnection = moserMDConnection;
        }
        return metadataConnection;
    }

    private void remapRelationshipsToUnwoundQS(PlanningEnvironment environment, V5Query v5Query, List<IMetadata> joinsInModule) {
        MoserRelationship r;
        MoserMetadataConnection mdMoser = (MoserMetadataConnection)environment.getMetadataConnection();
        ArrayList<MoserRelationship> relationshipsToMiniQS = new ArrayList<MoserRelationship>();
        HashMap<String, IQuerySubject> newQSMap = new HashMap<String, IQuerySubject>();
        boolean redefine = false;
        ArrayList<MoserRelationship> newJoins = new ArrayList<MoserRelationship>(joinsInModule.size());
        int i = -1;
        for (IMetadata j : joinsInModule) {
            IMetadata rightQS;
            ++i;
            newJoins.add(null);
            if (!(j instanceof MoserRelationship) || (r = (MoserRelationship)j).getIsUnwound() || !UnwindModuleJoinsReferencingPackages.isFromPackage(mdMoser, r.getLeftRefObject()) && !UnwindModuleJoinsReferencingPackages.isFromPackage(mdMoser, r.getRightRefObject())) continue;
            IXQEQueryNode joinExpr = RQPUtilities.createV5ValueExpression(r, environment, null);
            RQPTNode tempExprNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
            v5Query.addChild(tempExprNode);
            tempExprNode.addChild(joinExpr);
            joinExpr = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(environment, joinExpr);
            boolean createMiniQS = false;
            IMetadata leftQS = this.unwindQS(environment, v5Query, joinExpr, r.getLeftRefObject());
            if (leftQS == null) {
                createMiniQS = true;
                redefine = true;
            }
            if ((rightQS = this.unwindQS(environment, v5Query, joinExpr, r.getRightRefObject())) == null) {
                createMiniQS = true;
                redefine = true;
            }
            if (createMiniQS) {
                leftQS = r.getLeftRefObject();
                leftQS = this.createMiniQS(environment, mdMoser, leftQS, newQSMap, v5Query);
                rightQS = r.getRightRefObject();
                rightQS = this.createMiniQS(environment, mdMoser, rightQS, newQSMap, v5Query);
            }
            long joinID = mdMoser.getNextId();
            String joinName = DYNAMIC_SQS_JOIN + joinID;
            MoserRelationship join = new MoserRelationship(joinID, joinName);
            join.setLeftRefObject(leftQS);
            join.setLeftRefObjectId(mdMoser.getID(leftQS));
            join.setLeftCardinality(r.getLeftCardinality());
            join.setRightRefObject(rightQS);
            join.setRightRefObjectId(mdMoser.getID(rightQS));
            join.setRightCardinality(r.getRightCardinality());
            join.setJoinFilterType(r.getJoinFilterType());
            RQPUtilities.unwindAndBindModelIdentifiers(environment, joinExpr, v5Query);
            StringBuilder sb = new StringBuilder();
            joinExpr.writeFormattedText(sb);
            String expression = sb.toString();
            join.setExpression(expression);
            joinExpr.detach();
            tempExprNode.detach();
            MoserModule module = mdMoser.getModule();
            join.setUniqueID(module.getUniqueName() + "." + join.getName() + joinID);
            join.setParentModule(module);
            if (createMiniQS) {
                relationshipsToMiniQS.add(join);
            }
            newJoins.set(i, join);
        }
        if (redefine) {
            i = -1;
            for (MoserRelationship newJoin : newJoins) {
                ++i;
                if (newJoin == null) continue;
                r = (MoserRelationship)joinsInModule.get(i);
                IMetadata leftQS = (IMetadata)newQSMap.get(this.getQSID(mdMoser, r.getLeftRefObject()));
                IMetadata rightQS = (IMetadata)newQSMap.get(this.getQSID(mdMoser, r.getRightRefObject()));
                if (leftQS == null && rightQS == null) continue;
                if (!relationshipsToMiniQS.contains(newJoin)) {
                    relationshipsToMiniQS.add(newJoin);
                }
                if (leftQS == null) {
                    leftQS = this.createMiniQS(environment, mdMoser, r.getLeftRefObject(), newQSMap, v5Query);
                }
                newJoin.setLeftRefObject(leftQS);
                if (rightQS == null) {
                    rightQS = this.createMiniQS(environment, mdMoser, r.getRightRefObject(), newQSMap, v5Query);
                }
                newJoin.setRightRefObject(rightQS);
                IXQEQueryNode joinExpr = RQPUtilities.createV5ValueExpression(r, environment, null);
                RQPTNode tempExprNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
                v5Query.addChild(tempExprNode);
                tempExprNode.addChild(joinExpr);
                joinExpr = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(environment, joinExpr);
                RQPUtilities.unwindAndBindModelIdentifiers(environment, joinExpr, v5Query);
                StringBuilder sb = new StringBuilder();
                joinExpr.writeFormattedText(sb);
                String expression = sb.toString();
                newJoin.setExpression(expression);
                joinExpr.detach();
                tempExprNode.detach();
            }
        }
        i = -1;
        for (MoserRelationship newJoin : newJoins) {
            r = (MoserRelationship)joinsInModule.get(++i);
            if (newJoin == null) continue;
            if (relationshipsToMiniQS.contains(newJoin)) {
                mdMoser.getModule().addRelationship(newJoin);
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).registerResource(newJoin);
                continue;
            }
            r.setUnwoundRelationship(newJoin);
        }
    }

    private IMetadata createMiniQS(PlanningEnvironment environment, MoserMetadataConnection mdMoser, IMetadata qs, Map<String, IQuerySubject> qsMap, V5Query v5Query) {
        v5Query.setPropertyValue(PROP_MINIQS_MAP, qsMap);
        String qsID = this.getQSID(mdMoser, qs);
        MoserQuerySubject qsToReturn = (MoserQuerySubject)qsMap.get(qsID);
        if (qsToReturn == null) {
            qsToReturn = mdMoser.createQS(qs.getName(), IQuerySubject.QuerySubjectUsageEnum.AUTOMATIC, "MiniQS");
            qsToReturn.setInvolvedInJoins(true);
            qsToReturn.setIsDynamicMini(true);
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).registerResource(qsToReturn);
            qsMap.put(qsID, qsToReturn);
        }
        return qsToReturn;
    }

    private String getQSID(MoserMetadataConnection mdMoser, IMetadata qs) {
        if (qs instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)qs).isAccessedViaShortcut()) {
            qs = ((IAccessedViaShortcut)qs).getShortcut();
        }
        return mdMoser.getID(qs);
    }

    private IMetadata unwindQS(PlanningEnvironment environment, V5Query v5Query, IXQEQueryNode joinExpr, IMetadata qs) {
        MetadataConnection mdConn = environment.getMetadataConnection();
        IXQEQueryNode toUnwind = null;
        String qsID = mdConn.getID(qs);
        for (IXQEQueryNode i : joinExpr.getDescendantsOfType(201116, false)) {
            V5BoundModelIdentifier bmID = (V5BoundModelIdentifier)i;
            IQuerySubject bmIDQS = bmID.getQuerySubject();
            if (mdConn.getID(bmIDQS).equals(qsID)) {
                toUnwind = bmID;
                break;
            }
            if (!(bmIDQS instanceof IAccessedViaShortcut) || !((IAccessedViaShortcut)((Object)bmIDQS)).isAccessedViaShortcut() || !mdConn.getID(((IAccessedViaShortcut)((Object)bmIDQS)).getShortcut()).equals(qsID)) continue;
            toUnwind = bmID;
            break;
        }
        RQPTNode tempExprNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
        v5Query.addChild(tempExprNode);
        toUnwind = environment.getNodeFactory().deepCopyNode(toUnwind);
        tempExprNode.addChild(toUnwind);
        RQPUtilities.unwindAndBindModelIdentifiers(environment, tempExprNode);
        IQuerySubject qsToReturn = null;
        for (IXQEQueryNode bmID : tempExprNode.getDescendantsOfType(201116, false)) {
            IMetadata bmIDQS = ((V5BoundModelIdentifier)bmID).getQuerySubject();
            if (bmIDQS instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)bmIDQS).isAccessedViaShortcut()) {
                bmIDQS = ((IAccessedViaShortcut)bmIDQS).getShortcut();
            }
            if (qsToReturn == null) {
                qsToReturn = bmIDQS;
                continue;
            }
            if (qsToReturn.equals(bmIDQS)) continue;
            qsToReturn = null;
            break;
        }
        tempExprNode.detachChildren();
        tempExprNode.detach();
        return qsToReturn;
    }
}

