/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class UpdateExplicitForClauseOfAnalyticAndRunningMovingFunctions
extends RQPTransformation {
    public UpdateExplicitForClauseOfAnalyticAndRunningMovingFunctions() {
        this.mName = "UpdateExplicitForClauseOfAnalyticAndRunningMovingFunctions";
        this.mPassNumbers = new int[]{61};
        this.mTypes = new int[]{201037};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getNumberChildren() == 0) {
            node.detach();
            return;
        }
        RQPQuery rootQuery = (RQPQuery)node.getAncestorOfType(801017);
        RQPSummaryQuery summaryQuery = (RQPSummaryQuery)rootQuery.getLowestLevelSummaryQuery();
        if (summaryQuery == null) {
            summaryQuery = rootQuery.getDefaultSummaryQuery();
        }
        RQPQuery matchingSummaryQuery = null;
        boolean useMatchingForItems = false;
        List<String> matchingForItems = this.getMatchingForItems(node, summaryQuery);
        if (matchingForItems.size() == node.getNumberChildren()) {
            matchingSummaryQuery = summaryQuery;
            useMatchingForItems = true;
        } else {
            V5AggregateFunction aggregate = (V5AggregateFunction)node.getParent();
            matchingSummaryQuery = RQPSummaryQuery.getSummaryQueryMatchingAggregateForClause(environment, aggregate, new int[]{801024});
            rootQuery.setNeedToRecreateLLSQ(true);
        }
        RQPGroupByList groupByList = (RQPGroupByList)matchingSummaryQuery.getFirstChildByType(801013);
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode forClauseItem = node.getChild(i);
            String dataItemRefName = null;
            if (useMatchingForItems) {
                dataItemRefName = matchingForItems.get(i);
            } else {
                IXQEQueryNode forClauseItemExpr = forClauseItem;
                if (forClauseItem.getType() == 101003) {
                    forClauseItemExpr = forClauseItem.getChild(0);
                }
                dataItemRefName = this.getMatchingGroupByItemName(groupByList, forClauseItemExpr);
            }
            RQPDataItemRef dataItemRef = RQPDataItemRef.create(environment, matchingSummaryQuery.getName(), dataItemRefName);
            forClauseItem.exchange(dataItemRef);
        }
    }

    private List<String> getMatchingForItems(IXQEQueryNode node, RQPQuery defaultSummaryQuery) {
        RQPGroupByList groupByList = (RQPGroupByList)defaultSummaryQuery.getFirstChildByType(801013);
        ArrayList<String> newRefsOfForItems = new ArrayList<String>();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            String dataItemRefName;
            IXQEQueryNode forClauseItem;
            IXQEQueryNode forClauseItemExpr = forClauseItem = node.getChild(i);
            if (forClauseItem.getType() == 101003) {
                forClauseItemExpr = forClauseItem.getChild(0);
            }
            if ((dataItemRefName = this.getMatchingGroupByItemName(groupByList, forClauseItemExpr)) == null) {
                return newRefsOfForItems;
            }
            newRefsOfForItems.add(dataItemRefName);
        }
        return newRefsOfForItems;
    }

    private String getMatchingGroupByItemName(RQPGroupByList groupByList, IXQEQueryNode forClauseItem) {
        if (groupByList == null) {
            return null;
        }
        for (int j = 0; j < groupByList.getNumberChildren(); ++j) {
            RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)groupByList.getChild(j);
            if (!selfRef.isSameExpression(forClauseItem, false)) continue;
            return selfRef.getName();
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (node.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "The V5AggregateBreakClause node has no children", xqeTrace);
            return false;
        }
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The V5AggregateBreakClause node is not under a RQP query", xqeTrace);
            return false;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        if (rqpQuery.isRelalionalSubqueryForFirstAndLast()) {
            this.traceNodeCondition(false, "Skip this transformation in the context of a DMR relationalSubquery for first and last.", xqeTrace);
            return false;
        }
        RQPQuery rootQuery = (RQPQuery)node.getAncestorOfType(801017);
        if (rootQuery.isAutoSummaryFALSE() && !rqpQuery.isSummarizedQuery()) {
            this.traceNodeCondition(false, "This transformation is not applied for non-summarized queries that have autoSummary=false", xqeTrace);
            return false;
        }
        if (node.getDescendantsOfType(801009, false).length > 0) {
            this.traceNodeCondition(false, "This transformation is already applied on this node", xqeTrace);
            return false;
        }
        RQPSummaryQuery summaryQuery = (RQPSummaryQuery)rootQuery.getLowestLevelSummaryQuery();
        if (summaryQuery == null) {
            this.traceNodeCondition(true, "There is no lowest level Summary query", xqeTrace);
            return false;
        }
        if (summaryQuery == rqpQuery && RQPSummaryQuery.groupingItemsAreSubsetOf(node.getChildren(), summaryQuery.getGroupingItems())) {
            this.traceNodeCondition(true, "The break clause has lower scope then the lowest level summary", xqeTrace);
            return false;
        }
        if (rqpQuery.getType() == 801025) {
            this.traceNodeCondition(false, "The V5AggregateBreakClause node is under a RQPTabularQuery.", xqeTrace);
            return false;
        }
        if (UpdateExplicitForClauseOfAnalyticAndRunningMovingFunctions.areForClauseItemsStdAggregates(node)) {
            return false;
        }
        for (RQPDataItemRef rqpDataItemRef : ExpressionAnalyzer.getAllReferences(summaryQuery)) {
            if (!rqpDataItemRef.getQueryName().equals(rqpQuery.getName())) continue;
            String failReason = "The lowest level summary query references back to summary query which will cause a circular reference.";
            this.traceNodeCondition(false, failReason, xqeTrace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent != null && parent.getType() != 201031) {
            this.traceNodeCondition(true, "The break clause belongs to a window aggregate", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "The break clause does not belong to a window aggregate", xqeTrace);
        return false;
    }

    public static boolean areForClauseItemsStdAggregates(IXQEQueryNode node) {
        IXQEQueryNode[] aggregates;
        for (IXQEQueryNode a : aggregates = node.getDescendantsOfType(201031, true)) {
            V5AggregateFunction aggregate = (V5AggregateFunction)a;
            if (aggregate.getRollupAggregateNode()) continue;
            return true;
        }
        return false;
    }
}

