/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.ReplaceV5SummaryFunction;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.List;

public class CollapseUngroupedLowestLevelSQ
extends RQPTransformation {
    public CollapseUngroupedLowestLevelSQ() {
        this.mName = "Collapse Ungrouped Lowest Level Summary Query";
        this.mPassNumbers = new int[]{88};
        this.mTypes = new int[]{801024, 801012};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPSummaryQuery lowestLevelSQ = (RQPSummaryQuery)node;
        RQPProjectionList projectionList = lowestLevelSQ.getProjectionList();
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            IXQEQueryNode[] aggregateNodes;
            RQPDataItem projection = (RQPDataItem)projectionList.getChild(i);
            IXQEQueryNode projExpr = projection.getExpression();
            for (IXQEQueryNode a : aggregateNodes = ExpressionAnalyzer.getAggregateNodes(projExpr)) {
                V5AggregateFunction aggregateNode = (V5AggregateFunction)a;
                if (aggregateNode.getForClause() != null || aggregateNode.getFirstChildByType(301042) != null) continue;
                IXQEQueryNode forClause = environment.getNodeFactory().createNode(201037);
                aggregateNode.addChild(forClause);
                IXQEQueryNode[] refsToProjection = projection.getAllReferencesToMe();
                if (refsToProjection == null || refsToProjection.length == 0) continue;
                if (refsToProjection.length == 1) {
                    projExpr.detach();
                    refsToProjection[0].exchange(projExpr);
                    continue;
                }
                for (IXQEQueryNode r : refsToProjection) {
                    projExpr = environment.getNodeFactory().deepCopyNode(projExpr);
                    r.exchange(projExpr);
                }
            }
        }
        lowestLevelSQ.setLowestLevelSummaryQueryProperty(null);
        node.detach();
    }

    public static boolean isDistinctAggrSupported(IXQEQueryNode aggregate, PlanningEnvironment environment) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        MetadataConnection mdConnection = environment.getMetadataConnection();
        IDataSourceCapabilities capabilities = null;
        if (mdConnection != null) {
            List<IModelDataSource> modelDataSources = mdConnection.getModelDataSources();
            if (modelDataSources.size() == 1) {
                IModelDataSource modelDS = modelDataSources.get(0);
                if (modelDS.isRelational()) {
                    IDataSource ds = execEnv.getOrAddDataSource(modelDS);
                    capabilities = ds.getCapabilities();
                }
            } else {
                for (IModelDataSource modelDS : modelDataSources) {
                    if (!modelDS.isRelational()) continue;
                    try {
                        IDataSource ds = execEnv.getOrAddDataSource(modelDS);
                        capabilities = ds.getCapabilities();
                        if (capabilities != null) break;
                    }
                    catch (Exception e) {}
                }
            }
        }
        SQLAggregate.SubType sqlAggregateSubtype = ReplaceV5SummaryFunction.convertV5AggregateFunctionSubTypeToSqlAggregateSubtype(ReplaceV5SummaryFunction.getV5AggregateFunctionSubType(aggregate), true);
        return capabilities == null || !capabilities.getStringValue("olap." + SQLAggregate.getAggregateFunctionName(sqlAggregateSubtype) + ".distinct[any]", "").isEmpty();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        RQPSummaryQuery summaryQuery = (RQPSummaryQuery)node;
        if (!RQPSummaryQuery.isForReportSubquery(summaryQuery)) {
            return false;
        }
        if (summaryQuery.getProjectionList() == null) {
            return false;
        }
        if (!summaryQuery.isLowestLevelSummaryQuery()) {
            return false;
        }
        if (summaryQuery.getParentRQPQuery().getRootRQPQuery().isAutoSummaryTRUE()) {
            return false;
        }
        RQPSummaryQuery lowestLevelSQ = (RQPSummaryQuery)node;
        RQPProjectionList projectionList = lowestLevelSQ.getProjectionList();
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            IXQEQueryNode[] aggregateNodes;
            RQPDataItem projection = (RQPDataItem)projectionList.getChild(i);
            IXQEQueryNode projExpr = projection.getExpression();
            for (IXQEQueryNode a : aggregateNodes = ExpressionAnalyzer.getAggregateNodes(projExpr)) {
                V5AggregateFunction aggregateNode = (V5AggregateFunction)a;
                if (aggregateNode.getForClause() != null || aggregateNode.getFirstChildByType(301042) != null || !aggregateNode.getDistinct() || CollapseUngroupedLowestLevelSQ.isDistinctAggrSupported(aggregateNode, environment)) continue;
                return false;
            }
        }
        return true;
    }
}

