/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.List;

public class CreateLowestLevelSummaryQuery
extends RQPTransformation {
    public CreateLowestLevelSummaryQuery() {
        this.mName = "Create the lowest level grouping summary query";
        this.mPassNumbers = new int[]{59, 70};
        this.mTypes = new int[]{801017};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rootQuery = (RQPQuery)node;
        if (rootQuery.hasDescendantOfType(801017, false)) {
            this.traceNodeCondition(false, "The root query is the root of multi-fact queries", xqeTrace);
            return false;
        }
        RQPQuery lowestLevelSummaryQuery = rootQuery.getLowestLevelSummaryQuery();
        if (lowestLevelSummaryQuery != null && !rootQuery.getNeedToRecreateLLSQ()) {
            this.traceNodeCondition(false, "All summary queries' group-by list are a subset an existing summary query's group-by list.", xqeTrace);
            return false;
        }
        IXQEQueryNode subqueryList = rootQuery.getSubqueryList();
        if (!subqueryList.hasDescendantOfType(801016, false)) {
            this.traceNodeCondition(false, "None of the sub-queries contain a projection list, therefore we cannot create a lowest level summary query.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "A lowest level summary query will be created there is no summary query whose group-by list is a superset of all the other summary queries' group-by list.", xqeTrace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rootQuery = (RQPQuery)node;
        RQPSummaryQuery defaultSummaryQuery = rootQuery.getDefaultSummaryQuery();
        RQPSummaryQuery lowestLevelSummaryQuery = rootQuery.createSummaryQuery(environment);
        lowestLevelSummaryQuery.getOrCreateProjectionList(environment);
        this.addMissingGroupingColumns(environment, rootQuery, defaultSummaryQuery, lowestLevelSummaryQuery);
        rootQuery.setLowestLevelSummaryQueryProperty(lowestLevelSummaryQuery);
        rootQuery.setNeedToRecreateLLSQ(false);
    }

    private void addMissingGroupingColumns(PlanningEnvironment environment, RQPQuery rootQuery, RQPSummaryQuery defaultSummaryQuery, RQPSummaryQuery lowestLevelSummaryQuery) {
        RQPGroupByList lowestLevelSQGroupByList = lowestLevelSummaryQuery.getOrCreateGroupbyList(environment);
        IXQEQueryNode subqueryList = rootQuery.getSubqueryList();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (int i = 0; i < subqueryList.getNumberChildren(); ++i) {
            IXQEQueryNode currentSQGroupByList;
            RQPQuery subquery = (RQPQuery)subqueryList.getChild(i);
            if (!subquery.isSummarizedQuery() || (currentSQGroupByList = subquery.getFirstChildByType(801013)) == null) continue;
            for (int j = 0; j < currentSQGroupByList.getNumberChildren(); ++j) {
                RQPDataItemSelfRef currentSQGroupingItem = (RQPDataItemSelfRef)currentSQGroupByList.getChild(j);
                if (this.referencesAggregateInSummaryQuery(currentSQGroupingItem.getExpression())) {
                    subquery.setCanRewriteInTermsOfLLSQ(false);
                    continue;
                }
                boolean found = false;
                for (int k = 0; k < lowestLevelSQGroupByList.getNumberChildren(); ++k) {
                    if (!currentSQGroupingItem.isSameExpression(lowestLevelSQGroupByList.getChild(k), false)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lowestLevelSummaryQuery.createGroupingColumn(environment, nodeFactory.deepCopyNode(currentSQGroupingItem.getExpression()));
            }
        }
    }

    private boolean referencesAggregateInSummaryQuery(IXQEQueryNode expression) {
        if (ExpressionAnalyzer.exprOrRefExprHasStandardAggregate(expression)) {
            List<IXQEQueryNode> refs = expression.getDescendantsOfTypeOrdered(801009, true);
            for (IXQEQueryNode ref : refs) {
                RQPQuery refQuery = ((RQPDataItemRef)ref).getQuery();
                if (!refQuery.isSummarizedQuery()) continue;
                List<RQPQuery> refSubqueries = refQuery.getSubquerySources();
                for (RQPQuery refSubquery : refSubqueries) {
                    if (!refSubquery.isSummarizedQuery()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

