/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.InitializeRelationalDataItemDependency;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class GenerateColumnDependency
extends RQPTransformation {
    public GenerateColumnDependency() {
        this.mName = "Generate column dependency";
        this.mPassNumbers = new int[]{94};
        this.mTypes = new int[]{801017};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery query = (RQPQuery)node;
        RQPProjectionList projection = query.getProjectionList();
        RQPFactManager factManager = query.getFactManager();
        HashMap<String, Set<IMetadata>> columnToScope = new HashMap<String, Set<IMetadata>>();
        HashMap<IMetadata, Set<String>> scopeToColumns = new HashMap<IMetadata, Set<String>>();
        this.getColumnScope(projection, columnToScope, scopeToColumns);
        Map<IMetadata, Set<IMetadata>> dataItemDependencies = factManager.getDataItemDependency();
        this.determineColumnDependency(projection, dataItemDependencies, columnToScope, scopeToColumns);
        environment.setTreeHasBeenModified();
    }

    private void getColumnScope(RQPProjectionList projection, Map<String, Set<IMetadata>> columnToScope, Map<IMetadata, Set<String>> scopeToColumns) {
        for (IXQEQueryNode proj : projection.getChildren()) {
            RQPDataItem column = (RQPDataItem)proj;
            boolean isGroupingItem = column.isGroupingItem();
            String columnName = column.getName();
            RSAPIDataItem rsapiDataItem = (RSAPIDataItem)column.getPropertyValue("RSAPIRefDataItem");
            if (rsapiDataItem == null) continue;
            LinkedHashSet<IMetadata> scope = new LinkedHashSet<IMetadata>();
            columnToScope.put(columnName, scope);
            LinkedHashSet<IMetadata> bIds = new LinkedHashSet<IMetadata>();
            this.getBoundIDInScope(column, bIds);
            for (IMetadata bId : bIds) {
                scope.add(bId);
                if (!isGroupingItem) continue;
                Set<String> columns = scopeToColumns.get(bId);
                if (columns == null) {
                    columns = new LinkedHashSet<String>();
                    scopeToColumns.put(bId, columns);
                }
                columns.add(columnName);
            }
        }
    }

    private void getBoundIDInScope(RQPDataItem dataItem, Set<IMetadata> references) {
        IXQEQueryNode[] nodes;
        int[] types = new int[]{201116, 801009};
        for (IXQEQueryNode node : nodes = dataItem.getDescendantsOfTypes(types, false, 301034)) {
            if (node.getType() == 201116) {
                V5BoundModelIdentifier modelId = (V5BoundModelIdentifier)node;
                references.add(modelId.getMetadata());
                continue;
            }
            RQPDataItemRef dataItemRef = (RQPDataItemRef)node;
            this.getBoundIDInScope(dataItemRef.getReferencedItem(), references);
        }
    }

    private void determineColumnDependency(RQPProjectionList projection, Map<IMetadata, Set<IMetadata>> dataItemDependencies, Map<String, Set<IMetadata>> columnToScope, Map<IMetadata, Set<String>> scopeToColumns) {
        for (IXQEQueryNode proj : projection.getChildren()) {
            RQPDataItem column = (RQPDataItem)proj;
            boolean isGroupingItem = column.isGroupingItem();
            String columnName = column.getName();
            RSAPIDataItem rsapiDataItem = (RSAPIDataItem)column.getPropertyValue("RSAPIRefDataItem");
            if (rsapiDataItem == null) continue;
            Set<IMetadata> scope = columnToScope.get(columnName);
            LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
            for (IMetadata scopeItem : scope) {
                Set<IMetadata> scopeDependencies;
                Set<String> columns;
                if (!isGroupingItem && (columns = scopeToColumns.get(scopeItem)) != null) {
                    dependencies.addAll(columns);
                }
                if ((scopeDependencies = dataItemDependencies.get(scopeItem)) == null) continue;
                for (IMetadata scopeDependency : scopeDependencies) {
                    Set<String> columns2 = scopeToColumns.get(scopeDependency);
                    if (columns2 == null) continue;
                    dependencies.addAll(columns2);
                }
            }
            rsapiDataItem.setDependency(new ArrayList<String>(dependencies));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        String msg = InitializeRelationalDataItemDependency.columnDependencyCondition(node);
        if (msg != null) {
            this.traceNodeCondition(false, msg, trace);
            return false;
        }
        this.traceNodeCondition(true, "Generate the column dependency", trace);
        return true;
    }
}

