/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.List;

public class JoinSummaryQueries
extends RQPTransformation {
    public JoinSummaryQueries() {
        this.mName = "Join RQPSummaryQuery nodes";
        this.mPassNumbers = new int[]{126};
        this.mTypes = new int[]{801017, 801024, 801012};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        if (node.getType() == 801017 && ((RQPQuery)node).getSubqueryList() != null && ((RQPQuery)node).getSubqueryList().getNumberChildrenOfType(801017) > 1) {
            this.traceNodeCondition(false, "The root query of multi-fact query can not join with other sub-queries", xqeTrace);
            return false;
        }
        RQPQuery rqpQuery = (RQPQuery)node;
        List<RQPQuery> subqueriesToJoin = rqpQuery.getSubqueriesToJoin();
        if (subqueriesToJoin.size() > 1) {
            RQPQuery lowestLevelSummaryQueryReferencedInParentQuery = JoinSummaryQueries.getLowestLevelSummaryQueryReferenced(rqpQuery);
            if (lowestLevelSummaryQueryReferencedInParentQuery == null) {
                lowestLevelSummaryQueryReferencedInParentQuery = rqpQuery.getLowestLevelSummaryQuery();
            }
            for (int i = 0; i < subqueriesToJoin.size(); ++i) {
                RQPQuery queryToJoin = subqueriesToJoin.get(i);
                if (queryToJoin == lowestLevelSummaryQueryReferencedInParentQuery) continue;
                this.traceNodeCondition(true, "This query gets its data from more than one subquery that can return multiple rows, so they'll be joined.", xqeTrace);
                return true;
            }
            this.traceNodeCondition(true, "Only lowestLevelSummaryQuery, must not be joined to self.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(false, "This query does not need to join any subqueries.", xqeTrace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = (RQPQuery)node;
        Governors govs = rqpQuery.getGovernors();
        RQPQuery lowestLevelSummaryQueryReferencedInParentQuery = JoinSummaryQueries.getLowestLevelSummaryQueryReferenced(rqpQuery);
        if (lowestLevelSummaryQueryReferencedInParentQuery == null) {
            lowestLevelSummaryQueryReferencedInParentQuery = rqpQuery.getLowestLevelSummaryQuery();
        }
        List<RQPQuery> subqueriesToJoin = rqpQuery.getSubqueriesToJoin();
        for (int i = 0; i < subqueriesToJoin.size(); ++i) {
            RQPQuery queryToJoin = subqueriesToJoin.get(i);
            if (queryToJoin == lowestLevelSummaryQueryReferencedInParentQuery) continue;
            if (queryToJoin.isAnalyticSubquery() || queryToJoin.getType() == 801025) {
                this.addFiltersForCommonGroupingColumns(environment, rqpQuery, queryToJoin, lowestLevelSummaryQueryReferencedInParentQuery);
                continue;
            }
            if (!queryToJoin.isSummarizedQuery()) continue;
            this.addFiltersForCommonGroupingColumns(environment, rqpQuery, lowestLevelSummaryQueryReferencedInParentQuery, (RQPSummaryQuery)queryToJoin, govs);
        }
    }

    private void addFiltersForCommonGroupingColumns(PlanningEnvironment environment, RQPQuery rqpQuery, RQPQuery lowestLevelSummaryQuery, RQPSummaryQuery summaryQuery, Governors govs) {
        if (!summaryQuery.hasGroupBy()) {
            return;
        }
        ArrayList<RQPNode> groupingItemsLowestLevelSummaryQuery = new ArrayList<RQPNode>();
        ArrayList<RQPDataItem> groupingItemsSummaryQuery = new ArrayList<RQPDataItem>();
        IXQEQueryNode groupByListSQ = summaryQuery.getFirstChildByType(801013);
        IXQEQueryNode[] columnsToJoinOn = this.getColumnsToJoinOn(lowestLevelSummaryQuery);
        block0: for (int i = 0; i < groupByListSQ.getNumberChildren(); ++i) {
            RQPDataItem groupingItemSQ = ((RQPDataItemSelfRef)groupByListSQ.getChild(i)).getRefProjection();
            for (int j = 0; j < columnsToJoinOn.length; ++j) {
                RQPNode groupingItemLowestLevelSQ = (RQPNode)columnsToJoinOn[j];
                if (!RQPSummaryQuery.isSameGroupingColumnExpression(groupingItemSQ, groupingItemLowestLevelSQ)) continue;
                groupingItemsLowestLevelSummaryQuery.add(groupingItemLowestLevelSQ);
                groupingItemsSummaryQuery.add(groupingItemSQ);
                continue block0;
            }
        }
        int nItem = 0;
        boolean bUseEqualOperator = false;
        if (govs != null) {
            if (govs.getSummaryQueryJoinOperator() == Governors.JoinOperator.EQUAL) {
                bUseEqualOperator = true;
            } else if (govs.getSummaryQueryJoinOperator() == Governors.JoinOperator.EQUAL_ALL_NOTNULL) {
                bUseEqualOperator = true;
                for (nItem = 0; nItem < groupingItemsSummaryQuery.size(); ++nItem) {
                    if (!JoinSummaryQueries.isNullable((IXQEQueryNode)groupingItemsLowestLevelSummaryQuery.get(nItem)) || !JoinSummaryQueries.isNullable((IXQEQueryNode)groupingItemsSummaryQuery.get(nItem))) continue;
                    bUseEqualOperator = false;
                    break;
                }
            }
        }
        for (nItem = 0; nItem < groupingItemsSummaryQuery.size(); ++nItem) {
            this.addIsNotDistinctFromFilter(environment, rqpQuery, lowestLevelSummaryQuery, summaryQuery, (RQPNode)groupingItemsSummaryQuery.get(nItem), (RQPNode)groupingItemsLowestLevelSummaryQuery.get(nItem), bUseEqualOperator);
        }
    }

    private void addFiltersForCommonGroupingColumns(PlanningEnvironment environment, RQPQuery rqpQuery, RQPQuery queryToJoin, RQPQuery lowestLevelSummaryQuery) {
        RQPProjectionList tabQueryProjectionList = queryToJoin.getProjectionList();
        IXQEQueryNode[] columnsToJoinOn = this.getColumnsToJoinOn(lowestLevelSummaryQuery);
        block0: for (int i = 0; i < columnsToJoinOn.length; ++i) {
            RQPNode groupingItemLowestLevelSQ = (RQPNode)columnsToJoinOn[i];
            for (int j = 0; j < tabQueryProjectionList.getNumberChildren(); ++j) {
                RQPNode tabQueryProjectionItem = (RQPNode)tabQueryProjectionList.getChild(j);
                if (!RQPSummaryQuery.isSameGroupingColumnExpression(groupingItemLowestLevelSQ, tabQueryProjectionItem)) continue;
                this.addIsNotDistinctFromFilter(environment, rqpQuery, lowestLevelSummaryQuery, queryToJoin, tabQueryProjectionItem, groupingItemLowestLevelSQ, false);
                continue block0;
            }
        }
    }

    private void addIsNotDistinctFromFilter(PlanningEnvironment environment, RQPQuery rqpQuery, RQPQuery lowestLevelSummaryQuery, RQPQuery query2, RQPNode query1Item, RQPNode query2Item, boolean bUseEqualOperator) {
        RQPNode refLowestLevelSQ = null;
        RQPDataItemRef refSQ = RQPDataItemRef.create(environment, query2.getName(), query1Item.getName());
        if (rqpQuery == lowestLevelSummaryQuery) {
            refLowestLevelSQ = RQPDataItemSelfRef.create(environment, query2Item.getName());
            RQPDataItem refProjection = rqpQuery.findProjection(query2Item.getName());
            if (refProjection.getExpression().isSameExpression(refSQ, false)) {
                return;
            }
        } else {
            refLowestLevelSQ = RQPDataItemRef.create(environment, lowestLevelSummaryQuery.getName(), query2Item.getName());
        }
        if (bUseEqualOperator) {
            SQLComparison sqlNode = (SQLComparison)environment.getNodeFactory().createNode(301026);
            sqlNode.setSubType(SQLComparison.SubType.EQUAL);
            sqlNode.addChild(refSQ);
            sqlNode.addChild(refLowestLevelSQ);
            rqpQuery.addToDetailFilterList(environment, sqlNode);
        } else {
            SQLIsDistinctFrom isNotDistinctFrom = (SQLIsDistinctFrom)environment.getNodeFactory().createNode(301075);
            isNotDistinctFrom.setNegated(true);
            isNotDistinctFrom.addChild(refSQ);
            isNotDistinctFrom.addChild(refLowestLevelSQ);
            rqpQuery.addToDetailFilterList(environment, isNotDistinctFrom);
        }
    }

    IXQEQueryNode[] getColumnsToJoinOn(RQPQuery lowestLevelQuery) {
        if (lowestLevelQuery.isSummarizedQuery()) {
            return ((RQPSummaryQuery)lowestLevelQuery).getGroupingItems();
        }
        RQPProjectionList projList = lowestLevelQuery.getProjectionList();
        return projList.getChildren();
    }

    public static RQPQuery getLowestLevelSummaryQueryReferenced(RQPQuery query) {
        List<RQPQuery> subqueriesToJoin = query.getSubqueriesToJoin();
        ArrayList<RQPQuery> summaryQueriesToJoin = new ArrayList<RQPQuery>();
        for (RQPQuery subQuery : subqueriesToJoin) {
            if (subQuery.isSummarizedQuery()) {
                summaryQueriesToJoin.add(subQuery);
                continue;
            }
            if (!subQuery.isSubqueryForSummaryFilters()) continue;
            return null;
        }
        for (RQPQuery subQuery : summaryQueriesToJoin) {
            if (!RQPQuery.allOtherSummaryQueriesGroupByListSubsetOf((RQPSummaryQuery)subQuery, summaryQueriesToJoin)) continue;
            return subQuery;
        }
        return null;
    }

    public static boolean isNullable(IXQEQueryNode expr) {
        if (expr.getType() == 801010) {
            expr = ((RQPDataItemSelfRef)expr).getRefProjection();
        }
        if (expr.getType() != 801008) {
            return true;
        }
        RQPDataItem item = (RQPDataItem)expr;
        Boolean bIsNullable = item.getIsNullableProperty();
        if (bIsNullable != null) {
            return bIsNullable;
        }
        expr = item.getExpression();
        if (expr.getType() != 801009) {
            return true;
        }
        item = ((RQPDataItemRef)expr).getReferencedItem();
        bIsNullable = item.getIsNullableProperty();
        return bIsNullable == null || bIsNullable != false;
    }
}

