/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OptimizePushdownQuery
extends RQPTransformation {
    private static final String STR_MERGED = "merged";
    private static final int STR_NUMBER_THREE = 3;

    public OptimizePushdownQuery() {
        this.mName = "Optimize Pushdown Query";
        this.mPassNumbers = new int[]{123};
        this.mTypes = new int[]{101002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] queries = node.getChildrenOfType(101006);
        V5Query innerMostQuery = (V5Query)queries[0];
        RQPQuery innerMostRqpQuery = this.getInnerMostRQPQuery(innerMostQuery, queries);
        IXQEQueryNode[] diRefs = this.getReferencesInCalculationExpr(innerMostRqpQuery.getProjectionList());
        if (queries.length > 3) {
            this.regroupQueries(queries, innerMostRqpQuery, diRefs);
        }
        V5Query outerMostQuery = (V5Query)queries[1];
        this.removeUnreferencedProjections(node, diRefs, innerMostRqpQuery, outerMostQuery);
        node.removeProperty("customValuePushDown");
    }

    private RQPQuery getInnerMostRQPQuery(V5Query innerMostQuery, IXQEQueryNode[] queries) {
        HashSet<String> queryNames = new HashSet<String>();
        for (int i = 2; i < queries.length; ++i) {
            queryNames.add(((V5Query)queries[i]).getV5QueryName());
        }
        RQPQuery innerMostRqpQuery = (RQPQuery)innerMostQuery.getChildrenOfType(801017)[0];
        IXQEQueryNode sqList = innerMostRqpQuery.getSubqueryList();
        if (sqList != null && sqList.getNumberChildren() > 0) {
            for (IXQEQueryNode subQ : sqList.getChildren()) {
                IXQEQueryNode[] refs;
                RQPQuery subQuery = (RQPQuery)subQ;
                RQPProjectionList projList = subQuery.getProjectionList();
                if (projList == null || projList.getNumberChildren() <= 0) continue;
                IXQEQueryNode firstProj = projList.getChild(0);
                for (IXQEQueryNode ref : refs = firstProj.getDescendantsOfType(201060, false)) {
                    V5BoundDataItemReference diRef = (V5BoundDataItemReference)ref;
                    if (!diRef.isQueryRefItem() || !queryNames.contains(diRef.getNameParts()[0])) continue;
                    return subQuery;
                }
            }
        }
        return innerMostRqpQuery;
    }

    private void regroupQueries(IXQEQueryNode[] queries, RQPQuery innerMostRqpQuery, IXQEQueryNode[] diRefs) {
        boolean regroupQuery = false;
        for (int i = 2; i < queries.length - 1; ++i) {
            V5Query query1 = (V5Query)queries[i];
            if (query1.getPropertyValue(STR_MERGED) != null) continue;
            RQPQuery rqpQuery1 = (RQPQuery)query1.getChildrenOfType(801017)[0];
            boolean mergedQueryIsLastQuery = false;
            for (int j = i + 1; j < queries.length; ++j) {
                RQPQuery rqpQuery2;
                V5Query query2 = (V5Query)queries[j];
                if (query2.getPropertyValue(STR_MERGED) != null || !this.areRedundant(rqpQuery1, rqpQuery2 = (RQPQuery)query2.getChildrenOfType(801017)[0])) continue;
                if (j == queries.length - 1) {
                    mergedQueryIsLastQuery = true;
                }
                this.merge(rqpQuery1, rqpQuery2, innerMostRqpQuery, diRefs, mergedQueryIsLastQuery);
                query2.setPropertyValue(STR_MERGED, true);
                regroupQuery = true;
            }
        }
        if (regroupQuery) {
            V5Source source = ((V5Query)queries[0]).getV5Source();
            Set<String> queryRefs = source.getReferencedQueries();
            for (IXQEQueryNode query : queries) {
                if (query.getPropertyValue(STR_MERGED) == null) continue;
                query.detach();
                queryRefs.remove(((V5Query)query).getV5QueryName());
            }
        }
    }

    private IXQEQueryNode[] getReferencesInCalculationExpr(RQPProjectionList projList) {
        ArrayList<IXQEQueryNode> references = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode child : projList.getChildren()) {
            IXQEQueryNode[] refs;
            RQPDataItem proj = (RQPDataItem)child;
            if (proj.isGroupingItem()) continue;
            for (IXQEQueryNode ref : refs = proj.getDescendantsOfType(201060, false)) {
                if (ref.getParent() != null && ref.getParent().getType() == 201037) continue;
                references.add(ref);
            }
        }
        IXQEQueryNode[] arrayRef = new IXQEQueryNode[references.size()];
        return references.toArray(arrayRef);
    }

    private void removeUnreferencedProjections(IXQEQueryNode node, IXQEQueryNode[] diRefs, RQPQuery innerMostRQPQuery, V5Query outermostQuery) {
        IXQEQueryNode[] queries = node.getChildrenOfType(101006);
        ArrayList<RQPDataItem> unReferencedProjs = new ArrayList<RQPDataItem>();
        this.collectUnreferencedProjections(diRefs, queries, unReferencedProjs);
        int i = 0;
        int size = unReferencedProjs.size();
        while (i < size) {
            ((RQPDataItem)unReferencedProjs.get(i++)).detach();
        }
    }

    private void collectUnreferencedProjections(IXQEQueryNode[] diRefs, IXQEQueryNode[] queries, List<RQPDataItem> unReferencedProjs) {
        for (int i = 2; i < queries.length; ++i) {
            RQPQuery rqpQuery = (RQPQuery)queries[i].getChildrenOfType(801017)[0];
            for (IXQEQueryNode di : rqpQuery.getProjectionList().getChildren()) {
                RQPDataItem rqpDi = (RQPDataItem)di;
                if (rqpDi.isGroupingItem() || this.hasMatchingReference(diRefs, ((V5Query)queries[i]).getV5QueryName(), rqpDi.getName())) continue;
                unReferencedProjs.add(rqpDi);
            }
        }
    }

    private void getRedundantProjections(List<RQPDataItem> rqpDis, List<String> redundantProjections) {
        for (int i = 0; i < rqpDis.size() - 1; ++i) {
            String proj1Name = rqpDis.get(i).getName();
            if (redundantProjections.contains(proj1Name)) continue;
            IXQEQueryNode expr1 = rqpDis.get(i).getExpression();
            for (int j = i + 1; j < rqpDis.size(); ++j) {
                IXQEQueryNode expr2;
                String proj2Name = rqpDis.get(j).getName();
                if (redundantProjections.contains(proj2Name) || !expr1.isSameExpression(expr2 = rqpDis.get(j).getExpression(), false)) continue;
                redundantProjections.add(proj2Name);
            }
        }
    }

    private void merge(RQPQuery rqpQuery1, RQPQuery rqpQuery2, RQPQuery rqpQuery0, IXQEQueryNode[] diRefs, boolean mergedQueryIsLastQuery) {
        String rqpQuery1Name = rqpQuery1.getName();
        String rqpQuery2Name = rqpQuery2.getName();
        PlanningEnvironment environment = (PlanningEnvironment)rqpQuery1.getPlanningEnvironment();
        for (IXQEQueryNode di : rqpQuery2.getProjectionList().getChildren()) {
            RQPDataItem rqpDi = (RQPDataItem)di;
            if (rqpDi.isGroupingItem() || !this.updateMatchingReferences(diRefs, rqpQuery2Name, rqpDi.getName(), rqpQuery1Name)) continue;
            RQPDataItem proj = (RQPDataItem)rqpDi.detach();
            rqpQuery1.addToProjectionList(environment, proj);
            this.updateJoinFilter(rqpQuery1Name, rqpQuery2Name, rqpQuery0, mergedQueryIsLastQuery);
        }
    }

    private void updateJoinFilter(String rqpQuery1Name, String rqpQuery2Name, RQPQuery rqpQuery0, boolean mergedQueryIsLastQuery) {
        int i;
        RQPDetailFilterList filters = rqpQuery0.getDetailFilterList();
        ArrayList<V5DetailFilter> filterToUpdate = new ArrayList<V5DetailFilter>();
        ArrayList<V5DetailFilter> filterToRemove = new ArrayList<V5DetailFilter>();
        String newQueryName = null;
        for (IXQEQueryNode child : filters.getChildren()) {
            V5ComparisonExpression compExpr = (V5ComparisonExpression)child.getFirstChildByType(201013);
            if (compExpr.getSubType() != 2) continue;
            IXQEQueryNode leftOperand = compExpr.getChild(0);
            IXQEQueryNode rightOperand = compExpr.getChild(1);
            if (leftOperand.getType() != 201060 || rightOperand.getType() != 201060) continue;
            if (((V5BoundDataItemReference)leftOperand).getNameParts()[0].equals(rqpQuery1Name) && ((V5BoundDataItemReference)rightOperand).getNameParts()[0].equals(rqpQuery2Name)) {
                if (!mergedQueryIsLastQuery) {
                    filterToUpdate.add((V5DetailFilter)child);
                    continue;
                }
                filterToRemove.add((V5DetailFilter)child);
                continue;
            }
            if (!((V5BoundDataItemReference)leftOperand).getNameParts()[0].equals(rqpQuery2Name)) continue;
            filterToRemove.add((V5DetailFilter)child);
            newQueryName = ((V5BoundDataItemReference)rightOperand).getNameParts()[0];
        }
        int size = filterToRemove.size();
        for (i = 0; i < size; ++i) {
            filters.detachChild((IXQEQueryNode)filterToRemove.get(i));
        }
        size = filterToUpdate.size();
        for (i = 0; i < size; ++i) {
            IXQEQueryNode[] diRefs;
            for (IXQEQueryNode diRef : diRefs = ((V5DetailFilter)filterToUpdate.get(i)).getDescendantsOfType(201060, false)) {
                if (!((V5BoundDataItemReference)diRef).getNameParts()[0].equals(rqpQuery2Name)) continue;
                ((V5BoundDataItemReference)diRef).setIdentifier(UniqueNameGenerator.createUniqueName(newQueryName, ((V5BoundDataItemReference)diRef).getNameParts()[1]));
            }
        }
    }

    private boolean updateMatchingReferences(IXQEQueryNode[] diRefs, String queryName, String columnName, String newQueryName) {
        boolean status = false;
        for (IXQEQueryNode ref : diRefs) {
            V5BoundDataItemReference boundDiRef = (V5BoundDataItemReference)ref;
            String[] nameParts = boundDiRef.getNameParts();
            if (!nameParts[0].equals(queryName) || !nameParts[1].equals(columnName)) continue;
            nameParts[0] = newQueryName;
            boundDiRef.setIdentifier(UniqueNameGenerator.createUniqueName(newQueryName, columnName));
            status = true;
        }
        return status;
    }

    private boolean hasMatchingReference(IXQEQueryNode[] diRefs, String queryName, String columnName) {
        for (IXQEQueryNode ref : diRefs) {
            V5BoundDataItemReference diRef = (V5BoundDataItemReference)ref;
            if (!diRef.getNameParts()[0].equals(queryName) || !diRef.getNameParts()[1].equals(columnName)) continue;
            return true;
        }
        return false;
    }

    private boolean areRedundant(RQPQuery rqpQuery1, RQPQuery rqpQuery2) {
        return this.haveSameJoinPath(rqpQuery1, rqpQuery2) && this.haveSameFilters(rqpQuery1, rqpQuery2);
    }

    private boolean haveSameJoinPath(RQPQuery rqpQuery1, RQPQuery rqpQuery2) {
        RQPJoinPath path1 = rqpQuery1.getJoinPath();
        RQPJoinPath path2 = rqpQuery2.getJoinPath();
        if (path1 != null && path2 == null) {
            return false;
        }
        if (path1 == null && path2 != null) {
            return false;
        }
        if (path1 == null) {
            return false;
        }
        return path1.isSameExpression(path2, false);
    }

    private boolean haveSameFilters(RQPQuery rqpQuery1, RQPQuery rqpQuery2) {
        RQPDetailFilterList dfList1 = rqpQuery1.getDetailFilterList();
        RQPDetailFilterList dfList2 = rqpQuery2.getDetailFilterList();
        if (dfList1 != null && dfList2 == null) {
            return false;
        }
        if (dfList1 == null && dfList2 != null) {
            return false;
        }
        if (dfList1 == null) {
            return true;
        }
        if (dfList1.getNumberChildren() != dfList2.getNumberChildren()) {
            return false;
        }
        for (IXQEQueryNode df1 : dfList1.getChildren()) {
            boolean found = false;
            for (IXQEQueryNode df2 : dfList2.getChildren()) {
                if (!df1.isSameExpression(df2, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (node.getPropertyValue("customValuePushDown") == null) {
            this.traceNodeCondition(false, "This query is not generated by CustomValue pushdown.", xqeTrace);
            return false;
        }
        IXQEQueryNode[] queries = node.getChildrenOfType(101006);
        if (queries.length < 3) {
            this.traceNodeCondition(false, "The pushdown query has only 1 measure, no redundant queries.", xqeTrace);
            return false;
        }
        return true;
    }
}

