/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.optimization.CollapseUngroupedLowestLevelSQ;
import com.cognos.xqe.transformation.v5tocogsql.optimization.CreateSummaryQueryToAvoidDoubleCounting;
import com.cognos.xqe.transformation.v5tocogsql.optimization.PushMedianOverDetailValueExprToTabularQuery;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class PushAggregateToTabularQueryForAutoFalse
extends RQPTransformation {
    private static final String PROP_CAN_NOT_BE_PUSHED_TO_TABQUERY = "canNotBePushedToTabQuery";

    public PushAggregateToTabularQueryForAutoFalse() {
        this.mName = "PushAggregateToTabularQueryForAutoFalse";
        this.mPassNumbers = new int[]{89};
        this.mTypes = new int[]{201031, 201033, 201035};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] refs;
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        RQPDataItem projection = (RQPDataItem)node.getAncestorOfType(801008);
        RQPQuery queryOfAggregate = RQPQuery.getRQPQuery(aggregate);
        RQPTabularQuery tabQuery = queryOfAggregate.getParentRQPQuery().getDefaultTabularQuery();
        RQPDataItem newDataItemInTQ = PushMedianOverDetailValueExprToTabularQuery.pushAggregateToTabularQuery(environment, tabQuery, queryOfAggregate, projection);
        for (IXQEQueryNode ref : refs = projection.getAllReferencesToMe()) {
            RQPDataItemRef refToNewDataItemInTQ = RQPDataItemRef.create(environment, newDataItemInTQ);
            ref.exchange(refToNewDataItemInTQ);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (node.getPropertyValue(PROP_CAN_NOT_BE_PUSHED_TO_TABQUERY) != null) {
            this.traceNodeCondition(false, "This node has been examined and can not be pushed to tabular query", trace);
            return false;
        }
        RQPQuery queryOfAggregate = RQPQuery.getRQPQuery(node);
        if (!queryOfAggregate.isSummarizedQuery()) {
            this.traceNodeCondition(false, "This aggregate is not in a summarized query", trace);
            return false;
        }
        if (queryOfAggregate.getRootRQPQuery().isAutoSummaryTRUE()) {
            this.traceNodeCondition(false, "The root query does not have autoSummary false", trace);
            return false;
        }
        if (queryOfAggregate.hasAncestorRQPQueryToAvoidDoubleCounting()) {
            return false;
        }
        IXQEQueryNode[] aggregates = ExpressionAnalyzer.getAggregateNodes(node);
        if (!CreateSummaryQueryToAvoidDoubleCounting.aggregateOperandIsFromDetail(node)) {
            this.traceNodeCondition(false, "The aggregate operand has references to other sub queries than tabular query", trace);
            for (IXQEQueryNode aggregate : aggregates) {
                aggregate.setPropertyValue(PROP_CAN_NOT_BE_PUSHED_TO_TABQUERY, true);
            }
            return false;
        }
        if (aggregates.length > 1 && !this.canPushNestedAggregates(node)) {
            this.traceNodeCondition(false, "Nested aggregate can not be pushed to tabular query", trace);
            for (IXQEQueryNode aggregate : aggregates) {
                aggregate.setPropertyValue(PROP_CAN_NOT_BE_PUSHED_TO_TABQUERY, true);
            }
            return false;
        }
        if (((V5AggregateFunction)node).getDistinct() && !CollapseUngroupedLowestLevelSQ.isDistinctAggrSupported(node, environment)) {
            return false;
        }
        this.traceNodeCondition(true, "This aggregate can be pushed to tabular query", trace);
        return true;
    }

    private boolean canPushNestedAggregates(IXQEQueryNode topAggregate) {
        IXQEQueryNode[] sumAggs = ExpressionAnalyzer.getSummaryFunctions(topAggregate);
        int[] types = new int[]{201033, 201035};
        for (IXQEQueryNode agg : sumAggs) {
            IXQEQueryNode olapAggAncestor = agg.getAncestorOfTypes(types);
            if (olapAggAncestor == null || olapAggAncestor.getType() == 201033 && ((V5AggregateFunction)olapAggAncestor).getSubType() == 14 && ((V5AggregateFunction)olapAggAncestor).getDistinct()) continue;
            return false;
        }
        return true;
    }
}

