/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RemoveRedundantProjectionsInSubQueries
extends RQPTransformation {
    public RemoveRedundantProjectionsInSubQueries() {
        this.mName = "Remove redundant projections in sub-queries";
        this.mPassNumbers = new int[]{123};
        this.mTypes = new int[]{801024, 801012, 801017, 801025};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        TreeMap<RQPQuery, List<IXQEQueryNode>> queryRefs = new TreeMap<RQPQuery, List<IXQEQueryNode>>();
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            RQPDataItem projection = (RQPDataItem)projectionList.getChild(i);
            List<RQPDataItem> redundantProjections = this.getRedundantProjectionsOf(i, projectionList);
            if (redundantProjections.size() <= 0) continue;
            this.updateReferencesInOuterQuery(projection, redundantProjections, queryRefs);
            this.removeOrUpdateGroupingItems(projection, redundantProjections);
            this.removeRedundantProjections(redundantProjections);
        }
    }

    private void removeRedundantProjections(List<RQPDataItem> redundantProjections) {
        for (RQPDataItem redundantProjection : redundantProjections) {
            redundantProjection.detach();
        }
    }

    private void updateReferencesInOuterQuery(RQPDataItem projection, List<RQPDataItem> redundantProjections, Map<RQPQuery, List<IXQEQueryNode>> queryRefs) {
        RQPQuery currentQuery = RQPNode.getRQPQuery(projection);
        RQPQuery parentRQPQuery = null;
        parentRQPQuery = currentQuery.getType() == 801017 ? (RQPQuery)currentQuery.getAncestorOfType(801017) : currentQuery.getParentRQPQuery();
        String projectionName = projection.getName();
        List<IXQEQueryNode> refs = queryRefs.get(parentRQPQuery);
        if (refs == null) {
            refs = parentRQPQuery.getDataItemRefs();
            queryRefs.put(parentRQPQuery, refs);
        }
        String curQueryName = currentQuery.getName();
        for (IXQEQueryNode ref : refs) {
            RQPDataItemRef rqpRef = (RQPDataItemRef)ref;
            if (!curQueryName.equals(rqpRef.getQueryName())) continue;
            String refName = rqpRef.getName();
            for (RQPDataItem redundantProjection : redundantProjections) {
                if (!redundantProjection.getName().equals(refName)) continue;
                rqpRef.setName(projectionName);
            }
        }
    }

    private void removeOrUpdateGroupingItems(RQPDataItem projection, List<RQPDataItem> redundantProjections) {
        RQPQuery currentQuery = RQPNode.getRQPQuery(projection);
        IXQEQueryNode[] groupingItems = currentQuery.getGroupingItems();
        if (groupingItems == null) {
            return;
        }
        RQPDataItemSelfRef projectionGroupingItem = this.getGroupingItem(projection, groupingItems);
        for (RQPDataItem item : redundantProjections) {
            String pname = item.getName();
            ArrayList<RQPDataItemSelfRef> itemsToRemove = new ArrayList<RQPDataItemSelfRef>();
            for (IXQEQueryNode ditem : groupingItems) {
                RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)ditem;
                if (!selfRef.getName().equals(pname)) continue;
                itemsToRemove.add(selfRef);
            }
            for (RQPDataItemSelfRef ditem : itemsToRemove) {
                if (projectionGroupingItem != null) {
                    ditem.detach();
                    continue;
                }
                ditem.setName(projection.getName());
                projectionGroupingItem = ditem;
            }
        }
    }

    private RQPDataItemSelfRef getGroupingItem(RQPDataItem projection, IXQEQueryNode[] groupingItems) {
        RQPDataItemSelfRef groupingItemProjection = null;
        for (IXQEQueryNode item : groupingItems) {
            RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)item;
            if (!selfRef.getName().equals(projection.getName())) continue;
            groupingItemProjection = selfRef;
            break;
        }
        return groupingItemProjection;
    }

    private List<RQPDataItem> getRedundantProjectionsOf(int pos, RQPProjectionList projectionList) {
        ArrayList<RQPDataItem> redundantProjections = new ArrayList<RQPDataItem>();
        RQPDataItem inputProjection = (RQPDataItem)projectionList.getChild(pos);
        for (int i = pos + 1; i < projectionList.getNumberChildren(); ++i) {
            RQPDataItem rqpProjection = (RQPDataItem)projectionList.getChild(i);
            if (!inputProjection.getExpression().isSameExpression(rqpProjection.getExpression(), false)) continue;
            redundantProjections.add(rqpProjection);
        }
        return redundantProjections;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        if (rqpQuery.getRootRQPQuery() == rqpQuery) {
            this.traceNodeCondition(false, "This query is not a sub-query.", xqeTrace);
            return false;
        }
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        if (projectionList == null || projectionList.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "This query has empty projection list.", xqeTrace);
            return false;
        }
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            if (this.getRedundantProjectionsOf(i, projectionList).size() <= 0) continue;
            this.traceNodeCondition(true, "Sub-query has redundant projections.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(true, "Sub-query does not have redundant projections.", xqeTrace);
        return false;
    }
}

