/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RemoveUnreferencedProjectionsInSubqueryForSummaryFilter
extends RQPTransformation {
    public RemoveUnreferencedProjectionsInSubqueryForSummaryFilter() {
        this.mName = "Remove unreferened projections in sub-query for summary filter";
        this.mPassNumbers = new int[]{124};
        this.mTypes = new int[]{801017};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<RQPDataItem> unreferencedProjections = this.getUnreferencedProjections(node, environment);
        if (unreferencedProjections.size() != 0) {
            this.removeUnreferencedProjections(unreferencedProjections);
        }
    }

    private List<RQPDataItem> getUnreferencedProjections(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] groupingItems;
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        RQPQuery parentRQPQuery = (RQPQuery)rqpQuery.getAncestorOfType(801017);
        List<IXQEQueryNode> refs = parentRQPQuery.getDataItemRefs();
        ArrayList<RQPDataItem> unreferencedProjections = new ArrayList<RQPDataItem>();
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            RQPDataItem projection = (RQPDataItem)projectionList.getChild(i);
            if (projection.getDoNotRemove()) continue;
            boolean found = false;
            for (IXQEQueryNode ref : refs) {
                RQPDataItemRef rqpRef = (RQPDataItemRef)ref;
                if (!rqpRef.isReferenceTo(projection)) continue;
                found = true;
                break;
            }
            if (found) continue;
            unreferencedProjections.add(projection);
        }
        if (unreferencedProjections.size() != 0 && (groupingItems = rqpQuery.getGroupingItems()) != null) {
            Iterator it = unreferencedProjections.iterator();
            while (it.hasNext()) {
                RQPDataItem item = (RQPDataItem)it.next();
                if (this.getGroupingItem(item, groupingItems) == null) continue;
                it.remove();
            }
        }
        return unreferencedProjections;
    }

    private RQPDataItemSelfRef getGroupingItem(RQPDataItem projection, IXQEQueryNode[] groupingItems) {
        RQPDataItemSelfRef groupingItemProjection = null;
        for (IXQEQueryNode item : groupingItems) {
            RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)item;
            if (!selfRef.getName().equals(projection.getName())) continue;
            groupingItemProjection = selfRef;
            break;
        }
        return groupingItemProjection;
    }

    private void removeUnreferencedProjections(List<RQPDataItem> unreferencedProjections) {
        for (RQPDataItem unreferencedProjection : unreferencedProjections) {
            unreferencedProjection.detach();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        List<RQPDataItem> unreferencedProjections;
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        if (rqpQuery.isSubqueryForSummaryFilters() && (unreferencedProjections = this.getUnreferencedProjections(node, environment)).size() != 0) {
            this.traceNodeCondition(true, "Sub-query has unreferenced projections.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "Sub-query does not have unreferenced projections.", xqeTrace);
        return false;
    }
}

