/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunctionSubtype;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5CastFunction;
import com.cognos.xqe.ast.v5Exp.V5CastTarget;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DetectNoOpAggregates;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.optimization.CreateSummaryQueryToAvoidDoubleCounting;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public abstract class RewriteAggregateInTermsOfLowestScope
extends RQPTransformation {
    private static Boolean castOperandOfMultiplyToDouble = null;

    public RewriteAggregateInTermsOfLowestScope() {
        this.mName = "RewriteAggregateInTermsOfLowestScope";
        this.mPassNumbers = new int[]{92};
        this.mTypes = new int[]{201031};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    public abstract boolean isApplicableForAggregate(V5AggregateFunction var1);

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] dataItemRefs;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        RQPQuery queryOfAggregate = RQPNode.getRQPQuery(aggregate);
        if (queryOfAggregate.isMultiFactQuery()) {
            this.traceNodeCondition(false, "The aggregate is in the projection list of the outermost query of multi-fact query.", xqeTrace);
            return false;
        }
        if (node.getAncestorOfType(801025) != null) {
            this.traceNodeCondition(false, "The aggregate belongs to a tabular query.", xqeTrace);
            return false;
        }
        if (queryOfAggregate.getBooleanPropertyValue("beingSplit") != null) {
            this.traceNodeCondition(false, "The aggregate belongs to the default summary query that has been split.", xqeTrace);
            return false;
        }
        if (queryOfAggregate.getRootRQPQuery().isAutoSummaryFALSE() && !CreateSummaryQueryToAvoidDoubleCounting.hasAncestorRQPQueryToAvoidDoubleCounting(queryOfAggregate)) {
            return false;
        }
        if (!this.isApplicableForAggregate(aggregate)) {
            this.traceNodeCondition(false, "The transformation is not applicable for this aggregate.", xqeTrace);
            return false;
        }
        if (this.aggregateReferencesAggregateInDynamicSQS(aggregate) && !this.isMaxMinSum(aggregate)) {
            return true;
        }
        if (aggregate.getDistinct()) {
            this.traceNodeCondition(false, "The transformation is not applicable for this distinct-aggregate.", xqeTrace);
            return false;
        }
        if (this.aggregateExpressionIsFromLowestLevelSummaryQuery(aggregate)) {
            this.traceNodeCondition(false, "The aggregate is already at the lowest scope.", xqeTrace);
            return false;
        }
        RQPQuery lowestLevelSQ = queryOfAggregate.getLowestLevelSummaryQuery();
        if (lowestLevelSQ == null) {
            this.traceNodeCondition(false, "The is no lowest level summary query query.", xqeTrace);
            return false;
        }
        RQPProjectionList projectionList = lowestLevelSQ.getProjectionList();
        if (projectionList == null || projectionList.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "Lowest level summary query has no projections.", xqeTrace);
            return false;
        }
        if (lowestLevelSQ.hasReferencesToQuery(queryOfAggregate)) {
            this.traceNodeCondition(false, "The lowest level summary query contains references to the aggregate query.", xqeTrace);
            return false;
        }
        if (lowestLevelSQ.getRootRQPQuery().isAutoSummaryFALSE() && !RewriteAggregateInTermsOfLowestScope.hasDescendantRQPSummaryQuery(lowestLevelSQ)) {
            return false;
        }
        if (this.aggregateContainsNestedStandardAggregate(aggregate) && !this.minOverMedianInTabQuery(aggregate)) {
            this.traceNodeCondition(false, "The aggregate contains a nested standard aggregate.", xqeTrace);
            return false;
        }
        IXQEQueryNode rqpDataItem = aggregate.getAncestorOfType(801008);
        if (rqpDataItem != null && ((RQPDataItem)rqpDataItem).getPropertyValue("aggrOnSharedDim") != null) {
            this.traceNodeCondition(false, "This aggregates shared dimension from multi-fact query, so the scope is already adjusted.", xqeTrace);
            return false;
        }
        IXQEQueryNode child = node.getChild(0);
        if (child.getType() == 201026) {
            this.traceNodeCondition(false, "This aggregate has operand as a constant.", xqeTrace);
            return false;
        }
        if (!queryOfAggregate.getCanRewriteInTermsOfLLSQ()) {
            return false;
        }
        for (IXQEQueryNode dataItemRef : dataItemRefs = node.getDescendantsOfType(801009, false)) {
            if (!lowestLevelSQ.getName().equals(((RQPDataItemRef)dataItemRef).getQueryName())) continue;
            return false;
        }
        IXQEQueryNode rmEmbeddedFilter = node.getAncestorOfType(801035);
        if (rmEmbeddedFilter != null && rmEmbeddedFilter.getPropertyValue("isConvertedToDetail") != null) {
            this.traceNodeCondition(false, "Embedded filter is already converted to detail filter.", xqeTrace);
            return false;
        }
        if (queryOfAggregate.getPropertyValue("needDistinctRecompute") != null) {
            return false;
        }
        this.traceNodeCondition(true, "The aggregate will be rewritten based on aggregate from lowest level summary query.", xqeTrace);
        return true;
    }

    private boolean isMaxMinSum(V5AggregateFunction aggregate) {
        switch (aggregate.getSubType()) {
            case 4: 
            case 6: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static boolean isReferencedInParentRQPQuery(RQPQuery queryOfAggregate) {
        RQPQuery parentRQPQuery = queryOfAggregate.getParentRQPQuery();
        List<RQPDataItemRef> diRefs = ExpressionAnalyzer.getAllReferences(parentRQPQuery.getProjectionList());
        for (RQPDataItemRef reference : diRefs) {
            RQPQuery refQuery = reference.getQuery();
            if (!refQuery.getName().equals(queryOfAggregate.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean aggregateExpressionIsFromLowestLevelSummaryQuery(V5AggregateFunction aggregate) {
        RQPQuery lowestLevelSummaryQuery;
        RQPQuery queryOfAggregate = RQPNode.getRQPQuery(aggregate);
        return queryOfAggregate == (lowestLevelSummaryQuery = queryOfAggregate.getLowestLevelSummaryQuery());
    }

    protected boolean aggregateContainsNestedStandardAggregate(V5AggregateFunction aggregate) {
        if (aggregate.getNumberChildren() == 0) {
            return false;
        }
        return ExpressionAnalyzer.exprOrRefExprHasStandardAggregate(aggregate.getChild(0));
    }

    protected boolean containsNestedAggregateCandidateForRewrite(V5AggregateFunction aggregate) {
        if (aggregate.getNumberChildren() == 0) {
            return false;
        }
        ArrayList<IXQEQueryNode> aggregates = new ArrayList<IXQEQueryNode>();
        DetectNoOpAggregates.getTopAggregatesOfType(aggregate.getChildren(), 201031, aggregates);
        return aggregates.size() > 0;
    }

    private RQPDataItemRef getOrCreateAggregateInLowestLevelSQ(PlanningEnvironment environment, IXQEQueryNode node, RQPQuery lowestLevelSQ, int subtype, IXQEQueryNode operand) {
        V5AggregateFunction aggrInLowestLevelSQ = (V5AggregateFunction)environment.getNodeFactory().createNode(201031);
        aggrInLowestLevelSQ.setSubType(subtype);
        aggrInLowestLevelSQ.addChild(operand);
        String suggestedName = RQPDataItem.getRQPDataItemNameForAggregateType(subtype);
        return this.getOrCreateAggregateInLowestLevelSQ(environment, node, lowestLevelSQ, aggrInLowestLevelSQ, suggestedName);
    }

    private RQPDataItemRef getOrCreateAggregateInLowestLevelSQ(PlanningEnvironment environment, IXQEQueryNode node, RQPQuery lowestLevelSQ, V5AggregateFunction aggrFunc, IXQEQueryNode operand) {
        V5AggregateFunction aggrInLowestLevelSQ = (V5AggregateFunction)environment.getNodeFactory().createNode(201031);
        aggrInLowestLevelSQ.setSubType(aggrFunc.getSubType());
        aggrInLowestLevelSQ.setName(aggrFunc.getName());
        aggrInLowestLevelSQ.setNativeName(aggrFunc.getNativeName());
        aggrInLowestLevelSQ.addChild(operand);
        String suggestedName = RQPDataItem.getRQPDataItemNameForAggregateType(aggrFunc.getSubType());
        return this.getOrCreateAggregateInLowestLevelSQ(environment, node, lowestLevelSQ, aggrInLowestLevelSQ, suggestedName);
    }

    public RQPDataItemRef getOrCreateAggregateInLowestLevelSQ(PlanningEnvironment environment, IXQEQueryNode node, RQPQuery lowestLevelSQ, V5AggregateFunction aggrInLowestLevelSQ, String suggestedName) {
        IQuerySubject qs = this.getNestedAggregateReferenceToDynamicQS(node);
        if (qs != null) {
            return this.createAggregateInDynamicSQS(environment, qs, (V5AggregateFunction)node, aggrInLowestLevelSQ, suggestedName);
        }
        RQPQuery llSQ = lowestLevelSQ;
        while (llSQ.getType() == 801017) {
            llSQ = llSQ.getLowestLevelSummaryQuery();
        }
        RQPDataItem aggregateInLowestLevelSQ = llSQ.getRQPDataItem(environment, (IXQEQueryNode)aggrInLowestLevelSQ, suggestedName);
        this.castOperandOfDivideOrMultiplyIfNeeded(environment, aggregateInLowestLevelSQ);
        RQPDataItemRef refToLLSQAggregate = RQPDataItemRef.create(environment, aggregateInLowestLevelSQ);
        if (lowestLevelSQ.getType() == 801017) {
            while (llSQ != lowestLevelSQ) {
                llSQ = (RQPQuery)llSQ.getAncestorOfType(801017);
                RQPDataItem rqpDataItem = llSQ.getRQPDataItem(environment, (IXQEQueryNode)refToLLSQAggregate, refToLLSQAggregate.getName());
                refToLLSQAggregate = RQPDataItemRef.create(environment, rqpDataItem);
            }
        }
        return refToLLSQAggregate;
    }

    private RQPDataItemRef createAggregateInDynamicSQS(PlanningEnvironment environment, IQuerySubject qs, V5AggregateFunction inAggr, V5AggregateFunction nestedAggr, String suggestedName) {
        RQPDataItemRef operand = (RQPDataItemRef)inAggr.getChild(0);
        RQPDataItem di = operand.getReferencedItem();
        V5BoundModelIdentifier expr = (V5BoundModelIdentifier)di.getExpression();
        IQueryItem exprQI = (IQueryItem)expr.getMetadata();
        String expression = null;
        boolean setBinaryExpr = true;
        if ((inAggr.getSubType() == 7 || inAggr.getSubType() == 10) && nestedAggr.getSubType() == 9 && nestedAggr.getChild(0) instanceof V5ValueExpression) {
            expression = new StringBuffer("CAST(").append(exprQI.getExpression()).append("*").append(exprQI.getExpression()).append(" AS DOUBLE PRECISION)").toString();
            setBinaryExpr = false;
        }
        if (expression == null) {
            expression = exprQI.getExpression();
        }
        IXQEQueryNode binaryExpression = null;
        if (setBinaryExpr && exprQI instanceof MoserQueryItem) {
            binaryExpression = (IXQEQueryNode)((MoserQueryItem)exprQI).getBinaryExpression();
        }
        MoserQuerySubject moserQS = (MoserQuerySubject)qs;
        IQueryItem qi = moserQS.getOrCreateQueryItem(V5AggregateFunctionSubtype.getName(nestedAggr.getSubType()), "fact", expression, binaryExpression, suggestedName);
        V5BoundModelIdentifier boundID = (V5BoundModelIdentifier)environment.getNodeFactory().createNode(201116);
        boundID.setMetadata(qi);
        boundID.setIdentifier(qi.getV5UniqueName());
        RQPDataItemRef ref2 = (RQPDataItemRef)inAggr.getChild(0).getFirstDescendantOfTypeOrdered(801009, true);
        RQPQuery tq0 = ref2.getQuery();
        RQPDataItem diTQ0 = tq0.getRQPDataItem(environment, (IXQEQueryNode)boundID, suggestedName);
        return RQPDataItemRef.create(environment, diTQ0);
    }

    protected V5CastFunction castToDouble(PlanningEnvironment environment, IXQEQueryNode castOperand) {
        V5CastFunction castToDouble = (V5CastFunction)environment.getNodeFactory().createNode(201051);
        castToDouble.addChild(castOperand);
        V5CastTarget castTarget = (V5CastTarget)environment.getNodeFactory().createNode(201052);
        castTarget.setDataType(DataTypeFactory.getDoubleType());
        castToDouble.addChild(castTarget);
        return castToDouble;
    }

    protected V5AggregateFunction createCountX(PlanningEnvironment environment, IXQEQueryNode node, RQPQuery lowestLevelSQ, IXQEQueryNode aggrOperand) {
        return this.createNestedAggregate(environment, node, lowestLevelSQ, 9, 2, aggrOperand);
    }

    protected V5AggregateFunction createNestedAggregate(PlanningEnvironment environment, IXQEQueryNode node, RQPQuery lowestLevelSQ, int aggrXType, int aggrYType, IXQEQueryNode aggrOperand) {
        V5AggregateFunction aggrX = (V5AggregateFunction)environment.getNodeFactory().createNode(201031);
        aggrX.setSubType(aggrXType);
        RQPDataItemRef refToAggrY = this.getOrCreateAggregateInLowestLevelSQ(environment, node, lowestLevelSQ, aggrYType, aggrOperand);
        aggrX.addChild(refToAggrY);
        return aggrX;
    }

    protected V5AggregateFunction createNestedAggregate(PlanningEnvironment environment, IXQEQueryNode node, RQPQuery lowestLevelSQ, V5AggregateFunction aggrFunc, IXQEQueryNode aggrOperand) {
        V5AggregateFunction aggrX = (V5AggregateFunction)environment.getNodeFactory().createNode(201031);
        aggrX.setSubType(aggrFunc.getSubType());
        aggrX.setName(aggrFunc.getName());
        aggrX.setNativeName(aggrFunc.getNativeName());
        RQPDataItemRef refToAggrY = this.getOrCreateAggregateInLowestLevelSQ(environment, node, lowestLevelSQ, aggrFunc, aggrOperand);
        aggrX.addChild(refToAggrY);
        return aggrX;
    }

    protected V5AggregateFunction createSumX(PlanningEnvironment environment, IXQEQueryNode node, RQPQuery lowestLevelSQ, IXQEQueryNode aggrOperand) {
        return this.createNestedAggregate(environment, node, lowestLevelSQ, 9, 9, aggrOperand);
    }

    protected V5ValueExpression doMultiply(PlanningEnvironment environment, IXQEQueryNode operandX, IXQEQueryNode operandY) {
        return this.doArithmeticOp(environment, 4, operandX, operandY);
    }

    protected V5ValueExpression doSubtract(PlanningEnvironment environment, IXQEQueryNode operandX, IXQEQueryNode operandY) {
        return this.doArithmeticOp(environment, 1, operandX, operandY);
    }

    protected V5ValueExpression doDivide(PlanningEnvironment environment, IXQEQueryNode operandX, IXQEQueryNode operandY) {
        return this.doArithmeticOp(environment, 3, operandX, operandY);
    }

    private void castToDoubleIfNeeded(PlanningEnvironment environment, IXQEQueryNode firstOperand, IXQEQueryNode secondOperand) {
        if (this.isNumericButNotDecimalNorDoubleDataType(firstOperand) && this.isNumericButNotDecimalNorDoubleDataType(secondOperand)) {
            IXQEQueryNode parent = firstOperand.getParent();
            firstOperand.detach();
            V5CastFunction castedExpr = this.castToDouble(environment, firstOperand);
            parent.addChild(castedExpr, 0);
        }
    }

    protected boolean isNumericButNotDecimalNorDoubleDataType(IXQEQueryNode node) {
        IDataType dt = RQPUtilities.getNodeDataType(node);
        if (dt != null) {
            if (dt.isNumeric() && dt.getCCLTypeCode() != 12 && dt.getCCLTypeCode() != 11) {
                return true;
            }
        } else {
            ArrayList<IXQEQueryNode> ids = new ArrayList<IXQEQueryNode>();
            ExpressionAnalyzer.getAllReferencedModelID(node, ids);
            for (IXQEQueryNode id : ids) {
                dt = RQPUtilities.getNodeDataType(id);
                if (dt == null) {
                    return true;
                }
                if (!dt.isNumeric() || dt.getCCLTypeCode() == 12 || dt.getCCLTypeCode() == 11) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExactNumericType(IXQEQueryNode node) {
        IDataType dtOper = RQPUtilities.getNodeDataType(node);
        if (dtOper != null && dtOper.isExactNumeric()) {
            return true;
        }
        boolean bIsExactNumeric = false;
        ArrayList<IXQEQueryNode> ids = new ArrayList<IXQEQueryNode>();
        ExpressionAnalyzer.getAllReferencedModelID(node, ids);
        for (IXQEQueryNode id : ids) {
            IDataType dt = RQPUtilities.getNodeDataType(id);
            if (dt == null) {
                return false;
            }
            if (dt.isExactNumeric()) {
                bIsExactNumeric = true;
                continue;
            }
            bIsExactNumeric = false;
            break;
        }
        return bIsExactNumeric;
    }

    private V5ValueExpression doArithmeticOp(PlanningEnvironment environment, int arithmeticOperator, IXQEQueryNode operandX, IXQEQueryNode operandY) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5ValueExpression arithmeticExpr = (V5ValueExpression)nodeFactory.createNode(201014);
        arithmeticExpr.setSubType(arithmeticOperator);
        arithmeticExpr.addChild(operandX);
        arithmeticExpr.addChild(operandY);
        return arithmeticExpr;
    }

    private boolean castOperandOfMultiplyToDoubleFromAdvancedProperty() {
        if (castOperandOfMultiplyToDouble != null) {
            return castOperandOfMultiplyToDouble;
        }
        String advancedPropertiesStr = "advancedProperties";
        String flag = XQEConfiguration.getParameterValueFromCCLConfig("advancedProperties", "CastOperandOfMultiplyToDouble", "");
        castOperandOfMultiplyToDouble = flag.toLowerCase().equals("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return castOperandOfMultiplyToDouble;
    }

    protected void castOperandOfDivideOrMultiplyIfNeeded(PlanningEnvironment environment, IXQEQueryNode expr) {
        IXQEQueryNode[] divOrMultOperations;
        for (IXQEQueryNode o : divOrMultOperations = expr.getDescendantsOfType(201014, true)) {
            Governors.ExactNumericDivision exactNumericDivision;
            V5ValueExpression oper = (V5ValueExpression)o;
            int subType = oper.getSubType();
            if (subType != 4 && subType != 3) continue;
            if (this.isExactNumericType(oper.getChild(0)) && this.isExactNumericType(oper.getChild(1)) && (subType == 4 ? !this.castOperandOfMultiplyToDoubleFromAdvancedProperty() : (exactNumericDivision = expr.getGovernors().getExactNumericDivision()) == Governors.ExactNumericDivision.DO_NOT_ADJUST)) {
                return;
            }
            this.castToDoubleIfNeeded(environment, oper.getChild(0), oper.getChild(1));
        }
    }

    private boolean minOverMedianInTabQuery(V5AggregateFunction aggregate) {
        if (aggregate.getSubType() != 6) {
            return false;
        }
        IXQEQueryNode operand = aggregate.getChild(0);
        if (operand.getType() != 801009) {
            return false;
        }
        RQPDataItemRef operandRef = (RQPDataItemRef)operand;
        if (operandRef.getQuery().getType() != 801025) {
            return false;
        }
        RQPDataItem tabItem = operandRef.getReferencedItem();
        IXQEQueryNode nestedAgg = tabItem.getExpression();
        return ExpressionAnalyzer.isStandardAggregate(nestedAgg) && ((V5AggregateFunction)nestedAgg).getSubType() == 5;
    }

    public static boolean hasDescendantRQPSummaryQuery(RQPQuery query) {
        RQPQuery llSQ = query;
        while (llSQ.getType() == 801017) {
            if ((llSQ = llSQ.getLowestLevelSummaryQuery()) != null) continue;
            return false;
        }
        return true;
    }

    protected boolean aggregateReferencesAggregateInDynamicSQS(IXQEQueryNode node) {
        return this.getNestedAggregateReferenceToDynamicQS(node) != null;
    }

    protected IQuerySubject getNestedAggregateReferenceToDynamicQS(IXQEQueryNode node) {
        if (node.getNumberChildren() < 1) {
            return null;
        }
        IXQEQueryNode operand = node.getChild(0);
        if (operand.getType() != 801009) {
            return null;
        }
        RQPDataItemRef ref = (RQPDataItemRef)operand;
        RQPDataItem di = ref.getReferencedItem();
        IXQEQueryNode expr = di.getExpression();
        if (expr.getType() != 201116) {
            return null;
        }
        IMetadata md = ((V5BoundModelIdentifier)expr).getMetadata();
        if (md.getObjectType() != MetadataType.QUERY_ITEM) {
            return null;
        }
        IQueryItem qi = (IQueryItem)md;
        IQuerySubject qs = qi.getQuerySubject();
        if (!(qs instanceof MoserQuerySubject)) {
            return null;
        }
        if (SummaryQuerySubjectUtilities.isSummaryQuerySubject(qs)) {
            return qs;
        }
        return null;
    }
}

