/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.OData.ODataUtilities;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class RewriteAggregateToAvoidDoubleCountingOData
extends RQPTransformation {
    private static final String APPLIED = "appliedforODATA";

    public RewriteAggregateToAvoidDoubleCountingOData() {
        this.mName = "RewriteAggregateToAvoidDoubleCountingOData";
        this.mPassNumbers = new int[]{96};
        this.mTypes = new int[]{201031};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(APPLIED, Boolean.TRUE);
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        aggregate.setDistinct(true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        if (aggregate.getNumberChildren() == 0) {
            return false;
        }
        if (aggregate.getAncestorOfType(101072) != null) {
            this.traceNodeCondition(false, "The transformation is not applicable for a DMR prePlan query.", xqeTrace);
            return false;
        }
        if (aggregate.getDistinct()) {
            this.traceNodeCondition(false, "The transformation is not applicable for this distinct-aggregate.", xqeTrace);
            return false;
        }
        if (aggregate.getSubType() == 4 || aggregate.getSubType() == 6) {
            this.traceNodeCondition(false, "MAX and MIN don't get double-counted.", xqeTrace);
            return false;
        }
        Boolean bApplied = (Boolean)node.getPropertyValue(APPLIED);
        if (Boolean.TRUE == bApplied) {
            this.traceNodeCondition(false, "The transformation is alreay applied.", xqeTrace);
            return false;
        }
        int[] types = new int[]{801024, 801012};
        RQPQuery queryOfAggregate = (RQPQuery)node.getAncestorOfTypes(types);
        if (queryOfAggregate == null) {
            this.traceNodeCondition(false, "The aggregate is not in the Summary Query.", xqeTrace);
            return false;
        }
        RQPQuery outerQuery = queryOfAggregate.getParentRQPQuery();
        RQPQuery llsq = outerQuery.getLowestLevelSummaryQuery();
        if (queryOfAggregate != llsq) {
            this.traceNodeCondition(false, "The aggregate is not in the lowest-level summary query.", xqeTrace);
            return false;
        }
        HashSet<IMetadata> involvedItemsAggregate = new HashSet<IMetadata>();
        IQuerySubject qs1 = this.getQuerySubjectAndInvolvedQueryItem(aggregate.getChild(0), involvedItemsAggregate, llsq);
        if (qs1 == null || involvedItemsAggregate.isEmpty()) {
            this.traceNodeCondition(false, "The aggregate uses literal.", xqeTrace);
            return false;
        }
        IQuerySubject.QuerySubjectTypeEnum qsType = qs1.getQuerySubjectType();
        if (IQuerySubject.QuerySubjectTypeEnum.DBQSASVIEW != qsType) {
            this.traceNodeCondition(false, "not  simple DBQuery.", xqeTrace);
            return false;
        }
        if (!ODataUtilities.isUsingOData(environment)) {
            this.traceNodeCondition(false, "not ODATA source.", xqeTrace);
            return false;
        }
        HashSet<IMetadata> involvedItemsQuery = new HashSet<IMetadata>();
        IQuerySubject qs2 = this.getQuerySubjectAndInvolvedQueryItem(llsq, involvedItemsQuery, llsq);
        if (qs1 != qs2) {
            this.traceNodeCondition(false, "not ODATA case.", xqeTrace);
            return false;
        }
        HashSet<IMetadata> rtQuerySubjects = new HashSet<IMetadata>();
        boolean b = ODataUtilities.getQuerySubjectAndMultiSetFoldersAndRelationships(qs1, rtQuerySubjects, null);
        if (!b || rtQuerySubjects.size() <= 1) {
            this.traceNodeCondition(false, "not ODATA model structure.", xqeTrace);
            return false;
        }
        TreeSet<IMetadata> maxQSAggregate = this.getLowestQuerySubject(environment, qs1, involvedItemsAggregate);
        TreeSet<IMetadata> maxQSQuery = this.getLowestQuerySubject(environment, qs1, involvedItemsQuery);
        if (maxQSAggregate == null || maxQSQuery == null || maxQSAggregate.isEmpty() || maxQSQuery.isEmpty()) {
            this.traceNodeCondition(false, "many to many.", xqeTrace);
            return false;
        }
        TreeSet<IMetadata> tmp = new TreeSet<IMetadata>((SortedSet<IMetadata>)maxQSAggregate);
        tmp.retainAll(maxQSQuery);
        if (tmp.isEmpty()) {
            tmp.addAll(maxQSAggregate);
            tmp.addAll(maxQSQuery);
            TreeSet<IMetadata> newLowest = this.getLowestQuerySubject(environment, qs1, tmp);
            tmp.clear();
            tmp.addAll(maxQSAggregate);
            tmp.retainAll(newLowest);
            if (tmp.isEmpty()) {
                this.traceNodeCondition(true, "The aggregate will be rewritten to avoid double-counting.", xqeTrace);
                return true;
            }
        }
        this.traceNodeCondition(false, "No double-counting.", xqeTrace);
        return false;
    }

    private IQuerySubject getQuerySubjectAndInvolvedQueryItem(IXQEQueryNode node, Set<IMetadata> involvedItems, RQPQuery thisQuery) {
        IXQEQueryNode[] diRefs;
        IQuerySubject qs = null;
        for (IXQEQueryNode diRef : diRefs = node.getDescendantsOfType(801009, true)) {
            IXQEQueryNode[] objs;
            RQPQuery refQuery = ((RQPDataItemRef)diRef).getQuery();
            if (refQuery == thisQuery || refQuery.getType() != 801025) continue;
            RQPDataItem rqpDataItem = ((RQPDataItemRef)diRef).getReferencedItem();
            for (IXQEQueryNode obj : objs = rqpDataItem.getDescendantsOfType(201116, false)) {
                V5BoundModelIdentifier modelObj = (V5BoundModelIdentifier)obj;
                if (!modelObj.isQueryItem()) continue;
                IQuerySubject theParentQS = modelObj.getQuerySubject();
                if (qs == null) {
                    qs = theParentQS;
                } else if (qs != theParentQS) {
                    return null;
                }
                involvedItems.add(modelObj.getMetadata());
            }
        }
        return qs;
    }

    private TreeSet<IMetadata> getLowestQuerySubject(PlanningEnvironment environment, IQuerySubject qs, Set<IMetadata> involvedItems) {
        HashSet<IMetadata> involvedQS = new HashSet<IMetadata>();
        FactFinder ff = ODataUtilities.createFactFinder(environment, qs, involvedItems, involvedQS);
        if (ff == null) {
            if (involvedQS.isEmpty()) {
                return null;
            }
            return new TreeSet<IMetadata>(involvedQS);
        }
        if (ff.getNumberOfFacts() > 1) {
            return null;
        }
        TreeSet<IMetadata> factQuerySubjects = new TreeSet<IMetadata>();
        ff.getFactQuerySubjects(factQuerySubjects);
        return factQuerySubjects;
    }
}

