/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.optimization.RewriteAggregateInTermsOfLowestScope;

public class RewriteMaxMinSumInTermsOfLowestScope
extends RewriteAggregateInTermsOfLowestScope {
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        RQPQuery lowestLevelSQ = rqpQuery.getLowestLevelSummaryQuery();
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        IXQEQueryNode oper = aggregate.getChild(0);
        if (oper.getType() == 801009) {
            aggregate.removeProperty("distinct");
            aggregate.removeProperty("prefilter");
            aggregate.removeProperty("rollupAggregateNode");
            RQPDataItem dataItem = (RQPDataItem)aggregate.getAncestorOfType(801008);
            if (dataItem == null || !dataItem.isGroupingItem()) {
                int numChild = aggregate.getNumberChildren();
                for (int i = numChild - 1; i > 0; --i) {
                    aggregate.getChild(i).detach();
                }
            }
            this.updateAggrOperand(environment, lowestLevelSQ, aggregate);
        } else {
            aggregate.exchange(this.createNestedAggregate(environment, node, lowestLevelSQ, aggregate, environment.getNodeFactory().deepCopyNode(oper)));
        }
    }

    private void updateAggrOperand(PlanningEnvironment environment, RQPQuery lowestLevelSQ, V5AggregateFunction aggregate) {
        RQPDataItemRef rqpDataItemRef = this.getOrCreateAggregateInLowestLevelSQ(environment, aggregate, lowestLevelSQ, aggregate, RQPDataItem.getRQPDataItemNameForAggregateType(aggregate.getSubType()));
        RQPDataItemRef operand = (RQPDataItemRef)aggregate.getChild(0);
        operand.setQueryName(rqpDataItemRef.getQueryName());
        operand.setName(rqpDataItemRef.getName());
        V5AggregateBreakClause forClause = aggregate.getForClause();
        if (forClause != null) {
            for (IXQEQueryNode forClauseItem : forClause.getChildren()) {
                RQPDataItem projItem = lowestLevelSQ.getProjectionWithSameExprAsTheGroupingExpression(forClauseItem);
                if (projItem == null) continue;
                RQPDataItemRef dataItemRef = RQPDataItemRef.create(environment, lowestLevelSQ.getName(), projItem.getName());
                forClauseItem.exchange(dataItemRef);
            }
        }
    }

    @Override
    public boolean isApplicableForAggregate(V5AggregateFunction aggregate) {
        switch (aggregate.getSubType()) {
            case 4: 
            case 6: 
            case 9: {
                return true;
            }
            case 43: {
                return aggregate.isDecomposable();
            }
        }
        return false;
    }
}

