/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class RewriteSummariesAsWindowedAggregates
extends RQPTransformation {
    public RewriteSummariesAsWindowedAggregates() {
        this.mName = "RewriteSummariesAsWindowedAggregates";
        this.mPassNumbers = new int[]{97};
        this.mTypes = new int[]{801009};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPDataItemRef rqpDataItemRef = (RQPDataItemRef)node;
        RQPDataItem refRQPDataItem = rqpDataItemRef.getNextReferencedItem();
        IXQEQueryNode refExpr = refRQPDataItem.getExpression();
        IXQEQueryNode refExprClone = environment.getNodeFactory().deepCopyNode(refExpr);
        rqpDataItemRef.exchange(refExprClone);
        RQPSummaryQuery summaryQuery = (RQPSummaryQuery)RQPNode.getRQPQuery(refRQPDataItem);
        RQPGroupByList groupByList = (RQPGroupByList)summaryQuery.getFirstChildByType(801013);
        IXQEQueryNode[] standardAggregates = refExprClone.getDescendantsOfType(201031, true);
        for (int i = 0; i < standardAggregates.length; ++i) {
            V5AggregateFunction aggregate = (V5AggregateFunction)standardAggregates[i];
            if (aggregate.getForClause() != null) continue;
            RewriteSummariesAsWindowedAggregates.addForClause(environment, aggregate, groupByList);
        }
    }

    public static void addForClause(PlanningEnvironment environment, V5AggregateFunction aggregate, RQPGroupByList groupByList) {
        V5AggregateBreakClause forClause = aggregate.getForClause();
        if (forClause == null) {
            forClause = (V5AggregateBreakClause)environment.getNodeFactory().createNode(201037);
            aggregate.addChild(forClause);
        }
        if (groupByList != null) {
            for (int i = 0; i < groupByList.getNumberChildren(); ++i) {
                RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)groupByList.getChild(i);
                IXQEQueryNode pbExpr = environment.getNodeFactory().deepCopyNode(selfRef.getRefProjection().getExpression());
                forClause.addChild(pbExpr);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPDataItem rqpDataItem = (RQPDataItem)node.getAncestorOfType(801008);
        if (rqpDataItem == null) {
            this.traceNodeCondition(false, "DataItemRef has no dataItem ancestor.", xqeTrace);
            return false;
        }
        RQPQuery lowestLevelSQ = RQPNode.getRQPQuery(rqpDataItem).getLowestLevelSummaryQuery();
        RQPDataItemRef rqpDataItemRef = (RQPDataItemRef)node;
        RQPQuery refQuery = rqpDataItemRef.getQuery();
        Governors govs = refQuery.getGovernors();
        if (govs != null && govs.getWindowFunctionGeneration() == Governors.SQLWindowFunctionGeneration.GROUPBY) {
            this.traceNodeCondition(false, "use group by instead of partition by.", xqeTrace);
            return false;
        }
        if (refQuery == lowestLevelSQ) {
            this.traceNodeCondition(false, "The dataItemRef query is the lowest level Summary Query", xqeTrace);
            return false;
        }
        if (refQuery.getType() != 801012 && refQuery.getType() != 801024) {
            String failReason = "Not a reference to an item in a footer or summary query.";
            this.traceNodeCondition(false, failReason, xqeTrace);
            return false;
        }
        RQPQuery parentQuery = RQPNode.getRQPQuery(rqpDataItemRef);
        if (!parentQuery.getCanRewriteAsWindowedAggregates()) {
            String failReason = "Some data items in parent query are not in terms of lowest-level summary query.";
            this.traceNodeCondition(false, failReason, xqeTrace);
            return false;
        }
        if (!refQuery.getCanRewriteAsWindowedAggregates()) {
            String failReason = "Some aggregates not computed over lowest level summary query.";
            this.traceNodeCondition(false, failReason, xqeTrace);
            return false;
        }
        if (refQuery.isSummaryQueryToAvoidDoubleCounting()) {
            String failReason = "RQPDataItem is referencing summary query to avoid double-counting.";
            this.traceNodeCondition(false, failReason, xqeTrace);
            return false;
        }
        IXQEQueryNode aggr = rqpDataItemRef.getAncestorOfTypeWithAnchor(201031, 801008);
        if (aggr != null && aggr.getFirstChildByType(201037) == null) {
            this.traceNodeCondition(false, "Reference is under a standard aggregate.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "Non-lowest level aggregate will be rewritten as windowed aggregate.", xqeTrace);
        return true;
    }
}

