/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.datasets.DatasetInfoExtended;
import java.util.List;

public class SetAggregateTypeInFeedback
extends RQPTransformation {
    private static final String SET_AGGREGATE_TYPE_APPLIED = "setAggregateTypeApplied";

    public SetAggregateTypeInFeedback() {
        this.mName = "Set AggregateType In feedback";
        this.mPassNumbers = new int[]{95};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(SET_AGGREGATE_TYPE_APPLIED, Boolean.TRUE);
        RQPQuery rqpQuery = (RQPQuery)node;
        RSAPIDataset rsapiDataset = (RSAPIDataset)rqpQuery.getAncestorOfType(401005);
        DatasetInfoExtended exDataSetInfo = rsapiDataset.addExtendedDatasetInfoIfNotExist();
        if (!rqpQuery.isAutoSummaryFALSE()) {
            this.setAggregateTypeForAggregatedQuery(rsapiDataset, exDataSetInfo, rqpQuery, environment);
        } else {
            this.setAggregateTypeForDetailQuery(rsapiDataset, exDataSetInfo, rqpQuery, environment);
        }
        RQPProjectionList projection = rqpQuery.getProjectionList();
        for (IXQEQueryNode c : projection.getChildrenOfType(801008)) {
            RQPDataItem dataItem = (RQPDataItem)c;
            RSAPIDataItem rsapiDataItem = (RSAPIDataItem)dataItem.getPropertyValue("RSAPIRefDataItem");
            List<String> dependency = rsapiDataItem.getDependency();
            if (dependency == null || dependency.isEmpty()) continue;
            exDataSetInfo.addColumnDependency(rsapiDataItem.getName(), dependency);
        }
    }

    protected RefineAutomaticXtab.AggrTypeEnum normalizedAggregateType(RefineAutomaticXtab.AggrTypeEnum aggr) {
        if (aggr == RefineAutomaticXtab.AggrTypeEnum.NONE || aggr == RefineAutomaticXtab.AggrTypeEnum.TOTAL || aggr == RefineAutomaticXtab.AggrTypeEnum.MAX || aggr == RefineAutomaticXtab.AggrTypeEnum.MIN) {
            return aggr;
        }
        if (aggr == RefineAutomaticXtab.AggrTypeEnum.COUNT) {
            return RefineAutomaticXtab.AggrTypeEnum.TOTAL;
        }
        return RefineAutomaticXtab.AggrTypeEnum.MIN;
    }

    protected String getResolvedAggregateFromModel(PlanningEnvironment environment, RQPDataItem column) {
        IXQEQueryNode expr = column.getExpression();
        while (expr.getType() == 801009) {
            RQPDataItem refItem = ((RQPDataItemRef)expr).getReferencedItem();
            expr = refItem.getExpression();
        }
        RefineAutomaticXtab.AggrTypeEnum aggrType = RefineAutomaticXtab.determineAggrType(environment, expr, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
        aggrType = this.normalizedAggregateType(aggrType);
        return aggrType.getV5Name();
    }

    protected void setAggregateTypeForDetailQuery(RSAPIDataset rsapiDataSet, DatasetInfoExtended exDataSetInfo, RQPQuery rqpQuery, PlanningEnvironment environment) {
        RSAPIEdge[] edges = rsapiDataSet.getEdges();
        RSAPIEdgeRowset rowset = edges[0].getRowsets()[0];
        for (RSAPIDataItem rsapiDataItem : rowset.getDataItems()) {
            String dataItemName = rsapiDataItem.getName();
            RQPDataItem rqpDataItem = rqpQuery.getRQPDataItemByName(dataItemName);
            if (rqpDataItem == null) continue;
            DatasetInfoExtended.ColumnInfoExtended exColumn = exDataSetInfo.addColumn(dataItemName);
            exColumn.setAggregate(this.getResolvedAggregateFromModel(environment, rqpDataItem));
        }
    }

    protected String getResolvedAggregate(RQPDataItem column) {
        if (column.isGroupingItem()) {
            return "none";
        }
        IXQEQueryNode expr = column.getExpression();
        while (expr.getType() == 801009) {
            RQPDataItem refItem = ((RQPDataItemRef)expr).getReferencedItem();
            expr = refItem.getExpression();
        }
        if (expr.getType() != 201031) {
            return "minimum";
        }
        V5ValueSummaryFunction func = (V5ValueSummaryFunction)expr;
        int subType = func.getSubType();
        switch (subType) {
            case 2: {
                if (func.getDistinct()) {
                    return "minimum";
                }
                return "total";
            }
            case 4: {
                return "maximum";
            }
            case 6: {
                return "minimum";
            }
            case 9: {
                return "total";
            }
        }
        return "minimum";
    }

    protected void setAggregateTypeForAggregatedQuery(RSAPIDataset rsapiDataSet, DatasetInfoExtended exDataSetInfo, RQPQuery rqpQuery, PlanningEnvironment environment) {
        RSAPIEdge[] edges = rsapiDataSet.getEdges();
        RSAPIEdgeRowset rowset = edges[0].getRowsets()[0];
        for (RSAPIDataItem rsapiDataItem : rowset.getDataItems()) {
            String dataItemName = rsapiDataItem.getName();
            RQPDataItem rqpDataItem = rqpQuery.getRQPDataItemByName(dataItemName);
            if (rqpDataItem == null) continue;
            DatasetInfoExtended.ColumnInfoExtended exColumn = exDataSetInfo.addColumn(dataItemName);
            exColumn.setAggregate(this.getResolvedAggregate(rqpDataItem));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean b = (Boolean)node.getPropertyValue(SET_AGGREGATE_TYPE_APPLIED);
        if (Boolean.TRUE == b) {
            return false;
        }
        RQPQuery rqpQuery = (RQPQuery)node;
        if (rqpQuery.getRootRQPQuery() != rqpQuery) {
            return false;
        }
        V5Query v5Query = rqpQuery.getRefV5Query();
        if (v5Query.isDMR()) {
            return false;
        }
        if (v5Query.isRelationalSubquery()) {
            return false;
        }
        if (v5Query.isROLAP()) {
            return false;
        }
        if (!v5Query.isTabular()) {
            return false;
        }
        RQPProjectionList projection = rqpQuery.getProjectionList();
        if (projection == null) {
            return false;
        }
        for (IXQEQueryNode proj : projection.getChildren()) {
            if (proj.getPropertyValue("RSAPIRefDataItem") != null) continue;
            return false;
        }
        RSAPIDataset rsapiDataset = (RSAPIDataset)rqpQuery.getAncestorOfType(401005);
        if (rsapiDataset == null || !rsapiDataset.queryFeedbackIsRequested("datasetInfoExtended")) {
            return false;
        }
        return SetAggregateTypeInFeedback.isSimpleList(rsapiDataset);
    }

    public static boolean isSimpleList(RSAPIDataset rsapiDataSet) {
        RSAPIEdge[] edges = rsapiDataSet.getEdges();
        if (edges.length != 1) {
            return false;
        }
        if (rsapiDataSet.getCellRowset() != null) {
            return false;
        }
        int nRowsets = edges[0].getNumRowsets();
        return nRowsets == 1;
    }
}

