/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.List;

public class SetLowestLevelSummaryQueryProperty
extends RQPTransformation {
    public SetLowestLevelSummaryQueryProperty() {
        this.mName = "Set Lowest level summary query property";
        this.mPassNumbers = new int[]{71};
        this.mTypes = new int[]{801017};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] subQueries;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rootQuery = (RQPQuery)node;
        for (IXQEQueryNode subQuery : subQueries = rootQuery.getSubqueryList().getChildren()) {
            RQPQuery rqpSubQuery = (RQPQuery)subQuery;
            if (!rqpSubQuery.isFactQuery()) continue;
            this.traceNodeCondition(false, "The root query is the root of multi-fact queries", xqeTrace);
            return false;
        }
        IXQEQueryNode subqueryList = rootQuery.getSubqueryList();
        if (subqueryList == null || subqueryList.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "Subquery list is null or empty.", xqeTrace);
            return false;
        }
        RQPQuery lowestLevelSQ = rootQuery.getLowestLevelSummaryQueryProperty();
        if (lowestLevelSQ != null) {
            this.traceNodeCondition(false, "The isLowestLevelSummaryQuery property is already set.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The isLowestLevelSummaryQuery property will be set for a RQPSummaryQuery.", xqeTrace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] subQueries;
        RQPQuery rootQuery = (RQPQuery)node;
        RQPQuery lowestLevelSummaryQuery = rootQuery.getLowestLevelSummaryQuery();
        rootQuery.setLowestLevelSummaryQueryProperty(lowestLevelSummaryQuery);
        if (rootQuery.isRelalionalSubqueryForFirstAndLast()) {
            rootQuery.setDistinct(true);
        }
        for (IXQEQueryNode subQuery : subQueries = rootQuery.getSubqueryList().getChildren()) {
            RQPQuery rqpSubQuery = (RQPQuery)subQuery;
            if (!rqpSubQuery.isAnalyticSubquery()) continue;
            List<RQPDataItem> groupingColumns = lowestLevelSummaryQuery.getProjectionsMarkedAsGroupingColumns();
            for (RQPDataItem item : groupingColumns) {
                RQPDataItem newItem = rqpSubQuery.createRQPDataItem(environment, item.getName());
                newItem.copyPropertiesFrom(item);
                newItem.addChild(environment.getNodeFactory().deepCopyNode(item.getExpression()));
            }
        }
    }
}

