/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.Governors;
import java.util.List;

public class SetRQPDataItemIsNullableForLowestLevelSummaryQuery
extends RQPTransformation {
    private static final String PROP_SET_ISNULLABLE_APPLIED = "SetIsNullabeApplied";

    public SetRQPDataItemIsNullableForLowestLevelSummaryQuery() {
        this.mName = "Set RQPDataItem IsNullable for Lowest Level Summary Query";
        this.mPassNumbers = new int[]{125};
        this.mTypes = new int[]{801017};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        if (rqpQuery.getPropertyValue(PROP_SET_ISNULLABLE_APPLIED) != null) {
            this.traceNodeCondition(false, "Set IsNullable is applied.", xqeTrace);
            return false;
        }
        Governors govs = rqpQuery.getGovernors();
        if (govs != null && govs.getSummaryQueryJoinOperator() != Governors.JoinOperator.EQUAL_ALL_NOTNULL) {
            this.traceNodeCondition(false, "not need to set IsNullable on RQPDataItem.", xqeTrace);
            return false;
        }
        RQPQuery lowestlevelQuery = rqpQuery.getLowestLevelSummaryQueryProperty();
        if (lowestlevelQuery == null || !lowestlevelQuery.getSubquerySources().isEmpty()) {
            this.traceNodeCondition(false, "not the lowest level leaf summary query.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "Set grouping RQPDataItem IsNullable for the lowest level leaf summary query .", xqeTrace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = (RQPQuery)node;
        rqpQuery.setPropertyValue(PROP_SET_ISNULLABLE_APPLIED, Boolean.TRUE);
        RQPQuery lowestlevelQuery = rqpQuery.getLowestLevelSummaryQueryProperty();
        IXQEQueryNode[] groupingItems = lowestlevelQuery.getGroupingItems();
        if (groupingItems == null) {
            return;
        }
        boolean bOuterJoin = this.queryHasOuterJoin(lowestlevelQuery);
        for (IXQEQueryNode grp : groupingItems) {
            IXQEQueryNode expr;
            RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)grp;
            RQPDataItem item = selfRef.getRefProjection();
            boolean isNullable = true;
            if (!bOuterJoin && (expr = item.getExpression()).isOfCategory(201120)) {
                isNullable = ((V5SimpleNode)expr).isNullable();
            }
            item.setIsNullableProperty(isNullable);
        }
    }

    private boolean queryHasOuterJoin(RQPQuery query) {
        IXQEQueryNode[] joinPath = query.getChildrenOfType(801039);
        if (joinPath.length == 0) {
            return false;
        }
        if (joinPath.length > 1) {
            return true;
        }
        List<IMetadata> joins = ((RQPJoinPath)joinPath[0]).getJoinPath();
        for (IMetadata join : joins) {
            IRelationship relationShip = (IRelationship)join;
            if (relationShip.getLeftCardinality() != IRelationship.Cardinality.ZERO_ONE && relationShip.getLeftCardinality() != IRelationship.Cardinality.ZERO_MANY && relationShip.getRightCardinality() != IRelationship.Cardinality.ZERO_ONE && relationShip.getRightCardinality() != IRelationship.Cardinality.ZERO_MANY) continue;
            return true;
        }
        return false;
    }
}

