/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SplitSummaryQueryToAvoidJoiningWithTabularQuery;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class SplitSummaryQueryWithRefsToSQAndTQ
extends SplitSummaryQueryToAvoidJoiningWithTabularQuery {
    public SplitSummaryQueryWithRefsToSQAndTQ() {
        this.mName = "SplitSummaryQueryWithRefsToSQAndTQ";
        this.mPassNumbers = new int[]{93};
        this.mTypes = new int[]{801024, 801012};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        super.apply(node, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.superPassesNodeCondition(node, environment)) {
            return false;
        }
        RQPQuery query = (RQPQuery)node;
        if (query.isLowestLevelSummaryQuery()) {
            return false;
        }
        return this.containsAggregatesToSQAndTQ(query);
    }

    private boolean containsAggregatesToSQAndTQ(RQPQuery query) {
        RQPProjectionList projList = query.getProjectionList();
        if (projList == null) {
            return false;
        }
        boolean containsRefToTQ = false;
        boolean containsStandaloneRefToSQ = false;
        for (int i = 0; i < projList.getNumberChildren(); ++i) {
            RQPDataItem projection = (RQPDataItem)projList.getChild(i);
            if (projection.isGroupingItem()) continue;
            IXQEQueryNode[] aggregates = ExpressionAnalyzer.getAggregateNodes(projection.getExpression());
            boolean projContainsRefToSQ = false;
            boolean projContainsRefToTQ = false;
            for (IXQEQueryNode a : aggregates) {
                IXQEQueryNode[] refs;
                for (IXQEQueryNode r : refs = a.getDescendantsOfType(801009, false)) {
                    RQPDataItemRef ref = (RQPDataItemRef)r;
                    RQPQuery refQuery = ref.getQuery();
                    if (refQuery.isSummarizedQuery()) {
                        projContainsRefToSQ = true;
                        continue;
                    }
                    if (refQuery.getType() != 801025) continue;
                    containsRefToTQ = true;
                    projContainsRefToTQ = true;
                }
            }
            if (projContainsRefToSQ && !projContainsRefToTQ) {
                containsStandaloneRefToSQ = true;
            }
            if (!containsStandaloneRefToSQ || !containsRefToTQ) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean conditionToMoveProjection(RQPDataItem projection, RQPSummaryQuery originalSummaryQuery) {
        return this.projectionHasReferenceToTQ0(projection, originalSummaryQuery);
    }

    private boolean projectionHasReferenceToTQ0(RQPDataItem projection, RQPSummaryQuery originalSummaryQuery) {
        IXQEQueryNode[] aggregates;
        for (IXQEQueryNode a : aggregates = ExpressionAnalyzer.getAggregateNodes(projection.getExpression())) {
            IXQEQueryNode[] refs;
            for (IXQEQueryNode r : refs = a.getDescendantsOfType(801009, false)) {
                RQPDataItemRef ref = (RQPDataItemRef)r;
                if (ref.getQuery().getType() != 801025) continue;
                return true;
            }
        }
        return false;
    }
}

