/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.prePlan;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class FixAggregateOnNonFacts
extends Transformation {
    public FixAggregateOnNonFacts(int[] passNumbers) {
        this.mName = "FixAggregateOnNonFacts";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem dataItem = (V5DataItem)node.getAncestorOfType(101003);
        String aggregateProperty = dataItem.getAggregateProperty();
        dataItem.setAggregateProperty(aggregateProperty);
        V5BoundModelIdentifier replacedNode = (V5BoundModelIdentifier)dataItem.getFirstDescendantOfTypeOrdered(201116, false);
        IMetadata md = replacedNode.getMetadata();
        String none = "none";
        if (md != null) {
            if (md.getObjectType() == MetadataType.QUERY_ITEM) {
                IQueryItem queryItem = (IQueryItem)md;
                if (!queryItem.isFact()) {
                    dataItem.setAggregateProperty(none);
                }
            } else if (md.getObjectType() == MetadataType.CALCULATION) {
                dataItem.setAggregateProperty(none);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode dataItem = node.getAncestorOfType(101003);
        if (dataItem == null) {
            this.traceNodeCondition(false, "The node must have a dataItem as ancestor.", trace);
            return false;
        }
        String aggregateProperty = ((V5DataItem)dataItem).getAggregateProperty();
        if (aggregateProperty != null && aggregateProperty.equals("calculated")) {
            this.traceNodeCondition(false, "Adjust the aggregate property", trace);
            return true;
        }
        return false;
    }
}

